// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.controlcatalog.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A summary of metadata for a domain.
 */
public class DomainSummary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) that identifies the domain.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * The time when the domain was created.
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createTime) { "A non-null value must be provided for createTime" }
    /**
     * The description of the domain.
     */
    public val description: kotlin.String = requireNotNull(builder.description) { "A non-null value must be provided for description" }
    /**
     * The time when the domain was most recently updated.
     */
    public val lastUpdateTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.lastUpdateTime) { "A non-null value must be provided for lastUpdateTime" }
    /**
     * The name of the domain.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.controlcatalog.model.DomainSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DomainSummary(")
        append("arn=$arn,")
        append("createTime=$createTime,")
        append("description=$description,")
        append("lastUpdateTime=$lastUpdateTime,")
        append("name=$name")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (createTime.hashCode())
        result = 31 * result + (description.hashCode())
        result = 31 * result + (lastUpdateTime.hashCode())
        result = 31 * result + (name.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DomainSummary

        if (arn != other.arn) return false
        if (createTime != other.createTime) return false
        if (description != other.description) return false
        if (lastUpdateTime != other.lastUpdateTime) return false
        if (name != other.name) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.controlcatalog.model.DomainSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) that identifies the domain.
         */
        public var arn: kotlin.String? = null
        /**
         * The time when the domain was created.
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the domain.
         */
        public var description: kotlin.String? = null
        /**
         * The time when the domain was most recently updated.
         */
        public var lastUpdateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the domain.
         */
        public var name: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.controlcatalog.model.DomainSummary) : this() {
            this.arn = x.arn
            this.createTime = x.createTime
            this.description = x.description
            this.lastUpdateTime = x.lastUpdateTime
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.controlcatalog.model.DomainSummary = DomainSummary(this)

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (createTime == null) createTime = Instant.fromEpochSeconds(0)
            if (description == null) description = ""
            if (lastUpdateTime == null) lastUpdateTime = Instant.fromEpochSeconds(0)
            if (name == null) name = ""
            return this
        }
    }
}
