// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.controlcatalog.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A summary of metadata for a common control.
 */
public class CommonControlSummary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) that identifies the common control.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * The time when the common control was created.
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createTime) { "A non-null value must be provided for createTime" }
    /**
     * The description of the common control.
     */
    public val description: kotlin.String = requireNotNull(builder.description) { "A non-null value must be provided for description" }
    /**
     * The domain that the common control belongs to.
     */
    public val domain: aws.sdk.kotlin.services.controlcatalog.model.AssociatedDomainSummary? = builder.domain
    /**
     * The time when the common control was most recently updated.
     */
    public val lastUpdateTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.lastUpdateTime) { "A non-null value must be provided for lastUpdateTime" }
    /**
     * The name of the common control.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The objective that the common control belongs to.
     */
    public val objective: aws.sdk.kotlin.services.controlcatalog.model.AssociatedObjectiveSummary? = builder.objective

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.controlcatalog.model.CommonControlSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CommonControlSummary(")
        append("arn=$arn,")
        append("createTime=$createTime,")
        append("description=$description,")
        append("domain=$domain,")
        append("lastUpdateTime=$lastUpdateTime,")
        append("name=$name,")
        append("objective=$objective")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (createTime.hashCode())
        result = 31 * result + (description.hashCode())
        result = 31 * result + (domain?.hashCode() ?: 0)
        result = 31 * result + (lastUpdateTime.hashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (objective?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CommonControlSummary

        if (arn != other.arn) return false
        if (createTime != other.createTime) return false
        if (description != other.description) return false
        if (domain != other.domain) return false
        if (lastUpdateTime != other.lastUpdateTime) return false
        if (name != other.name) return false
        if (objective != other.objective) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.controlcatalog.model.CommonControlSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) that identifies the common control.
         */
        public var arn: kotlin.String? = null
        /**
         * The time when the common control was created.
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the common control.
         */
        public var description: kotlin.String? = null
        /**
         * The domain that the common control belongs to.
         */
        public var domain: aws.sdk.kotlin.services.controlcatalog.model.AssociatedDomainSummary? = null
        /**
         * The time when the common control was most recently updated.
         */
        public var lastUpdateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the common control.
         */
        public var name: kotlin.String? = null
        /**
         * The objective that the common control belongs to.
         */
        public var objective: aws.sdk.kotlin.services.controlcatalog.model.AssociatedObjectiveSummary? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.controlcatalog.model.CommonControlSummary) : this() {
            this.arn = x.arn
            this.createTime = x.createTime
            this.description = x.description
            this.domain = x.domain
            this.lastUpdateTime = x.lastUpdateTime
            this.name = x.name
            this.objective = x.objective
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.controlcatalog.model.CommonControlSummary = CommonControlSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.controlcatalog.model.AssociatedDomainSummary] inside the given [block]
         */
        public fun domain(block: aws.sdk.kotlin.services.controlcatalog.model.AssociatedDomainSummary.Builder.() -> kotlin.Unit) {
            this.domain = aws.sdk.kotlin.services.controlcatalog.model.AssociatedDomainSummary.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.controlcatalog.model.AssociatedObjectiveSummary] inside the given [block]
         */
        public fun objective(block: aws.sdk.kotlin.services.controlcatalog.model.AssociatedObjectiveSummary.Builder.() -> kotlin.Unit) {
            this.objective = aws.sdk.kotlin.services.controlcatalog.model.AssociatedObjectiveSummary.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (createTime == null) createTime = Instant.fromEpochSeconds(0)
            if (description == null) description = ""
            if (lastUpdateTime == null) lastUpdateTime = Instant.fromEpochSeconds(0)
            if (name == null) name = ""
            return this
        }
    }
}
