// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connectparticipant.serde

import aws.sdk.kotlin.services.connectparticipant.model.ConnectParticipantException
import aws.sdk.kotlin.services.connectparticipant.model.StartAttachmentUploadResponse
import aws.sdk.kotlin.services.connectparticipant.model.UploadMetadata
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class StartAttachmentUploadOperationDeserializer: HttpDeserializer.NonStreaming<StartAttachmentUploadResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): StartAttachmentUploadResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwStartAttachmentUploadError(context, call, payload)
        }
        val builder = StartAttachmentUploadResponse.Builder()

        if (payload != null) {
            deserializeStartAttachmentUploadOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwStartAttachmentUploadError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ConnectParticipantException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ConnectParticipantException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeStartAttachmentUploadOperationBody(builder: StartAttachmentUploadResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ATTACHMENTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AttachmentId"))
    val UPLOADMETADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("UploadMetadata"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ATTACHMENTID_DESCRIPTOR)
        field(UPLOADMETADATA_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ATTACHMENTID_DESCRIPTOR.index -> builder.attachmentId = deserializeString()
                UPLOADMETADATA_DESCRIPTOR.index -> builder.uploadMetadata = deserializeUploadMetadataDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
