// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connectparticipant.serde

import aws.sdk.kotlin.services.connectparticipant.model.ConnectParticipantException
import aws.sdk.kotlin.services.connectparticipant.model.GetAttachmentResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetAttachmentOperationDeserializer: HttpDeserializer.NonStreaming<GetAttachmentResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetAttachmentResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetAttachmentError(context, call, payload)
        }
        val builder = GetAttachmentResponse.Builder()

        if (payload != null) {
            deserializeGetAttachmentOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetAttachmentError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ConnectParticipantException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ConnectParticipantException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetAttachmentOperationBody(builder: GetAttachmentResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val URL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Url"))
    val URLEXPIRY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("UrlExpiry"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(URL_DESCRIPTOR)
        field(URLEXPIRY_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                URL_DESCRIPTOR.index -> builder.url = deserializeString()
                URLEXPIRY_DESCRIPTOR.index -> builder.urlExpiry = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
