// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connectparticipant.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Fields to be used while uploading the attachment.
 */
public class UploadMetadata private constructor(builder: Builder) {
    /**
     * The headers to be provided while uploading the file to the URL.
     */
    public val headersToInclude: Map<String, String>? = builder.headersToInclude
    /**
     * This is the pre-signed URL that can be used for uploading the file to Amazon S3 when used in response to [StartAttachmentUpload](https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_StartAttachmentUpload.html).
     */
    public val url: kotlin.String? = builder.url
    /**
     * The expiration time of the URL in ISO timestamp. It's specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example, 2019-11-08T02:41:28.172Z.
     */
    public val urlExpiry: kotlin.String? = builder.urlExpiry

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connectparticipant.model.UploadMetadata = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UploadMetadata(")
        append("headersToInclude=$headersToInclude,")
        append("url=$url,")
        append("urlExpiry=$urlExpiry")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = headersToInclude?.hashCode() ?: 0
        result = 31 * result + (url?.hashCode() ?: 0)
        result = 31 * result + (urlExpiry?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UploadMetadata

        if (headersToInclude != other.headersToInclude) return false
        if (url != other.url) return false
        if (urlExpiry != other.urlExpiry) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connectparticipant.model.UploadMetadata = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The headers to be provided while uploading the file to the URL.
         */
        public var headersToInclude: Map<String, String>? = null
        /**
         * This is the pre-signed URL that can be used for uploading the file to Amazon S3 when used in response to [StartAttachmentUpload](https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_StartAttachmentUpload.html).
         */
        public var url: kotlin.String? = null
        /**
         * The expiration time of the URL in ISO timestamp. It's specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example, 2019-11-08T02:41:28.172Z.
         */
        public var urlExpiry: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connectparticipant.model.UploadMetadata) : this() {
            this.headersToInclude = x.headersToInclude
            this.url = x.url
            this.urlExpiry = x.urlExpiry
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connectparticipant.model.UploadMetadata = UploadMetadata(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
