// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connectparticipant.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * An item - message or event - that has been sent.
 */
public class Item private constructor(builder: Builder) {
    /**
     * The time when the message or event was sent.
     *
     * It's specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example, 2019-11-08T02:41:28.172Z.
     */
    public val absoluteTime: kotlin.String? = builder.absoluteTime
    /**
     * Provides information about the attachments.
     */
    public val attachments: List<AttachmentItem>? = builder.attachments
    /**
     * The contactId on which the transcript item was originally sent. This field is populated only when the transcript item is from the current chat session.
     */
    public val contactId: kotlin.String? = builder.contactId
    /**
     * The content of the message or event.
     */
    public val content: kotlin.String? = builder.content
    /**
     * The type of content of the item.
     */
    public val contentType: kotlin.String? = builder.contentType
    /**
     * The chat display name of the sender.
     */
    public val displayName: kotlin.String? = builder.displayName
    /**
     * The ID of the item.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The metadata related to the message. Currently this supports only information related to message receipts.
     */
    public val messageMetadata: aws.sdk.kotlin.services.connectparticipant.model.MessageMetadata? = builder.messageMetadata
    /**
     * The ID of the sender in the session.
     */
    public val participantId: kotlin.String? = builder.participantId
    /**
     * The role of the sender. For example, is it a customer, agent, or system.
     */
    public val participantRole: aws.sdk.kotlin.services.connectparticipant.model.ParticipantRole? = builder.participantRole
    /**
     * The contactId on which the transcript item was originally sent. This field is only populated for persistent chats when the transcript item is from the past chat session. For more information, see [Enable persistent chat](https://docs.aws.amazon.com/connect/latest/adminguide/chat-persistence.html).
     */
    public val relatedContactId: kotlin.String? = builder.relatedContactId
    /**
     * Type of the item: message or event.
     */
    public val type: aws.sdk.kotlin.services.connectparticipant.model.ChatItemType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connectparticipant.model.Item = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Item(")
        append("absoluteTime=$absoluteTime,")
        append("attachments=$attachments,")
        append("contactId=$contactId,")
        append("content=$content,")
        append("contentType=$contentType,")
        append("displayName=$displayName,")
        append("id=$id,")
        append("messageMetadata=$messageMetadata,")
        append("participantId=$participantId,")
        append("participantRole=$participantRole,")
        append("relatedContactId=$relatedContactId,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = absoluteTime?.hashCode() ?: 0
        result = 31 * result + (attachments?.hashCode() ?: 0)
        result = 31 * result + (contactId?.hashCode() ?: 0)
        result = 31 * result + (content?.hashCode() ?: 0)
        result = 31 * result + (contentType?.hashCode() ?: 0)
        result = 31 * result + (displayName?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (messageMetadata?.hashCode() ?: 0)
        result = 31 * result + (participantId?.hashCode() ?: 0)
        result = 31 * result + (participantRole?.hashCode() ?: 0)
        result = 31 * result + (relatedContactId?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Item

        if (absoluteTime != other.absoluteTime) return false
        if (attachments != other.attachments) return false
        if (contactId != other.contactId) return false
        if (content != other.content) return false
        if (contentType != other.contentType) return false
        if (displayName != other.displayName) return false
        if (id != other.id) return false
        if (messageMetadata != other.messageMetadata) return false
        if (participantId != other.participantId) return false
        if (participantRole != other.participantRole) return false
        if (relatedContactId != other.relatedContactId) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connectparticipant.model.Item = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The time when the message or event was sent.
         *
         * It's specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example, 2019-11-08T02:41:28.172Z.
         */
        public var absoluteTime: kotlin.String? = null
        /**
         * Provides information about the attachments.
         */
        public var attachments: List<AttachmentItem>? = null
        /**
         * The contactId on which the transcript item was originally sent. This field is populated only when the transcript item is from the current chat session.
         */
        public var contactId: kotlin.String? = null
        /**
         * The content of the message or event.
         */
        public var content: kotlin.String? = null
        /**
         * The type of content of the item.
         */
        public var contentType: kotlin.String? = null
        /**
         * The chat display name of the sender.
         */
        public var displayName: kotlin.String? = null
        /**
         * The ID of the item.
         */
        public var id: kotlin.String? = null
        /**
         * The metadata related to the message. Currently this supports only information related to message receipts.
         */
        public var messageMetadata: aws.sdk.kotlin.services.connectparticipant.model.MessageMetadata? = null
        /**
         * The ID of the sender in the session.
         */
        public var participantId: kotlin.String? = null
        /**
         * The role of the sender. For example, is it a customer, agent, or system.
         */
        public var participantRole: aws.sdk.kotlin.services.connectparticipant.model.ParticipantRole? = null
        /**
         * The contactId on which the transcript item was originally sent. This field is only populated for persistent chats when the transcript item is from the past chat session. For more information, see [Enable persistent chat](https://docs.aws.amazon.com/connect/latest/adminguide/chat-persistence.html).
         */
        public var relatedContactId: kotlin.String? = null
        /**
         * Type of the item: message or event.
         */
        public var type: aws.sdk.kotlin.services.connectparticipant.model.ChatItemType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connectparticipant.model.Item) : this() {
            this.absoluteTime = x.absoluteTime
            this.attachments = x.attachments
            this.contactId = x.contactId
            this.content = x.content
            this.contentType = x.contentType
            this.displayName = x.displayName
            this.id = x.id
            this.messageMetadata = x.messageMetadata
            this.participantId = x.participantId
            this.participantRole = x.participantRole
            this.relatedContactId = x.relatedContactId
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connectparticipant.model.Item = Item(this)

        /**
         * construct an [aws.sdk.kotlin.services.connectparticipant.model.MessageMetadata] inside the given [block]
         */
        public fun messageMetadata(block: aws.sdk.kotlin.services.connectparticipant.model.MessageMetadata.Builder.() -> kotlin.Unit) {
            this.messageMetadata = aws.sdk.kotlin.services.connectparticipant.model.MessageMetadata.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
