// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connectparticipant

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.connectparticipant.auth.ConnectParticipantAuthSchemeProvider
import aws.sdk.kotlin.services.connectparticipant.auth.DefaultConnectParticipantAuthSchemeProvider
import aws.sdk.kotlin.services.connectparticipant.endpoints.ConnectParticipantEndpointParameters
import aws.sdk.kotlin.services.connectparticipant.endpoints.ConnectParticipantEndpointProvider
import aws.sdk.kotlin.services.connectparticipant.endpoints.DefaultConnectParticipantEndpointProvider
import aws.sdk.kotlin.services.connectparticipant.model.CompleteAttachmentUploadRequest
import aws.sdk.kotlin.services.connectparticipant.model.CompleteAttachmentUploadResponse
import aws.sdk.kotlin.services.connectparticipant.model.CreateParticipantConnectionRequest
import aws.sdk.kotlin.services.connectparticipant.model.CreateParticipantConnectionResponse
import aws.sdk.kotlin.services.connectparticipant.model.DescribeViewRequest
import aws.sdk.kotlin.services.connectparticipant.model.DescribeViewResponse
import aws.sdk.kotlin.services.connectparticipant.model.DisconnectParticipantRequest
import aws.sdk.kotlin.services.connectparticipant.model.DisconnectParticipantResponse
import aws.sdk.kotlin.services.connectparticipant.model.GetAttachmentRequest
import aws.sdk.kotlin.services.connectparticipant.model.GetAttachmentResponse
import aws.sdk.kotlin.services.connectparticipant.model.GetTranscriptRequest
import aws.sdk.kotlin.services.connectparticipant.model.GetTranscriptResponse
import aws.sdk.kotlin.services.connectparticipant.model.SendEventRequest
import aws.sdk.kotlin.services.connectparticipant.model.SendEventResponse
import aws.sdk.kotlin.services.connectparticipant.model.SendMessageRequest
import aws.sdk.kotlin.services.connectparticipant.model.SendMessageResponse
import aws.sdk.kotlin.services.connectparticipant.model.StartAttachmentUploadRequest
import aws.sdk.kotlin.services.connectparticipant.model.StartAttachmentUploadResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "ConnectParticipant"
public const val SdkVersion: String = "1.0.48"
public const val ServiceApiVersion: String = "2018-09-07"

/**
 * Amazon Connect is an easy-to-use omnichannel cloud contact center service that enables companies of any size to deliver superior customer service at a lower cost. Amazon Connect communications capabilities make it easy for companies to deliver personalized interactions across communication channels, including chat.
 *
 * Use the Amazon Connect Participant Service to manage participants (for example, agents, customers, and managers listening in), and to send messages and events within a chat contact. The APIs in the service enable the following: sending chat messages, attachment sharing, managing a participant's connection state and message events, and retrieving chat transcripts.
 */
public interface ConnectParticipantClient : SdkClient {
    /**
     * ConnectParticipantClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, ConnectParticipantClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "ConnectParticipant",
                "CONNECTPARTICIPANT",
                "connectparticipant",
            )
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, ConnectParticipantClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): ConnectParticipantClient = DefaultConnectParticipantClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: ConnectParticipantEndpointProvider = builder.endpointProvider ?: DefaultConnectParticipantEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: ConnectParticipantAuthSchemeProvider = builder.authSchemeProvider ?: DefaultConnectParticipantAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "ConnectParticipant"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: ConnectParticipantEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: ConnectParticipantAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Allows you to confirm that the attachment has been uploaded using the pre-signed URL provided in StartAttachmentUpload API.
     *
     * `ConnectionToken` is used for invoking this API instead of `ParticipantToken`.
     *
     * The Amazon Connect Participant Service APIs do not use [Signature Version 4 authentication](https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
     */
    public suspend fun completeAttachmentUpload(input: CompleteAttachmentUploadRequest): CompleteAttachmentUploadResponse

    /**
     * Creates the participant's connection.
     *
     * `ParticipantToken` is used for invoking this API instead of `ConnectionToken`.
     *
     * The participant token is valid for the lifetime of the participant – until they are part of a contact.
     *
     * The response URL for `WEBSOCKET` Type has a connect expiry timeout of 100s. Clients must manually connect to the returned websocket URL and subscribe to the desired topic.
     *
     * For chat, you need to publish the following on the established websocket connection:
     *
     * `{"topic":"aws/subscribe","content":{"topics":["aws/chat"]}}`
     *
     * Upon websocket URL expiry, as specified in the response ConnectionExpiry parameter, clients need to call this API again to obtain a new websocket URL and perform the same steps as before.
     *
     * **Message streaming support**: This API can also be used together with the [StartContactStreaming](https://docs.aws.amazon.com/connect/latest/APIReference/API_StartContactStreaming.html) API to create a participant connection for chat contacts that are not using a websocket. For more information about message streaming, [Enable real-time chat message streaming](https://docs.aws.amazon.com/connect/latest/adminguide/chat-message-streaming.html) in the *Amazon Connect Administrator Guide*.
     *
     * **Feature specifications**: For information about feature specifications, such as the allowed number of open websocket connections per participant, see [Feature specifications](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#feature-limits) in the *Amazon Connect Administrator Guide*.
     *
     * The Amazon Connect Participant Service APIs do not use [Signature Version 4 authentication](https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
     */
    public suspend fun createParticipantConnection(input: CreateParticipantConnectionRequest): CreateParticipantConnectionResponse

    /**
     * Retrieves the view for the specified view token.
     */
    public suspend fun describeView(input: DescribeViewRequest): DescribeViewResponse

    /**
     * Disconnects a participant.
     *
     * `ConnectionToken` is used for invoking this API instead of `ParticipantToken`.
     *
     * The Amazon Connect Participant Service APIs do not use [Signature Version 4 authentication](https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
     */
    public suspend fun disconnectParticipant(input: DisconnectParticipantRequest): DisconnectParticipantResponse

    /**
     * Provides a pre-signed URL for download of a completed attachment. This is an asynchronous API for use with active contacts.
     *
     * `ConnectionToken` is used for invoking this API instead of `ParticipantToken`.
     *
     * The Amazon Connect Participant Service APIs do not use [Signature Version 4 authentication](https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
     */
    public suspend fun getAttachment(input: GetAttachmentRequest): GetAttachmentResponse

    /**
     * Retrieves a transcript of the session, including details about any attachments. For information about accessing past chat contact transcripts for a persistent chat, see [Enable persistent chat](https://docs.aws.amazon.com/connect/latest/adminguide/chat-persistence.html).
     *
     * `ConnectionToken` is used for invoking this API instead of `ParticipantToken`.
     *
     * The Amazon Connect Participant Service APIs do not use [Signature Version 4 authentication](https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
     */
    public suspend fun getTranscript(input: GetTranscriptRequest): GetTranscriptResponse

    /**
     * Sends an event.
     *
     * `ConnectionToken` is used for invoking this API instead of `ParticipantToken`.
     *
     * The Amazon Connect Participant Service APIs do not use [Signature Version 4 authentication](https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
     */
    public suspend fun sendEvent(input: SendEventRequest): SendEventResponse

    /**
     * Sends a message.
     *
     * `ConnectionToken` is used for invoking this API instead of `ParticipantToken`.
     *
     * The Amazon Connect Participant Service APIs do not use [Signature Version 4 authentication](https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
     */
    public suspend fun sendMessage(input: SendMessageRequest): SendMessageResponse

    /**
     * Provides a pre-signed Amazon S3 URL in response for uploading the file directly to S3.
     *
     * `ConnectionToken` is used for invoking this API instead of `ParticipantToken`.
     *
     * The Amazon Connect Participant Service APIs do not use [Signature Version 4 authentication](https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
     */
    public suspend fun startAttachmentUpload(input: StartAttachmentUploadRequest): StartAttachmentUploadResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun ConnectParticipantClient.withConfig(block: ConnectParticipantClient.Config.Builder.() -> Unit): ConnectParticipantClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultConnectParticipantClient(newConfig)
}

/**
 * Allows you to confirm that the attachment has been uploaded using the pre-signed URL provided in StartAttachmentUpload API.
 *
 * `ConnectionToken` is used for invoking this API instead of `ParticipantToken`.
 *
 * The Amazon Connect Participant Service APIs do not use [Signature Version 4 authentication](https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
 */
public suspend inline fun ConnectParticipantClient.completeAttachmentUpload(crossinline block: CompleteAttachmentUploadRequest.Builder.() -> Unit): CompleteAttachmentUploadResponse = completeAttachmentUpload(CompleteAttachmentUploadRequest.Builder().apply(block).build())

/**
 * Creates the participant's connection.
 *
 * `ParticipantToken` is used for invoking this API instead of `ConnectionToken`.
 *
 * The participant token is valid for the lifetime of the participant – until they are part of a contact.
 *
 * The response URL for `WEBSOCKET` Type has a connect expiry timeout of 100s. Clients must manually connect to the returned websocket URL and subscribe to the desired topic.
 *
 * For chat, you need to publish the following on the established websocket connection:
 *
 * `{"topic":"aws/subscribe","content":{"topics":["aws/chat"]}}`
 *
 * Upon websocket URL expiry, as specified in the response ConnectionExpiry parameter, clients need to call this API again to obtain a new websocket URL and perform the same steps as before.
 *
 * **Message streaming support**: This API can also be used together with the [StartContactStreaming](https://docs.aws.amazon.com/connect/latest/APIReference/API_StartContactStreaming.html) API to create a participant connection for chat contacts that are not using a websocket. For more information about message streaming, [Enable real-time chat message streaming](https://docs.aws.amazon.com/connect/latest/adminguide/chat-message-streaming.html) in the *Amazon Connect Administrator Guide*.
 *
 * **Feature specifications**: For information about feature specifications, such as the allowed number of open websocket connections per participant, see [Feature specifications](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#feature-limits) in the *Amazon Connect Administrator Guide*.
 *
 * The Amazon Connect Participant Service APIs do not use [Signature Version 4 authentication](https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
 */
public suspend inline fun ConnectParticipantClient.createParticipantConnection(crossinline block: CreateParticipantConnectionRequest.Builder.() -> Unit): CreateParticipantConnectionResponse = createParticipantConnection(CreateParticipantConnectionRequest.Builder().apply(block).build())

/**
 * Retrieves the view for the specified view token.
 */
public suspend inline fun ConnectParticipantClient.describeView(crossinline block: DescribeViewRequest.Builder.() -> Unit): DescribeViewResponse = describeView(DescribeViewRequest.Builder().apply(block).build())

/**
 * Disconnects a participant.
 *
 * `ConnectionToken` is used for invoking this API instead of `ParticipantToken`.
 *
 * The Amazon Connect Participant Service APIs do not use [Signature Version 4 authentication](https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
 */
public suspend inline fun ConnectParticipantClient.disconnectParticipant(crossinline block: DisconnectParticipantRequest.Builder.() -> Unit): DisconnectParticipantResponse = disconnectParticipant(DisconnectParticipantRequest.Builder().apply(block).build())

/**
 * Provides a pre-signed URL for download of a completed attachment. This is an asynchronous API for use with active contacts.
 *
 * `ConnectionToken` is used for invoking this API instead of `ParticipantToken`.
 *
 * The Amazon Connect Participant Service APIs do not use [Signature Version 4 authentication](https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
 */
public suspend inline fun ConnectParticipantClient.getAttachment(crossinline block: GetAttachmentRequest.Builder.() -> Unit): GetAttachmentResponse = getAttachment(GetAttachmentRequest.Builder().apply(block).build())

/**
 * Retrieves a transcript of the session, including details about any attachments. For information about accessing past chat contact transcripts for a persistent chat, see [Enable persistent chat](https://docs.aws.amazon.com/connect/latest/adminguide/chat-persistence.html).
 *
 * `ConnectionToken` is used for invoking this API instead of `ParticipantToken`.
 *
 * The Amazon Connect Participant Service APIs do not use [Signature Version 4 authentication](https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
 */
public suspend inline fun ConnectParticipantClient.getTranscript(crossinline block: GetTranscriptRequest.Builder.() -> Unit): GetTranscriptResponse = getTranscript(GetTranscriptRequest.Builder().apply(block).build())

/**
 * Sends an event.
 *
 * `ConnectionToken` is used for invoking this API instead of `ParticipantToken`.
 *
 * The Amazon Connect Participant Service APIs do not use [Signature Version 4 authentication](https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
 */
public suspend inline fun ConnectParticipantClient.sendEvent(crossinline block: SendEventRequest.Builder.() -> Unit): SendEventResponse = sendEvent(SendEventRequest.Builder().apply(block).build())

/**
 * Sends a message.
 *
 * `ConnectionToken` is used for invoking this API instead of `ParticipantToken`.
 *
 * The Amazon Connect Participant Service APIs do not use [Signature Version 4 authentication](https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
 */
public suspend inline fun ConnectParticipantClient.sendMessage(crossinline block: SendMessageRequest.Builder.() -> Unit): SendMessageResponse = sendMessage(SendMessageRequest.Builder().apply(block).build())

/**
 * Provides a pre-signed Amazon S3 URL in response for uploading the file directly to S3.
 *
 * `ConnectionToken` is used for invoking this API instead of `ParticipantToken`.
 *
 * The Amazon Connect Participant Service APIs do not use [Signature Version 4 authentication](https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
 */
public suspend inline fun ConnectParticipantClient.startAttachmentUpload(crossinline block: StartAttachmentUploadRequest.Builder.() -> Unit): StartAttachmentUploadResponse = startAttachmentUpload(StartAttachmentUploadRequest.Builder().apply(block).build())
