// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connectparticipant.serde

import aws.sdk.kotlin.services.connectparticipant.model.ConnectParticipantException
import aws.sdk.kotlin.services.connectparticipant.model.ConnectionCredentials
import aws.sdk.kotlin.services.connectparticipant.model.CreateParticipantConnectionResponse
import aws.sdk.kotlin.services.connectparticipant.model.Websocket
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateParticipantConnectionOperationDeserializer: HttpDeserialize<CreateParticipantConnectionResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CreateParticipantConnectionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateParticipantConnectionError(context, call)
        }
        val builder = CreateParticipantConnectionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateParticipantConnectionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwCreateParticipantConnectionError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ConnectParticipantException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        else -> ConnectParticipantException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateParticipantConnectionOperationBody(builder: CreateParticipantConnectionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CONNECTIONCREDENTIALS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ConnectionCredentials"))
    val WEBSOCKET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Websocket"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONNECTIONCREDENTIALS_DESCRIPTOR)
        field(WEBSOCKET_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CONNECTIONCREDENTIALS_DESCRIPTOR.index -> builder.connectionCredentials = deserializeConnectionCredentialsDocument(deserializer)
                WEBSOCKET_DESCRIPTOR.index -> builder.websocket = deserializeWebsocketDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
