// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connectcampaignsv2

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.runtime.region.DefaultRegionProviderChain
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.connectcampaignsv2.auth.ConnectCampaignsV2AuthSchemeProvider
import aws.sdk.kotlin.services.connectcampaignsv2.auth.DefaultConnectCampaignsV2AuthSchemeProvider
import aws.sdk.kotlin.services.connectcampaignsv2.endpoints.ConnectCampaignsV2EndpointParameters
import aws.sdk.kotlin.services.connectcampaignsv2.endpoints.ConnectCampaignsV2EndpointProvider
import aws.sdk.kotlin.services.connectcampaignsv2.endpoints.DefaultConnectCampaignsV2EndpointProvider
import aws.sdk.kotlin.services.connectcampaignsv2.model.CreateCampaignRequest
import aws.sdk.kotlin.services.connectcampaignsv2.model.CreateCampaignResponse
import aws.sdk.kotlin.services.connectcampaignsv2.model.DeleteCampaignChannelSubtypeConfigRequest
import aws.sdk.kotlin.services.connectcampaignsv2.model.DeleteCampaignChannelSubtypeConfigResponse
import aws.sdk.kotlin.services.connectcampaignsv2.model.DeleteCampaignCommunicationLimitsRequest
import aws.sdk.kotlin.services.connectcampaignsv2.model.DeleteCampaignCommunicationLimitsResponse
import aws.sdk.kotlin.services.connectcampaignsv2.model.DeleteCampaignCommunicationTimeRequest
import aws.sdk.kotlin.services.connectcampaignsv2.model.DeleteCampaignCommunicationTimeResponse
import aws.sdk.kotlin.services.connectcampaignsv2.model.DeleteCampaignRequest
import aws.sdk.kotlin.services.connectcampaignsv2.model.DeleteCampaignResponse
import aws.sdk.kotlin.services.connectcampaignsv2.model.DeleteConnectInstanceConfigRequest
import aws.sdk.kotlin.services.connectcampaignsv2.model.DeleteConnectInstanceConfigResponse
import aws.sdk.kotlin.services.connectcampaignsv2.model.DeleteConnectInstanceIntegrationRequest
import aws.sdk.kotlin.services.connectcampaignsv2.model.DeleteConnectInstanceIntegrationResponse
import aws.sdk.kotlin.services.connectcampaignsv2.model.DeleteInstanceOnboardingJobRequest
import aws.sdk.kotlin.services.connectcampaignsv2.model.DeleteInstanceOnboardingJobResponse
import aws.sdk.kotlin.services.connectcampaignsv2.model.DescribeCampaignRequest
import aws.sdk.kotlin.services.connectcampaignsv2.model.DescribeCampaignResponse
import aws.sdk.kotlin.services.connectcampaignsv2.model.GetCampaignStateBatchRequest
import aws.sdk.kotlin.services.connectcampaignsv2.model.GetCampaignStateBatchResponse
import aws.sdk.kotlin.services.connectcampaignsv2.model.GetCampaignStateRequest
import aws.sdk.kotlin.services.connectcampaignsv2.model.GetCampaignStateResponse
import aws.sdk.kotlin.services.connectcampaignsv2.model.GetConnectInstanceConfigRequest
import aws.sdk.kotlin.services.connectcampaignsv2.model.GetConnectInstanceConfigResponse
import aws.sdk.kotlin.services.connectcampaignsv2.model.GetInstanceCommunicationLimitsRequest
import aws.sdk.kotlin.services.connectcampaignsv2.model.GetInstanceCommunicationLimitsResponse
import aws.sdk.kotlin.services.connectcampaignsv2.model.GetInstanceOnboardingJobStatusRequest
import aws.sdk.kotlin.services.connectcampaignsv2.model.GetInstanceOnboardingJobStatusResponse
import aws.sdk.kotlin.services.connectcampaignsv2.model.ListCampaignsRequest
import aws.sdk.kotlin.services.connectcampaignsv2.model.ListCampaignsResponse
import aws.sdk.kotlin.services.connectcampaignsv2.model.ListConnectInstanceIntegrationsRequest
import aws.sdk.kotlin.services.connectcampaignsv2.model.ListConnectInstanceIntegrationsResponse
import aws.sdk.kotlin.services.connectcampaignsv2.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.connectcampaignsv2.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.connectcampaignsv2.model.PauseCampaignRequest
import aws.sdk.kotlin.services.connectcampaignsv2.model.PauseCampaignResponse
import aws.sdk.kotlin.services.connectcampaignsv2.model.PutConnectInstanceIntegrationRequest
import aws.sdk.kotlin.services.connectcampaignsv2.model.PutConnectInstanceIntegrationResponse
import aws.sdk.kotlin.services.connectcampaignsv2.model.PutInstanceCommunicationLimitsRequest
import aws.sdk.kotlin.services.connectcampaignsv2.model.PutInstanceCommunicationLimitsResponse
import aws.sdk.kotlin.services.connectcampaignsv2.model.PutOutboundRequestBatchRequest
import aws.sdk.kotlin.services.connectcampaignsv2.model.PutOutboundRequestBatchResponse
import aws.sdk.kotlin.services.connectcampaignsv2.model.PutProfileOutboundRequestBatchRequest
import aws.sdk.kotlin.services.connectcampaignsv2.model.PutProfileOutboundRequestBatchResponse
import aws.sdk.kotlin.services.connectcampaignsv2.model.ResumeCampaignRequest
import aws.sdk.kotlin.services.connectcampaignsv2.model.ResumeCampaignResponse
import aws.sdk.kotlin.services.connectcampaignsv2.model.StartCampaignRequest
import aws.sdk.kotlin.services.connectcampaignsv2.model.StartCampaignResponse
import aws.sdk.kotlin.services.connectcampaignsv2.model.StartInstanceOnboardingJobRequest
import aws.sdk.kotlin.services.connectcampaignsv2.model.StartInstanceOnboardingJobResponse
import aws.sdk.kotlin.services.connectcampaignsv2.model.StopCampaignRequest
import aws.sdk.kotlin.services.connectcampaignsv2.model.StopCampaignResponse
import aws.sdk.kotlin.services.connectcampaignsv2.model.TagResourceRequest
import aws.sdk.kotlin.services.connectcampaignsv2.model.TagResourceResponse
import aws.sdk.kotlin.services.connectcampaignsv2.model.UntagResourceRequest
import aws.sdk.kotlin.services.connectcampaignsv2.model.UntagResourceResponse
import aws.sdk.kotlin.services.connectcampaignsv2.model.UpdateCampaignChannelSubtypeConfigRequest
import aws.sdk.kotlin.services.connectcampaignsv2.model.UpdateCampaignChannelSubtypeConfigResponse
import aws.sdk.kotlin.services.connectcampaignsv2.model.UpdateCampaignCommunicationLimitsRequest
import aws.sdk.kotlin.services.connectcampaignsv2.model.UpdateCampaignCommunicationLimitsResponse
import aws.sdk.kotlin.services.connectcampaignsv2.model.UpdateCampaignCommunicationTimeRequest
import aws.sdk.kotlin.services.connectcampaignsv2.model.UpdateCampaignCommunicationTimeResponse
import aws.sdk.kotlin.services.connectcampaignsv2.model.UpdateCampaignFlowAssociationRequest
import aws.sdk.kotlin.services.connectcampaignsv2.model.UpdateCampaignFlowAssociationResponse
import aws.sdk.kotlin.services.connectcampaignsv2.model.UpdateCampaignNameRequest
import aws.sdk.kotlin.services.connectcampaignsv2.model.UpdateCampaignNameResponse
import aws.sdk.kotlin.services.connectcampaignsv2.model.UpdateCampaignScheduleRequest
import aws.sdk.kotlin.services.connectcampaignsv2.model.UpdateCampaignScheduleResponse
import aws.sdk.kotlin.services.connectcampaignsv2.model.UpdateCampaignSourceRequest
import aws.sdk.kotlin.services.connectcampaignsv2.model.UpdateCampaignSourceResponse
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.region.RegionProvider
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.config.TimeoutConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic
import kotlin.time.Duration
import kotlinx.coroutines.runBlocking


public const val ServiceId: String = "ConnectCampaignsV2"
public const val SdkVersion: String = "1.5.32"
public const val ServiceApiVersion: String = "2024-04-23"

/**
 * Provide APIs to create and manage Amazon Connect Campaigns.
 */
public interface ConnectCampaignsV2Client : SdkClient {
    /**
     * ConnectCampaignsV2Client's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, ConnectCampaignsV2Client, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "ConnectCampaignsV2",
                "CONNECTCAMPAIGNSV2",
                "connectcampaignsv2",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, ConnectCampaignsV2Client>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): ConnectCampaignsV2Client = DefaultConnectCampaignsV2Client(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig, TimeoutConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region ?: runBlocking { builder.regionProvider?.getRegion() ?: resolveRegion() }
        override val regionProvider: RegionProvider = builder.regionProvider ?: DefaultRegionProviderChain()
        override val attemptTimeout: Duration? = builder.attemptTimeout
        override val authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = builder.authSchemePreference
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val callTimeout: Duration? = builder.callTimeout
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: ConnectCampaignsV2EndpointProvider = builder.endpointProvider ?: DefaultConnectCampaignsV2EndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: ConnectCampaignsV2AuthSchemeProvider = builder.authSchemeProvider ?: DefaultConnectCampaignsV2AuthSchemeProvider(authSchemePreference = authSchemePreference)
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            regionProvider = this@Config.regionProvider
            attemptTimeout = this@Config.attemptTimeout
            authSchemePreference = this@Config.authSchemePreference
            authSchemes = this@Config.authSchemes
            callTimeout = this@Config.callTimeout
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder, TimeoutConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "ConnectCampaignsV2"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more information.
             * When specified, this static region configuration takes precedence over other region resolution methods.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var region: String? = null

            /**
             * An optional region provider that determines the AWS region for client operations. When specified, this provider
             * takes precedence over the default region provider chain, unless a static region is explicitly configured.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var regionProvider: RegionProvider? = null

            /**
             * The maximum amount of time to wait for any single attempt of a request within the retry loop. By default,
             * the value is `null` indicating no timeout is enforced. Attempt timeouts may be retried if allowed by the
             * current retry policy and retry capacity.
             */
            override var attemptTimeout: Duration? = null

            /**
             * The ordered preference of [AuthScheme] that this client will use.
             */
            override var authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The maximum amount of time to wait for completion of a call, including any retries after the first attempt.
             * By default, the value is `null` indicating no timeout is enforced. Call timeouts are not retried.
             */
            override var callTimeout: Duration? = null

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: ConnectCampaignsV2EndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: ConnectCampaignsV2AuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a campaign for the specified Amazon Connect account. This API is idempotent.
     */
    public suspend fun createCampaign(input: CreateCampaignRequest): CreateCampaignResponse

    /**
     * Deletes a campaign from the specified Amazon Connect account.
     */
    public suspend fun deleteCampaign(input: DeleteCampaignRequest): DeleteCampaignResponse

    /**
     * Deletes the channel subtype config of a campaign. This API is idempotent.
     */
    public suspend fun deleteCampaignChannelSubtypeConfig(input: DeleteCampaignChannelSubtypeConfigRequest): DeleteCampaignChannelSubtypeConfigResponse

    /**
     * Deletes the communication limits config for a campaign. This API is idempotent.
     */
    public suspend fun deleteCampaignCommunicationLimits(input: DeleteCampaignCommunicationLimitsRequest): DeleteCampaignCommunicationLimitsResponse

    /**
     * Deletes the communication time config for a campaign. This API is idempotent.
     */
    public suspend fun deleteCampaignCommunicationTime(input: DeleteCampaignCommunicationTimeRequest): DeleteCampaignCommunicationTimeResponse

    /**
     * Deletes a connect instance config from the specified AWS account.
     */
    public suspend fun deleteConnectInstanceConfig(input: DeleteConnectInstanceConfigRequest): DeleteConnectInstanceConfigResponse

    /**
     * Delete the integration for the specified Amazon Connect instance.
     */
    public suspend fun deleteConnectInstanceIntegration(input: DeleteConnectInstanceIntegrationRequest): DeleteConnectInstanceIntegrationResponse

    /**
     * Delete the Connect Campaigns onboarding job for the specified Amazon Connect instance.
     */
    public suspend fun deleteInstanceOnboardingJob(input: DeleteInstanceOnboardingJobRequest): DeleteInstanceOnboardingJobResponse

    /**
     * Describes the specific campaign.
     */
    public suspend fun describeCampaign(input: DescribeCampaignRequest): DescribeCampaignResponse

    /**
     * Get state of a campaign for the specified Amazon Connect account.
     */
    public suspend fun getCampaignState(input: GetCampaignStateRequest): GetCampaignStateResponse

    /**
     * Get state of campaigns for the specified Amazon Connect account.
     */
    public suspend fun getCampaignStateBatch(input: GetCampaignStateBatchRequest): GetCampaignStateBatchResponse

    /**
     * Get the specific Connect instance config.
     */
    public suspend fun getConnectInstanceConfig(input: GetConnectInstanceConfigRequest): GetConnectInstanceConfigResponse

    /**
     * Get the instance communication limits.
     */
    public suspend fun getInstanceCommunicationLimits(input: GetInstanceCommunicationLimitsRequest): GetInstanceCommunicationLimitsResponse

    /**
     * Get the specific instance onboarding job status.
     */
    public suspend fun getInstanceOnboardingJobStatus(input: GetInstanceOnboardingJobStatusRequest): GetInstanceOnboardingJobStatusResponse

    /**
     * Provides summary information about the campaigns under the specified Amazon Connect account.
     */
    public suspend fun listCampaigns(input: ListCampaignsRequest = ListCampaignsRequest { }): ListCampaignsResponse

    /**
     * Provides summary information about the integration under the specified Connect instance.
     */
    public suspend fun listConnectInstanceIntegrations(input: ListConnectInstanceIntegrationsRequest): ListConnectInstanceIntegrationsResponse

    /**
     * List tags for a resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Pauses a campaign for the specified Amazon Connect account.
     */
    public suspend fun pauseCampaign(input: PauseCampaignRequest): PauseCampaignResponse

    /**
     * Put or update the integration for the specified Amazon Connect instance.
     */
    public suspend fun putConnectInstanceIntegration(input: PutConnectInstanceIntegrationRequest): PutConnectInstanceIntegrationResponse

    /**
     * Put the instance communication limits. This API is idempotent.
     */
    public suspend fun putInstanceCommunicationLimits(input: PutInstanceCommunicationLimitsRequest): PutInstanceCommunicationLimitsResponse

    /**
     * Creates outbound requests for the specified campaign Amazon Connect account. This API is idempotent.
     */
    public suspend fun putOutboundRequestBatch(input: PutOutboundRequestBatchRequest): PutOutboundRequestBatchResponse

    /**
     * Takes in a list of profile outbound requests to be placed as part of an outbound campaign. This API is idempotent.
     */
    public suspend fun putProfileOutboundRequestBatch(input: PutProfileOutboundRequestBatchRequest): PutProfileOutboundRequestBatchResponse

    /**
     * Stops a campaign for the specified Amazon Connect account.
     */
    public suspend fun resumeCampaign(input: ResumeCampaignRequest): ResumeCampaignResponse

    /**
     * Starts a campaign for the specified Amazon Connect account.
     */
    public suspend fun startCampaign(input: StartCampaignRequest): StartCampaignResponse

    /**
     * Onboard the specific Amazon Connect instance to Connect Campaigns.
     */
    public suspend fun startInstanceOnboardingJob(input: StartInstanceOnboardingJobRequest): StartInstanceOnboardingJobResponse

    /**
     * Stops a campaign for the specified Amazon Connect account.
     */
    public suspend fun stopCampaign(input: StopCampaignRequest): StopCampaignResponse

    /**
     * Tag a resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Untag a resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates the channel subtype config of a campaign. This API is idempotent.
     */
    public suspend fun updateCampaignChannelSubtypeConfig(input: UpdateCampaignChannelSubtypeConfigRequest): UpdateCampaignChannelSubtypeConfigResponse

    /**
     * Updates the communication limits config for a campaign. This API is idempotent.
     */
    public suspend fun updateCampaignCommunicationLimits(input: UpdateCampaignCommunicationLimitsRequest): UpdateCampaignCommunicationLimitsResponse

    /**
     * Updates the communication time config for a campaign. This API is idempotent.
     */
    public suspend fun updateCampaignCommunicationTime(input: UpdateCampaignCommunicationTimeRequest): UpdateCampaignCommunicationTimeResponse

    /**
     * Updates the campaign flow associated with a campaign. This API is idempotent.
     */
    public suspend fun updateCampaignFlowAssociation(input: UpdateCampaignFlowAssociationRequest): UpdateCampaignFlowAssociationResponse

    /**
     * Updates the name of a campaign. This API is idempotent.
     */
    public suspend fun updateCampaignName(input: UpdateCampaignNameRequest): UpdateCampaignNameResponse

    /**
     * Updates the schedule for a campaign. This API is idempotent.
     */
    public suspend fun updateCampaignSchedule(input: UpdateCampaignScheduleRequest): UpdateCampaignScheduleResponse

    /**
     * Updates the campaign source with a campaign. This API is idempotent.
     */
    public suspend fun updateCampaignSource(input: UpdateCampaignSourceRequest): UpdateCampaignSourceResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun ConnectCampaignsV2Client.withConfig(block: ConnectCampaignsV2Client.Config.Builder.() -> Unit): ConnectCampaignsV2Client {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultConnectCampaignsV2Client(newConfig)
}

/**
 * Creates a campaign for the specified Amazon Connect account. This API is idempotent.
 */
public suspend inline fun ConnectCampaignsV2Client.createCampaign(crossinline block: CreateCampaignRequest.Builder.() -> Unit): CreateCampaignResponse = createCampaign(CreateCampaignRequest.Builder().apply(block).build())

/**
 * Deletes a campaign from the specified Amazon Connect account.
 */
public suspend inline fun ConnectCampaignsV2Client.deleteCampaign(crossinline block: DeleteCampaignRequest.Builder.() -> Unit): DeleteCampaignResponse = deleteCampaign(DeleteCampaignRequest.Builder().apply(block).build())

/**
 * Deletes the channel subtype config of a campaign. This API is idempotent.
 */
public suspend inline fun ConnectCampaignsV2Client.deleteCampaignChannelSubtypeConfig(crossinline block: DeleteCampaignChannelSubtypeConfigRequest.Builder.() -> Unit): DeleteCampaignChannelSubtypeConfigResponse = deleteCampaignChannelSubtypeConfig(DeleteCampaignChannelSubtypeConfigRequest.Builder().apply(block).build())

/**
 * Deletes the communication limits config for a campaign. This API is idempotent.
 */
public suspend inline fun ConnectCampaignsV2Client.deleteCampaignCommunicationLimits(crossinline block: DeleteCampaignCommunicationLimitsRequest.Builder.() -> Unit): DeleteCampaignCommunicationLimitsResponse = deleteCampaignCommunicationLimits(DeleteCampaignCommunicationLimitsRequest.Builder().apply(block).build())

/**
 * Deletes the communication time config for a campaign. This API is idempotent.
 */
public suspend inline fun ConnectCampaignsV2Client.deleteCampaignCommunicationTime(crossinline block: DeleteCampaignCommunicationTimeRequest.Builder.() -> Unit): DeleteCampaignCommunicationTimeResponse = deleteCampaignCommunicationTime(DeleteCampaignCommunicationTimeRequest.Builder().apply(block).build())

/**
 * Deletes a connect instance config from the specified AWS account.
 */
public suspend inline fun ConnectCampaignsV2Client.deleteConnectInstanceConfig(crossinline block: DeleteConnectInstanceConfigRequest.Builder.() -> Unit): DeleteConnectInstanceConfigResponse = deleteConnectInstanceConfig(DeleteConnectInstanceConfigRequest.Builder().apply(block).build())

/**
 * Delete the integration for the specified Amazon Connect instance.
 */
public suspend inline fun ConnectCampaignsV2Client.deleteConnectInstanceIntegration(crossinline block: DeleteConnectInstanceIntegrationRequest.Builder.() -> Unit): DeleteConnectInstanceIntegrationResponse = deleteConnectInstanceIntegration(DeleteConnectInstanceIntegrationRequest.Builder().apply(block).build())

/**
 * Delete the Connect Campaigns onboarding job for the specified Amazon Connect instance.
 */
public suspend inline fun ConnectCampaignsV2Client.deleteInstanceOnboardingJob(crossinline block: DeleteInstanceOnboardingJobRequest.Builder.() -> Unit): DeleteInstanceOnboardingJobResponse = deleteInstanceOnboardingJob(DeleteInstanceOnboardingJobRequest.Builder().apply(block).build())

/**
 * Describes the specific campaign.
 */
public suspend inline fun ConnectCampaignsV2Client.describeCampaign(crossinline block: DescribeCampaignRequest.Builder.() -> Unit): DescribeCampaignResponse = describeCampaign(DescribeCampaignRequest.Builder().apply(block).build())

/**
 * Get state of a campaign for the specified Amazon Connect account.
 */
public suspend inline fun ConnectCampaignsV2Client.getCampaignState(crossinline block: GetCampaignStateRequest.Builder.() -> Unit): GetCampaignStateResponse = getCampaignState(GetCampaignStateRequest.Builder().apply(block).build())

/**
 * Get state of campaigns for the specified Amazon Connect account.
 */
public suspend inline fun ConnectCampaignsV2Client.getCampaignStateBatch(crossinline block: GetCampaignStateBatchRequest.Builder.() -> Unit): GetCampaignStateBatchResponse = getCampaignStateBatch(GetCampaignStateBatchRequest.Builder().apply(block).build())

/**
 * Get the specific Connect instance config.
 */
public suspend inline fun ConnectCampaignsV2Client.getConnectInstanceConfig(crossinline block: GetConnectInstanceConfigRequest.Builder.() -> Unit): GetConnectInstanceConfigResponse = getConnectInstanceConfig(GetConnectInstanceConfigRequest.Builder().apply(block).build())

/**
 * Get the instance communication limits.
 */
public suspend inline fun ConnectCampaignsV2Client.getInstanceCommunicationLimits(crossinline block: GetInstanceCommunicationLimitsRequest.Builder.() -> Unit): GetInstanceCommunicationLimitsResponse = getInstanceCommunicationLimits(GetInstanceCommunicationLimitsRequest.Builder().apply(block).build())

/**
 * Get the specific instance onboarding job status.
 */
public suspend inline fun ConnectCampaignsV2Client.getInstanceOnboardingJobStatus(crossinline block: GetInstanceOnboardingJobStatusRequest.Builder.() -> Unit): GetInstanceOnboardingJobStatusResponse = getInstanceOnboardingJobStatus(GetInstanceOnboardingJobStatusRequest.Builder().apply(block).build())

/**
 * Provides summary information about the campaigns under the specified Amazon Connect account.
 */
public suspend inline fun ConnectCampaignsV2Client.listCampaigns(crossinline block: ListCampaignsRequest.Builder.() -> Unit): ListCampaignsResponse = listCampaigns(ListCampaignsRequest.Builder().apply(block).build())

/**
 * Provides summary information about the integration under the specified Connect instance.
 */
public suspend inline fun ConnectCampaignsV2Client.listConnectInstanceIntegrations(crossinline block: ListConnectInstanceIntegrationsRequest.Builder.() -> Unit): ListConnectInstanceIntegrationsResponse = listConnectInstanceIntegrations(ListConnectInstanceIntegrationsRequest.Builder().apply(block).build())

/**
 * List tags for a resource.
 */
public suspend inline fun ConnectCampaignsV2Client.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Pauses a campaign for the specified Amazon Connect account.
 */
public suspend inline fun ConnectCampaignsV2Client.pauseCampaign(crossinline block: PauseCampaignRequest.Builder.() -> Unit): PauseCampaignResponse = pauseCampaign(PauseCampaignRequest.Builder().apply(block).build())

/**
 * Put or update the integration for the specified Amazon Connect instance.
 */
public suspend inline fun ConnectCampaignsV2Client.putConnectInstanceIntegration(crossinline block: PutConnectInstanceIntegrationRequest.Builder.() -> Unit): PutConnectInstanceIntegrationResponse = putConnectInstanceIntegration(PutConnectInstanceIntegrationRequest.Builder().apply(block).build())

/**
 * Put the instance communication limits. This API is idempotent.
 */
public suspend inline fun ConnectCampaignsV2Client.putInstanceCommunicationLimits(crossinline block: PutInstanceCommunicationLimitsRequest.Builder.() -> Unit): PutInstanceCommunicationLimitsResponse = putInstanceCommunicationLimits(PutInstanceCommunicationLimitsRequest.Builder().apply(block).build())

/**
 * Creates outbound requests for the specified campaign Amazon Connect account. This API is idempotent.
 */
public suspend inline fun ConnectCampaignsV2Client.putOutboundRequestBatch(crossinline block: PutOutboundRequestBatchRequest.Builder.() -> Unit): PutOutboundRequestBatchResponse = putOutboundRequestBatch(PutOutboundRequestBatchRequest.Builder().apply(block).build())

/**
 * Takes in a list of profile outbound requests to be placed as part of an outbound campaign. This API is idempotent.
 */
public suspend inline fun ConnectCampaignsV2Client.putProfileOutboundRequestBatch(crossinline block: PutProfileOutboundRequestBatchRequest.Builder.() -> Unit): PutProfileOutboundRequestBatchResponse = putProfileOutboundRequestBatch(PutProfileOutboundRequestBatchRequest.Builder().apply(block).build())

/**
 * Stops a campaign for the specified Amazon Connect account.
 */
public suspend inline fun ConnectCampaignsV2Client.resumeCampaign(crossinline block: ResumeCampaignRequest.Builder.() -> Unit): ResumeCampaignResponse = resumeCampaign(ResumeCampaignRequest.Builder().apply(block).build())

/**
 * Starts a campaign for the specified Amazon Connect account.
 */
public suspend inline fun ConnectCampaignsV2Client.startCampaign(crossinline block: StartCampaignRequest.Builder.() -> Unit): StartCampaignResponse = startCampaign(StartCampaignRequest.Builder().apply(block).build())

/**
 * Onboard the specific Amazon Connect instance to Connect Campaigns.
 */
public suspend inline fun ConnectCampaignsV2Client.startInstanceOnboardingJob(crossinline block: StartInstanceOnboardingJobRequest.Builder.() -> Unit): StartInstanceOnboardingJobResponse = startInstanceOnboardingJob(StartInstanceOnboardingJobRequest.Builder().apply(block).build())

/**
 * Stops a campaign for the specified Amazon Connect account.
 */
public suspend inline fun ConnectCampaignsV2Client.stopCampaign(crossinline block: StopCampaignRequest.Builder.() -> Unit): StopCampaignResponse = stopCampaign(StopCampaignRequest.Builder().apply(block).build())

/**
 * Tag a resource.
 */
public suspend inline fun ConnectCampaignsV2Client.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Untag a resource.
 */
public suspend inline fun ConnectCampaignsV2Client.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates the channel subtype config of a campaign. This API is idempotent.
 */
public suspend inline fun ConnectCampaignsV2Client.updateCampaignChannelSubtypeConfig(crossinline block: UpdateCampaignChannelSubtypeConfigRequest.Builder.() -> Unit): UpdateCampaignChannelSubtypeConfigResponse = updateCampaignChannelSubtypeConfig(UpdateCampaignChannelSubtypeConfigRequest.Builder().apply(block).build())

/**
 * Updates the communication limits config for a campaign. This API is idempotent.
 */
public suspend inline fun ConnectCampaignsV2Client.updateCampaignCommunicationLimits(crossinline block: UpdateCampaignCommunicationLimitsRequest.Builder.() -> Unit): UpdateCampaignCommunicationLimitsResponse = updateCampaignCommunicationLimits(UpdateCampaignCommunicationLimitsRequest.Builder().apply(block).build())

/**
 * Updates the communication time config for a campaign. This API is idempotent.
 */
public suspend inline fun ConnectCampaignsV2Client.updateCampaignCommunicationTime(crossinline block: UpdateCampaignCommunicationTimeRequest.Builder.() -> Unit): UpdateCampaignCommunicationTimeResponse = updateCampaignCommunicationTime(UpdateCampaignCommunicationTimeRequest.Builder().apply(block).build())

/**
 * Updates the campaign flow associated with a campaign. This API is idempotent.
 */
public suspend inline fun ConnectCampaignsV2Client.updateCampaignFlowAssociation(crossinline block: UpdateCampaignFlowAssociationRequest.Builder.() -> Unit): UpdateCampaignFlowAssociationResponse = updateCampaignFlowAssociation(UpdateCampaignFlowAssociationRequest.Builder().apply(block).build())

/**
 * Updates the name of a campaign. This API is idempotent.
 */
public suspend inline fun ConnectCampaignsV2Client.updateCampaignName(crossinline block: UpdateCampaignNameRequest.Builder.() -> Unit): UpdateCampaignNameResponse = updateCampaignName(UpdateCampaignNameRequest.Builder().apply(block).build())

/**
 * Updates the schedule for a campaign. This API is idempotent.
 */
public suspend inline fun ConnectCampaignsV2Client.updateCampaignSchedule(crossinline block: UpdateCampaignScheduleRequest.Builder.() -> Unit): UpdateCampaignScheduleResponse = updateCampaignSchedule(UpdateCampaignScheduleRequest.Builder().apply(block).build())

/**
 * Updates the campaign source with a campaign. This API is idempotent.
 */
public suspend inline fun ConnectCampaignsV2Client.updateCampaignSource(crossinline block: UpdateCampaignSourceRequest.Builder.() -> Unit): UpdateCampaignSourceResponse = updateCampaignSource(UpdateCampaignSourceRequest.Builder().apply(block).build())
