// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connectcampaignsv2.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * An Amazon Connect campaign summary.
 */
public class CampaignSummary private constructor(builder: Builder) {
    /**
     * The resource name of an Amazon Connect campaign.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * Channel subtype list
     */
    public val channelSubtypes: List<ChannelSubtype> = requireNotNull(builder.channelSubtypes) { "A non-null value must be provided for channelSubtypes" }
    /**
     * Amazon Resource Names(ARN)
     */
    public val connectCampaignFlowArn: kotlin.String? = builder.connectCampaignFlowArn
    /**
     * Amazon Connect Instance Id
     */
    public val connectInstanceId: kotlin.String = requireNotNull(builder.connectInstanceId) { "A non-null value must be provided for connectInstanceId" }
    /**
     * Identifier representing a Campaign
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The name of an Amazon Connect Campaign name.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * Campaign schedule
     */
    public val schedule: aws.sdk.kotlin.services.connectcampaignsv2.model.Schedule? = builder.schedule

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connectcampaignsv2.model.CampaignSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CampaignSummary(")
        append("arn=$arn,")
        append("channelSubtypes=$channelSubtypes,")
        append("connectCampaignFlowArn=$connectCampaignFlowArn,")
        append("connectInstanceId=$connectInstanceId,")
        append("id=$id,")
        append("name=$name,")
        append("schedule=$schedule")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (channelSubtypes.hashCode())
        result = 31 * result + (connectCampaignFlowArn?.hashCode() ?: 0)
        result = 31 * result + (connectInstanceId.hashCode())
        result = 31 * result + (id.hashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (schedule?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CampaignSummary

        if (arn != other.arn) return false
        if (channelSubtypes != other.channelSubtypes) return false
        if (connectCampaignFlowArn != other.connectCampaignFlowArn) return false
        if (connectInstanceId != other.connectInstanceId) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (schedule != other.schedule) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connectcampaignsv2.model.CampaignSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The resource name of an Amazon Connect campaign.
         */
        public var arn: kotlin.String? = null
        /**
         * Channel subtype list
         */
        public var channelSubtypes: List<ChannelSubtype>? = null
        /**
         * Amazon Resource Names(ARN)
         */
        public var connectCampaignFlowArn: kotlin.String? = null
        /**
         * Amazon Connect Instance Id
         */
        public var connectInstanceId: kotlin.String? = null
        /**
         * Identifier representing a Campaign
         */
        public var id: kotlin.String? = null
        /**
         * The name of an Amazon Connect Campaign name.
         */
        public var name: kotlin.String? = null
        /**
         * Campaign schedule
         */
        public var schedule: aws.sdk.kotlin.services.connectcampaignsv2.model.Schedule? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connectcampaignsv2.model.CampaignSummary) : this() {
            this.arn = x.arn
            this.channelSubtypes = x.channelSubtypes
            this.connectCampaignFlowArn = x.connectCampaignFlowArn
            this.connectInstanceId = x.connectInstanceId
            this.id = x.id
            this.name = x.name
            this.schedule = x.schedule
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connectcampaignsv2.model.CampaignSummary = CampaignSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.connectcampaignsv2.model.Schedule] inside the given [block]
         */
        public fun schedule(block: aws.sdk.kotlin.services.connectcampaignsv2.model.Schedule.Builder.() -> kotlin.Unit) {
            this.schedule = aws.sdk.kotlin.services.connectcampaignsv2.model.Schedule.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (channelSubtypes == null) channelSubtypes = emptyList()
            if (connectInstanceId == null) connectInstanceId = ""
            if (id == null) id = ""
            if (name == null) name = ""
            return this
        }
    }
}
