// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connectcampaignsv2.paginators

import aws.sdk.kotlin.services.connectcampaignsv2.ConnectCampaignsV2Client
import aws.sdk.kotlin.services.connectcampaignsv2.model.CampaignSummary
import aws.sdk.kotlin.services.connectcampaignsv2.model.IntegrationSummary
import aws.sdk.kotlin.services.connectcampaignsv2.model.ListCampaignsRequest
import aws.sdk.kotlin.services.connectcampaignsv2.model.ListCampaignsResponse
import aws.sdk.kotlin.services.connectcampaignsv2.model.ListConnectInstanceIntegrationsRequest
import aws.sdk.kotlin.services.connectcampaignsv2.model.ListConnectInstanceIntegrationsResponse
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListCampaignsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListCampaignsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCampaignsResponse]
 */
public fun ConnectCampaignsV2Client.listCampaignsPaginated(initialRequest: ListCampaignsRequest = ListCampaignsRequest { }): Flow<ListCampaignsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCampaignsPaginated.listCampaigns(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListCampaignsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCampaignsResponse]
 */
public fun ConnectCampaignsV2Client.listCampaignsPaginated(block: ListCampaignsRequest.Builder.() -> Unit): Flow<ListCampaignsResponse> =
    listCampaignsPaginated(ListCampaignsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listCampaignsPaginated]
 * to access the nested member [CampaignSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [CampaignSummary]
 */
@JvmName("listCampaignsResponseCampaignSummary")
public fun Flow<ListCampaignsResponse>.campaignSummaryList(): Flow<CampaignSummary> =
    transform() { response ->
        response.campaignSummaryList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListConnectInstanceIntegrationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListConnectInstanceIntegrationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListConnectInstanceIntegrationsResponse]
 */
public fun ConnectCampaignsV2Client.listConnectInstanceIntegrationsPaginated(initialRequest: ListConnectInstanceIntegrationsRequest): Flow<ListConnectInstanceIntegrationsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listConnectInstanceIntegrationsPaginated.listConnectInstanceIntegrations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListConnectInstanceIntegrationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListConnectInstanceIntegrationsResponse]
 */
public fun ConnectCampaignsV2Client.listConnectInstanceIntegrationsPaginated(block: ListConnectInstanceIntegrationsRequest.Builder.() -> Unit): Flow<ListConnectInstanceIntegrationsResponse> =
    listConnectInstanceIntegrationsPaginated(ListConnectInstanceIntegrationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listConnectInstanceIntegrationsPaginated]
 * to access the nested member [IntegrationSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [IntegrationSummary]
 */
@JvmName("listConnectInstanceIntegrationsResponseIntegrationSummary")
public fun Flow<ListConnectInstanceIntegrationsResponse>.integrationSummaryList(): Flow<IntegrationSummary> =
    transform() { response ->
        response.integrationSummaryList?.forEach {
            emit(it)
        }
    }
