// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connectcampaignsv2

import aws.sdk.kotlin.runtime.auth.credentials.StaticCredentialsProvider
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.interceptors.AwsSpanInterceptor
import aws.sdk.kotlin.runtime.http.interceptors.businessmetrics.AwsBusinessMetric
import aws.sdk.kotlin.runtime.http.interceptors.businessmetrics.BusinessMetricsInterceptor
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.services.connectcampaignsv2.auth.ConnectCampaignsV2AuthSchemeProviderAdapter
import aws.sdk.kotlin.services.connectcampaignsv2.auth.ConnectCampaignsV2IdentityProviderConfigAdapter
import aws.sdk.kotlin.services.connectcampaignsv2.endpoints.internal.EndpointResolverAdapter
import aws.sdk.kotlin.services.connectcampaignsv2.model.*
import aws.sdk.kotlin.services.connectcampaignsv2.serde.*
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.awsprotocol.AwsAttributes
import aws.smithy.kotlin.runtime.businessmetrics.emitBusinessMetric
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.collections.attributesOf
import aws.smithy.kotlin.runtime.collections.putIfAbsent
import aws.smithy.kotlin.runtime.collections.putIfAbsentNotNull
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.SigV4AuthScheme
import aws.smithy.kotlin.runtime.http.operation.OperationAuthConfig
import aws.smithy.kotlin.runtime.http.operation.OperationMetrics
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.telemetry
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.operation.ExecutionContext

internal class DefaultConnectCampaignsV2Client(override val config: ConnectCampaignsV2Client.Config) : ConnectCampaignsV2Client {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClient)
    private val identityProviderConfig = ConnectCampaignsV2IdentityProviderConfigAdapter(config)
    private val configuredAuthSchemes = with(config.authSchemes.associateBy(AuthScheme::schemeId).toMutableMap()){
        getOrPut(AuthSchemeId.AwsSigV4){
            SigV4AuthScheme(DefaultAwsSigner, "connect-campaigns")
        }
        toMap()
    }
    private val authSchemeAdapter = ConnectCampaignsV2AuthSchemeProviderAdapter(config)
    private val telemetryScope = "aws.sdk.kotlin.services.connectcampaignsv2"
    private val opMetrics = OperationMetrics(telemetryScope, config.telemetryProvider)

    init {
        managedResources.addIfManaged(config.httpClient)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion), config.applicationId)

    /**
     * Creates a campaign for the specified Amazon Connect account. This API is idempotent.
     */
    override suspend fun createCampaign(input: CreateCampaignRequest): CreateCampaignResponse {
        val op = SdkHttpOperation.build<CreateCampaignRequest, CreateCampaignResponse> {
            serializeWith = CreateCampaignOperationSerializer()
            deserializeWith = CreateCampaignOperationDeserializer()
            operationName = "CreateCampaign"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a campaign from the specified Amazon Connect account.
     */
    override suspend fun deleteCampaign(input: DeleteCampaignRequest): DeleteCampaignResponse {
        val op = SdkHttpOperation.build<DeleteCampaignRequest, DeleteCampaignResponse> {
            serializeWith = DeleteCampaignOperationSerializer()
            deserializeWith = DeleteCampaignOperationDeserializer()
            operationName = "DeleteCampaign"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the channel subtype config of a campaign. This API is idempotent.
     */
    override suspend fun deleteCampaignChannelSubtypeConfig(input: DeleteCampaignChannelSubtypeConfigRequest): DeleteCampaignChannelSubtypeConfigResponse {
        val op = SdkHttpOperation.build<DeleteCampaignChannelSubtypeConfigRequest, DeleteCampaignChannelSubtypeConfigResponse> {
            serializeWith = DeleteCampaignChannelSubtypeConfigOperationSerializer()
            deserializeWith = DeleteCampaignChannelSubtypeConfigOperationDeserializer()
            operationName = "DeleteCampaignChannelSubtypeConfig"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the communication limits config for a campaign. This API is idempotent.
     */
    override suspend fun deleteCampaignCommunicationLimits(input: DeleteCampaignCommunicationLimitsRequest): DeleteCampaignCommunicationLimitsResponse {
        val op = SdkHttpOperation.build<DeleteCampaignCommunicationLimitsRequest, DeleteCampaignCommunicationLimitsResponse> {
            serializeWith = DeleteCampaignCommunicationLimitsOperationSerializer()
            deserializeWith = DeleteCampaignCommunicationLimitsOperationDeserializer()
            operationName = "DeleteCampaignCommunicationLimits"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the communication time config for a campaign. This API is idempotent.
     */
    override suspend fun deleteCampaignCommunicationTime(input: DeleteCampaignCommunicationTimeRequest): DeleteCampaignCommunicationTimeResponse {
        val op = SdkHttpOperation.build<DeleteCampaignCommunicationTimeRequest, DeleteCampaignCommunicationTimeResponse> {
            serializeWith = DeleteCampaignCommunicationTimeOperationSerializer()
            deserializeWith = DeleteCampaignCommunicationTimeOperationDeserializer()
            operationName = "DeleteCampaignCommunicationTime"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a connect instance config from the specified AWS account.
     */
    override suspend fun deleteConnectInstanceConfig(input: DeleteConnectInstanceConfigRequest): DeleteConnectInstanceConfigResponse {
        val op = SdkHttpOperation.build<DeleteConnectInstanceConfigRequest, DeleteConnectInstanceConfigResponse> {
            serializeWith = DeleteConnectInstanceConfigOperationSerializer()
            deserializeWith = DeleteConnectInstanceConfigOperationDeserializer()
            operationName = "DeleteConnectInstanceConfig"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Delete the integration for the specified Amazon Connect instance.
     */
    override suspend fun deleteConnectInstanceIntegration(input: DeleteConnectInstanceIntegrationRequest): DeleteConnectInstanceIntegrationResponse {
        val op = SdkHttpOperation.build<DeleteConnectInstanceIntegrationRequest, DeleteConnectInstanceIntegrationResponse> {
            serializeWith = DeleteConnectInstanceIntegrationOperationSerializer()
            deserializeWith = DeleteConnectInstanceIntegrationOperationDeserializer()
            operationName = "DeleteConnectInstanceIntegration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Delete the Connect Campaigns onboarding job for the specified Amazon Connect instance.
     */
    override suspend fun deleteInstanceOnboardingJob(input: DeleteInstanceOnboardingJobRequest): DeleteInstanceOnboardingJobResponse {
        val op = SdkHttpOperation.build<DeleteInstanceOnboardingJobRequest, DeleteInstanceOnboardingJobResponse> {
            serializeWith = DeleteInstanceOnboardingJobOperationSerializer()
            deserializeWith = DeleteInstanceOnboardingJobOperationDeserializer()
            operationName = "DeleteInstanceOnboardingJob"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specific campaign.
     */
    override suspend fun describeCampaign(input: DescribeCampaignRequest): DescribeCampaignResponse {
        val op = SdkHttpOperation.build<DescribeCampaignRequest, DescribeCampaignResponse> {
            serializeWith = DescribeCampaignOperationSerializer()
            deserializeWith = DescribeCampaignOperationDeserializer()
            operationName = "DescribeCampaign"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Get state of a campaign for the specified Amazon Connect account.
     */
    override suspend fun getCampaignState(input: GetCampaignStateRequest): GetCampaignStateResponse {
        val op = SdkHttpOperation.build<GetCampaignStateRequest, GetCampaignStateResponse> {
            serializeWith = GetCampaignStateOperationSerializer()
            deserializeWith = GetCampaignStateOperationDeserializer()
            operationName = "GetCampaignState"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Get state of campaigns for the specified Amazon Connect account.
     */
    override suspend fun getCampaignStateBatch(input: GetCampaignStateBatchRequest): GetCampaignStateBatchResponse {
        val op = SdkHttpOperation.build<GetCampaignStateBatchRequest, GetCampaignStateBatchResponse> {
            serializeWith = GetCampaignStateBatchOperationSerializer()
            deserializeWith = GetCampaignStateBatchOperationDeserializer()
            operationName = "GetCampaignStateBatch"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Get the specific Connect instance config.
     */
    override suspend fun getConnectInstanceConfig(input: GetConnectInstanceConfigRequest): GetConnectInstanceConfigResponse {
        val op = SdkHttpOperation.build<GetConnectInstanceConfigRequest, GetConnectInstanceConfigResponse> {
            serializeWith = GetConnectInstanceConfigOperationSerializer()
            deserializeWith = GetConnectInstanceConfigOperationDeserializer()
            operationName = "GetConnectInstanceConfig"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Get the instance communication limits.
     */
    override suspend fun getInstanceCommunicationLimits(input: GetInstanceCommunicationLimitsRequest): GetInstanceCommunicationLimitsResponse {
        val op = SdkHttpOperation.build<GetInstanceCommunicationLimitsRequest, GetInstanceCommunicationLimitsResponse> {
            serializeWith = GetInstanceCommunicationLimitsOperationSerializer()
            deserializeWith = GetInstanceCommunicationLimitsOperationDeserializer()
            operationName = "GetInstanceCommunicationLimits"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Get the specific instance onboarding job status.
     */
    override suspend fun getInstanceOnboardingJobStatus(input: GetInstanceOnboardingJobStatusRequest): GetInstanceOnboardingJobStatusResponse {
        val op = SdkHttpOperation.build<GetInstanceOnboardingJobStatusRequest, GetInstanceOnboardingJobStatusResponse> {
            serializeWith = GetInstanceOnboardingJobStatusOperationSerializer()
            deserializeWith = GetInstanceOnboardingJobStatusOperationDeserializer()
            operationName = "GetInstanceOnboardingJobStatus"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Provides summary information about the campaigns under the specified Amazon Connect account.
     */
    override suspend fun listCampaigns(input: ListCampaignsRequest): ListCampaignsResponse {
        val op = SdkHttpOperation.build<ListCampaignsRequest, ListCampaignsResponse> {
            serializeWith = ListCampaignsOperationSerializer()
            deserializeWith = ListCampaignsOperationDeserializer()
            operationName = "ListCampaigns"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Provides summary information about the integration under the specified Connect instance.
     */
    override suspend fun listConnectInstanceIntegrations(input: ListConnectInstanceIntegrationsRequest): ListConnectInstanceIntegrationsResponse {
        val op = SdkHttpOperation.build<ListConnectInstanceIntegrationsRequest, ListConnectInstanceIntegrationsResponse> {
            serializeWith = ListConnectInstanceIntegrationsOperationSerializer()
            deserializeWith = ListConnectInstanceIntegrationsOperationDeserializer()
            operationName = "ListConnectInstanceIntegrations"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * List tags for a resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializeWith = ListTagsForResourceOperationSerializer()
            deserializeWith = ListTagsForResourceOperationDeserializer()
            operationName = "ListTagsForResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Pauses a campaign for the specified Amazon Connect account.
     */
    override suspend fun pauseCampaign(input: PauseCampaignRequest): PauseCampaignResponse {
        val op = SdkHttpOperation.build<PauseCampaignRequest, PauseCampaignResponse> {
            serializeWith = PauseCampaignOperationSerializer()
            deserializeWith = PauseCampaignOperationDeserializer()
            operationName = "PauseCampaign"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Put or update the integration for the specified Amazon Connect instance.
     */
    override suspend fun putConnectInstanceIntegration(input: PutConnectInstanceIntegrationRequest): PutConnectInstanceIntegrationResponse {
        val op = SdkHttpOperation.build<PutConnectInstanceIntegrationRequest, PutConnectInstanceIntegrationResponse> {
            serializeWith = PutConnectInstanceIntegrationOperationSerializer()
            deserializeWith = PutConnectInstanceIntegrationOperationDeserializer()
            operationName = "PutConnectInstanceIntegration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Put the instance communication limits. This API is idempotent.
     */
    override suspend fun putInstanceCommunicationLimits(input: PutInstanceCommunicationLimitsRequest): PutInstanceCommunicationLimitsResponse {
        val op = SdkHttpOperation.build<PutInstanceCommunicationLimitsRequest, PutInstanceCommunicationLimitsResponse> {
            serializeWith = PutInstanceCommunicationLimitsOperationSerializer()
            deserializeWith = PutInstanceCommunicationLimitsOperationDeserializer()
            operationName = "PutInstanceCommunicationLimits"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates outbound requests for the specified campaign Amazon Connect account. This API is idempotent.
     */
    override suspend fun putOutboundRequestBatch(input: PutOutboundRequestBatchRequest): PutOutboundRequestBatchResponse {
        val op = SdkHttpOperation.build<PutOutboundRequestBatchRequest, PutOutboundRequestBatchResponse> {
            serializeWith = PutOutboundRequestBatchOperationSerializer()
            deserializeWith = PutOutboundRequestBatchOperationDeserializer()
            operationName = "PutOutboundRequestBatch"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Takes in a list of profile outbound requests to be placed as part of an outbound campaign. This API is idempotent.
     */
    override suspend fun putProfileOutboundRequestBatch(input: PutProfileOutboundRequestBatchRequest): PutProfileOutboundRequestBatchResponse {
        val op = SdkHttpOperation.build<PutProfileOutboundRequestBatchRequest, PutProfileOutboundRequestBatchResponse> {
            serializeWith = PutProfileOutboundRequestBatchOperationSerializer()
            deserializeWith = PutProfileOutboundRequestBatchOperationDeserializer()
            operationName = "PutProfileOutboundRequestBatch"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Stops a campaign for the specified Amazon Connect account.
     */
    override suspend fun resumeCampaign(input: ResumeCampaignRequest): ResumeCampaignResponse {
        val op = SdkHttpOperation.build<ResumeCampaignRequest, ResumeCampaignResponse> {
            serializeWith = ResumeCampaignOperationSerializer()
            deserializeWith = ResumeCampaignOperationDeserializer()
            operationName = "ResumeCampaign"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Starts a campaign for the specified Amazon Connect account.
     */
    override suspend fun startCampaign(input: StartCampaignRequest): StartCampaignResponse {
        val op = SdkHttpOperation.build<StartCampaignRequest, StartCampaignResponse> {
            serializeWith = StartCampaignOperationSerializer()
            deserializeWith = StartCampaignOperationDeserializer()
            operationName = "StartCampaign"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Onboard the specific Amazon Connect instance to Connect Campaigns.
     */
    override suspend fun startInstanceOnboardingJob(input: StartInstanceOnboardingJobRequest): StartInstanceOnboardingJobResponse {
        val op = SdkHttpOperation.build<StartInstanceOnboardingJobRequest, StartInstanceOnboardingJobResponse> {
            serializeWith = StartInstanceOnboardingJobOperationSerializer()
            deserializeWith = StartInstanceOnboardingJobOperationDeserializer()
            operationName = "StartInstanceOnboardingJob"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Stops a campaign for the specified Amazon Connect account.
     */
    override suspend fun stopCampaign(input: StopCampaignRequest): StopCampaignResponse {
        val op = SdkHttpOperation.build<StopCampaignRequest, StopCampaignResponse> {
            serializeWith = StopCampaignOperationSerializer()
            deserializeWith = StopCampaignOperationDeserializer()
            operationName = "StopCampaign"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Tag a resource.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializeWith = TagResourceOperationSerializer()
            deserializeWith = TagResourceOperationDeserializer()
            operationName = "TagResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Untag a resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializeWith = UntagResourceOperationSerializer()
            deserializeWith = UntagResourceOperationDeserializer()
            operationName = "UntagResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the channel subtype config of a campaign. This API is idempotent.
     */
    override suspend fun updateCampaignChannelSubtypeConfig(input: UpdateCampaignChannelSubtypeConfigRequest): UpdateCampaignChannelSubtypeConfigResponse {
        val op = SdkHttpOperation.build<UpdateCampaignChannelSubtypeConfigRequest, UpdateCampaignChannelSubtypeConfigResponse> {
            serializeWith = UpdateCampaignChannelSubtypeConfigOperationSerializer()
            deserializeWith = UpdateCampaignChannelSubtypeConfigOperationDeserializer()
            operationName = "UpdateCampaignChannelSubtypeConfig"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the communication limits config for a campaign. This API is idempotent.
     */
    override suspend fun updateCampaignCommunicationLimits(input: UpdateCampaignCommunicationLimitsRequest): UpdateCampaignCommunicationLimitsResponse {
        val op = SdkHttpOperation.build<UpdateCampaignCommunicationLimitsRequest, UpdateCampaignCommunicationLimitsResponse> {
            serializeWith = UpdateCampaignCommunicationLimitsOperationSerializer()
            deserializeWith = UpdateCampaignCommunicationLimitsOperationDeserializer()
            operationName = "UpdateCampaignCommunicationLimits"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the communication time config for a campaign. This API is idempotent.
     */
    override suspend fun updateCampaignCommunicationTime(input: UpdateCampaignCommunicationTimeRequest): UpdateCampaignCommunicationTimeResponse {
        val op = SdkHttpOperation.build<UpdateCampaignCommunicationTimeRequest, UpdateCampaignCommunicationTimeResponse> {
            serializeWith = UpdateCampaignCommunicationTimeOperationSerializer()
            deserializeWith = UpdateCampaignCommunicationTimeOperationDeserializer()
            operationName = "UpdateCampaignCommunicationTime"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the campaign flow associated with a campaign. This API is idempotent.
     */
    override suspend fun updateCampaignFlowAssociation(input: UpdateCampaignFlowAssociationRequest): UpdateCampaignFlowAssociationResponse {
        val op = SdkHttpOperation.build<UpdateCampaignFlowAssociationRequest, UpdateCampaignFlowAssociationResponse> {
            serializeWith = UpdateCampaignFlowAssociationOperationSerializer()
            deserializeWith = UpdateCampaignFlowAssociationOperationDeserializer()
            operationName = "UpdateCampaignFlowAssociation"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the name of a campaign. This API is idempotent.
     */
    override suspend fun updateCampaignName(input: UpdateCampaignNameRequest): UpdateCampaignNameResponse {
        val op = SdkHttpOperation.build<UpdateCampaignNameRequest, UpdateCampaignNameResponse> {
            serializeWith = UpdateCampaignNameOperationSerializer()
            deserializeWith = UpdateCampaignNameOperationDeserializer()
            operationName = "UpdateCampaignName"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the schedule for a campaign. This API is idempotent.
     */
    override suspend fun updateCampaignSchedule(input: UpdateCampaignScheduleRequest): UpdateCampaignScheduleResponse {
        val op = SdkHttpOperation.build<UpdateCampaignScheduleRequest, UpdateCampaignScheduleResponse> {
            serializeWith = UpdateCampaignScheduleOperationSerializer()
            deserializeWith = UpdateCampaignScheduleOperationDeserializer()
            operationName = "UpdateCampaignSchedule"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the campaign source with a campaign. This API is idempotent.
     */
    override suspend fun updateCampaignSource(input: UpdateCampaignSourceRequest): UpdateCampaignSourceResponse {
        val op = SdkHttpOperation.build<UpdateCampaignSourceRequest, UpdateCampaignSourceResponse> {
            serializeWith = UpdateCampaignSourceOperationSerializer()
            deserializeWith = UpdateCampaignSourceOperationDeserializer()
            operationName = "UpdateCampaignSource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(SdkClientOption.ClientName, config.clientName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.logMode)
        ctx.putIfAbsentNotNull(AwsAttributes.Region, config.region)
        ctx.putIfAbsentNotNull(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "connect-campaigns")
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }

}
