// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connectcampaigns.paginators

import aws.sdk.kotlin.services.connectcampaigns.ConnectCampaignsClient
import aws.sdk.kotlin.services.connectcampaigns.model.CampaignSummary
import aws.sdk.kotlin.services.connectcampaigns.model.ListCampaignsRequest
import aws.sdk.kotlin.services.connectcampaigns.model.ListCampaignsResponse
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListCampaignsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListCampaignsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCampaignsResponse]
 */
public fun ConnectCampaignsClient.listCampaignsPaginated(initialRequest: ListCampaignsRequest): Flow<ListCampaignsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCampaignsPaginated.listCampaigns(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListCampaignsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCampaignsResponse]
 */
public fun ConnectCampaignsClient.listCampaignsPaginated(block: ListCampaignsRequest.Builder.() -> Unit): Flow<ListCampaignsResponse> =
    listCampaignsPaginated(ListCampaignsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listCampaignsPaginated]
 * to access the nested member [CampaignSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [CampaignSummary]
 */
@JvmName("listCampaignsResponseCampaignSummary")
public fun Flow<ListCampaignsResponse>.campaignSummaryList(): Flow<CampaignSummary> =
    transform() { response ->
        response.campaignSummaryList?.forEach {
            emit(it)
        }
    }
