// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connectcampaigns

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.connectcampaigns.model.*
import aws.sdk.kotlin.services.connectcampaigns.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


public const val ServiceId: String = "ConnectCampaigns"
public const val ServiceApiVersion: String = "2021-01-30"
public const val SdkVersion: String = "0.17.10-beta"

internal class DefaultConnectCampaignsClient(override val config: ConnectCampaignsClient.Config) : ConnectCampaignsClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Creates a campaign for the specified Amazon Connect account. This API is idempotent.
     */
    override suspend fun createCampaign(input: CreateCampaignRequest): CreateCampaignResponse {
        val op = SdkHttpOperation.build<CreateCampaignRequest, CreateCampaignResponse> {
            serializer = CreateCampaignOperationSerializer()
            deserializer = CreateCampaignOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateCampaign"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "connect-campaigns"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a campaign from the specified Amazon Connect account.
     */
    override suspend fun deleteCampaign(input: DeleteCampaignRequest): DeleteCampaignResponse {
        val op = SdkHttpOperation.build<DeleteCampaignRequest, DeleteCampaignResponse> {
            serializer = DeleteCampaignOperationSerializer()
            deserializer = DeleteCampaignOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteCampaign"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "connect-campaigns"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a connect instance config from the specified AWS account.
     */
    override suspend fun deleteConnectInstanceConfig(input: DeleteConnectInstanceConfigRequest): DeleteConnectInstanceConfigResponse {
        val op = SdkHttpOperation.build<DeleteConnectInstanceConfigRequest, DeleteConnectInstanceConfigResponse> {
            serializer = DeleteConnectInstanceConfigOperationSerializer()
            deserializer = DeleteConnectInstanceConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteConnectInstanceConfig"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "connect-campaigns"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Delete the Connect Campaigns onboarding job for the specified Amazon Connect instance.
     */
    override suspend fun deleteInstanceOnboardingJob(input: DeleteInstanceOnboardingJobRequest): DeleteInstanceOnboardingJobResponse {
        val op = SdkHttpOperation.build<DeleteInstanceOnboardingJobRequest, DeleteInstanceOnboardingJobResponse> {
            serializer = DeleteInstanceOnboardingJobOperationSerializer()
            deserializer = DeleteInstanceOnboardingJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteInstanceOnboardingJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "connect-campaigns"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specific campaign.
     */
    override suspend fun describeCampaign(input: DescribeCampaignRequest): DescribeCampaignResponse {
        val op = SdkHttpOperation.build<DescribeCampaignRequest, DescribeCampaignResponse> {
            serializer = DescribeCampaignOperationSerializer()
            deserializer = DescribeCampaignOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeCampaign"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "connect-campaigns"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Get state of a campaign for the specified Amazon Connect account.
     */
    override suspend fun getCampaignState(input: GetCampaignStateRequest): GetCampaignStateResponse {
        val op = SdkHttpOperation.build<GetCampaignStateRequest, GetCampaignStateResponse> {
            serializer = GetCampaignStateOperationSerializer()
            deserializer = GetCampaignStateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetCampaignState"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "connect-campaigns"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Get state of campaigns for the specified Amazon Connect account.
     */
    override suspend fun getCampaignStateBatch(input: GetCampaignStateBatchRequest): GetCampaignStateBatchResponse {
        val op = SdkHttpOperation.build<GetCampaignStateBatchRequest, GetCampaignStateBatchResponse> {
            serializer = GetCampaignStateBatchOperationSerializer()
            deserializer = GetCampaignStateBatchOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetCampaignStateBatch"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "connect-campaigns"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Get the specific Connect instance config.
     */
    override suspend fun getConnectInstanceConfig(input: GetConnectInstanceConfigRequest): GetConnectInstanceConfigResponse {
        val op = SdkHttpOperation.build<GetConnectInstanceConfigRequest, GetConnectInstanceConfigResponse> {
            serializer = GetConnectInstanceConfigOperationSerializer()
            deserializer = GetConnectInstanceConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetConnectInstanceConfig"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "connect-campaigns"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Get the specific instance onboarding job status.
     */
    override suspend fun getInstanceOnboardingJobStatus(input: GetInstanceOnboardingJobStatusRequest): GetInstanceOnboardingJobStatusResponse {
        val op = SdkHttpOperation.build<GetInstanceOnboardingJobStatusRequest, GetInstanceOnboardingJobStatusResponse> {
            serializer = GetInstanceOnboardingJobStatusOperationSerializer()
            deserializer = GetInstanceOnboardingJobStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetInstanceOnboardingJobStatus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "connect-campaigns"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides summary information about the campaigns under the specified Amazon Connect account.
     */
    override suspend fun listCampaigns(input: ListCampaignsRequest): ListCampaignsResponse {
        val op = SdkHttpOperation.build<ListCampaignsRequest, ListCampaignsResponse> {
            serializer = ListCampaignsOperationSerializer()
            deserializer = ListCampaignsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListCampaigns"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "connect-campaigns"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List tags for a resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "connect-campaigns"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Pauses a campaign for the specified Amazon Connect account.
     */
    override suspend fun pauseCampaign(input: PauseCampaignRequest): PauseCampaignResponse {
        val op = SdkHttpOperation.build<PauseCampaignRequest, PauseCampaignResponse> {
            serializer = PauseCampaignOperationSerializer()
            deserializer = PauseCampaignOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PauseCampaign"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "connect-campaigns"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates dials requests for the specified campaign Amazon Connect account. This API is idempotent.
     */
    override suspend fun putDialRequestBatch(input: PutDialRequestBatchRequest): PutDialRequestBatchResponse {
        val op = SdkHttpOperation.build<PutDialRequestBatchRequest, PutDialRequestBatchResponse> {
            serializer = PutDialRequestBatchOperationSerializer()
            deserializer = PutDialRequestBatchOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutDialRequestBatch"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "connect-campaigns"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Stops a campaign for the specified Amazon Connect account.
     */
    override suspend fun resumeCampaign(input: ResumeCampaignRequest): ResumeCampaignResponse {
        val op = SdkHttpOperation.build<ResumeCampaignRequest, ResumeCampaignResponse> {
            serializer = ResumeCampaignOperationSerializer()
            deserializer = ResumeCampaignOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ResumeCampaign"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "connect-campaigns"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts a campaign for the specified Amazon Connect account.
     */
    override suspend fun startCampaign(input: StartCampaignRequest): StartCampaignResponse {
        val op = SdkHttpOperation.build<StartCampaignRequest, StartCampaignResponse> {
            serializer = StartCampaignOperationSerializer()
            deserializer = StartCampaignOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartCampaign"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "connect-campaigns"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Onboard the specific Amazon Connect instance to Connect Campaigns.
     */
    override suspend fun startInstanceOnboardingJob(input: StartInstanceOnboardingJobRequest): StartInstanceOnboardingJobResponse {
        val op = SdkHttpOperation.build<StartInstanceOnboardingJobRequest, StartInstanceOnboardingJobResponse> {
            serializer = StartInstanceOnboardingJobOperationSerializer()
            deserializer = StartInstanceOnboardingJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartInstanceOnboardingJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "connect-campaigns"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Stops a campaign for the specified Amazon Connect account.
     */
    override suspend fun stopCampaign(input: StopCampaignRequest): StopCampaignResponse {
        val op = SdkHttpOperation.build<StopCampaignRequest, StopCampaignResponse> {
            serializer = StopCampaignOperationSerializer()
            deserializer = StopCampaignOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StopCampaign"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "connect-campaigns"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Tag a resource.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "connect-campaigns"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Untag a resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "connect-campaigns"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the dialer config of a campaign. This API is idempotent.
     */
    override suspend fun updateCampaignDialerConfig(input: UpdateCampaignDialerConfigRequest): UpdateCampaignDialerConfigResponse {
        val op = SdkHttpOperation.build<UpdateCampaignDialerConfigRequest, UpdateCampaignDialerConfigResponse> {
            serializer = UpdateCampaignDialerConfigOperationSerializer()
            deserializer = UpdateCampaignDialerConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateCampaignDialerConfig"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "connect-campaigns"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the name of a campaign. This API is idempotent.
     */
    override suspend fun updateCampaignName(input: UpdateCampaignNameRequest): UpdateCampaignNameResponse {
        val op = SdkHttpOperation.build<UpdateCampaignNameRequest, UpdateCampaignNameResponse> {
            serializer = UpdateCampaignNameOperationSerializer()
            deserializer = UpdateCampaignNameOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateCampaignName"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "connect-campaigns"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the outbound call config of a campaign. This API is idempotent.
     */
    override suspend fun updateCampaignOutboundCallConfig(input: UpdateCampaignOutboundCallConfigRequest): UpdateCampaignOutboundCallConfigResponse {
        val op = SdkHttpOperation.build<UpdateCampaignOutboundCallConfigRequest, UpdateCampaignOutboundCallConfigResponse> {
            serializer = UpdateCampaignOutboundCallConfigOperationSerializer()
            deserializer = UpdateCampaignOutboundCallConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateCampaignOutboundCallConfig"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "connect-campaigns"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "connect-campaigns")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
