// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connectcampaigns

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.connectcampaigns.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.connectcampaigns.model.*
import aws.sdk.kotlin.services.connectcampaigns.model.CreateCampaignRequest
import aws.sdk.kotlin.services.connectcampaigns.model.CreateCampaignResponse
import aws.sdk.kotlin.services.connectcampaigns.model.DeleteCampaignRequest
import aws.sdk.kotlin.services.connectcampaigns.model.DeleteCampaignResponse
import aws.sdk.kotlin.services.connectcampaigns.model.DeleteConnectInstanceConfigRequest
import aws.sdk.kotlin.services.connectcampaigns.model.DeleteConnectInstanceConfigResponse
import aws.sdk.kotlin.services.connectcampaigns.model.DeleteInstanceOnboardingJobRequest
import aws.sdk.kotlin.services.connectcampaigns.model.DeleteInstanceOnboardingJobResponse
import aws.sdk.kotlin.services.connectcampaigns.model.DescribeCampaignRequest
import aws.sdk.kotlin.services.connectcampaigns.model.DescribeCampaignResponse
import aws.sdk.kotlin.services.connectcampaigns.model.GetCampaignStateBatchRequest
import aws.sdk.kotlin.services.connectcampaigns.model.GetCampaignStateBatchResponse
import aws.sdk.kotlin.services.connectcampaigns.model.GetCampaignStateRequest
import aws.sdk.kotlin.services.connectcampaigns.model.GetCampaignStateResponse
import aws.sdk.kotlin.services.connectcampaigns.model.GetConnectInstanceConfigRequest
import aws.sdk.kotlin.services.connectcampaigns.model.GetConnectInstanceConfigResponse
import aws.sdk.kotlin.services.connectcampaigns.model.GetInstanceOnboardingJobStatusRequest
import aws.sdk.kotlin.services.connectcampaigns.model.GetInstanceOnboardingJobStatusResponse
import aws.sdk.kotlin.services.connectcampaigns.model.ListCampaignsRequest
import aws.sdk.kotlin.services.connectcampaigns.model.ListCampaignsResponse
import aws.sdk.kotlin.services.connectcampaigns.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.connectcampaigns.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.connectcampaigns.model.PauseCampaignRequest
import aws.sdk.kotlin.services.connectcampaigns.model.PauseCampaignResponse
import aws.sdk.kotlin.services.connectcampaigns.model.PutDialRequestBatchRequest
import aws.sdk.kotlin.services.connectcampaigns.model.PutDialRequestBatchResponse
import aws.sdk.kotlin.services.connectcampaigns.model.ResumeCampaignRequest
import aws.sdk.kotlin.services.connectcampaigns.model.ResumeCampaignResponse
import aws.sdk.kotlin.services.connectcampaigns.model.StartCampaignRequest
import aws.sdk.kotlin.services.connectcampaigns.model.StartCampaignResponse
import aws.sdk.kotlin.services.connectcampaigns.model.StartInstanceOnboardingJobRequest
import aws.sdk.kotlin.services.connectcampaigns.model.StartInstanceOnboardingJobResponse
import aws.sdk.kotlin.services.connectcampaigns.model.StopCampaignRequest
import aws.sdk.kotlin.services.connectcampaigns.model.StopCampaignResponse
import aws.sdk.kotlin.services.connectcampaigns.model.TagResourceRequest
import aws.sdk.kotlin.services.connectcampaigns.model.TagResourceResponse
import aws.sdk.kotlin.services.connectcampaigns.model.UntagResourceRequest
import aws.sdk.kotlin.services.connectcampaigns.model.UntagResourceResponse
import aws.sdk.kotlin.services.connectcampaigns.model.UpdateCampaignDialerConfigRequest
import aws.sdk.kotlin.services.connectcampaigns.model.UpdateCampaignDialerConfigResponse
import aws.sdk.kotlin.services.connectcampaigns.model.UpdateCampaignNameRequest
import aws.sdk.kotlin.services.connectcampaigns.model.UpdateCampaignNameResponse
import aws.sdk.kotlin.services.connectcampaigns.model.UpdateCampaignOutboundCallConfigRequest
import aws.sdk.kotlin.services.connectcampaigns.model.UpdateCampaignOutboundCallConfigResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * Provide APIs to create and manage Amazon Connect Campaigns.
 */
public interface ConnectCampaignsClient : SdkClient {

    override val serviceName: String
        get() = "ConnectCampaigns"
    /**
     * ConnectCampaignsClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): ConnectCampaignsClient {
            val config = Config.Builder().apply(block).build()
            return DefaultConnectCampaignsClient(config)
        }

        public operator fun invoke(config: Config): ConnectCampaignsClient = DefaultConnectCampaignsClient(config)

        /**
         * Construct a [ConnectCampaignsClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): ConnectCampaignsClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultConnectCampaignsClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a campaign for the specified Amazon Connect account. This API is idempotent.
     */
    public suspend fun createCampaign(input: CreateCampaignRequest): CreateCampaignResponse

    /**
     * Deletes a campaign from the specified Amazon Connect account.
     */
    public suspend fun deleteCampaign(input: DeleteCampaignRequest): DeleteCampaignResponse

    /**
     * Deletes a connect instance config from the specified AWS account.
     */
    public suspend fun deleteConnectInstanceConfig(input: DeleteConnectInstanceConfigRequest): DeleteConnectInstanceConfigResponse

    /**
     * Delete the Connect Campaigns onboarding job for the specified Amazon Connect instance.
     */
    public suspend fun deleteInstanceOnboardingJob(input: DeleteInstanceOnboardingJobRequest): DeleteInstanceOnboardingJobResponse

    /**
     * Describes the specific campaign.
     */
    public suspend fun describeCampaign(input: DescribeCampaignRequest): DescribeCampaignResponse

    /**
     * Get state of a campaign for the specified Amazon Connect account.
     */
    public suspend fun getCampaignState(input: GetCampaignStateRequest): GetCampaignStateResponse

    /**
     * Get state of campaigns for the specified Amazon Connect account.
     */
    public suspend fun getCampaignStateBatch(input: GetCampaignStateBatchRequest): GetCampaignStateBatchResponse

    /**
     * Get the specific Connect instance config.
     */
    public suspend fun getConnectInstanceConfig(input: GetConnectInstanceConfigRequest): GetConnectInstanceConfigResponse

    /**
     * Get the specific instance onboarding job status.
     */
    public suspend fun getInstanceOnboardingJobStatus(input: GetInstanceOnboardingJobStatusRequest): GetInstanceOnboardingJobStatusResponse

    /**
     * Provides summary information about the campaigns under the specified Amazon Connect account.
     */
    public suspend fun listCampaigns(input: ListCampaignsRequest = ListCampaignsRequest {}): ListCampaignsResponse

    /**
     * List tags for a resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Pauses a campaign for the specified Amazon Connect account.
     */
    public suspend fun pauseCampaign(input: PauseCampaignRequest): PauseCampaignResponse

    /**
     * Creates dials requests for the specified campaign Amazon Connect account. This API is idempotent.
     */
    public suspend fun putDialRequestBatch(input: PutDialRequestBatchRequest): PutDialRequestBatchResponse

    /**
     * Stops a campaign for the specified Amazon Connect account.
     */
    public suspend fun resumeCampaign(input: ResumeCampaignRequest): ResumeCampaignResponse

    /**
     * Starts a campaign for the specified Amazon Connect account.
     */
    public suspend fun startCampaign(input: StartCampaignRequest): StartCampaignResponse

    /**
     * Onboard the specific Amazon Connect instance to Connect Campaigns.
     */
    public suspend fun startInstanceOnboardingJob(input: StartInstanceOnboardingJobRequest): StartInstanceOnboardingJobResponse

    /**
     * Stops a campaign for the specified Amazon Connect account.
     */
    public suspend fun stopCampaign(input: StopCampaignRequest): StopCampaignResponse

    /**
     * Tag a resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Untag a resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates the dialer config of a campaign. This API is idempotent.
     */
    public suspend fun updateCampaignDialerConfig(input: UpdateCampaignDialerConfigRequest): UpdateCampaignDialerConfigResponse

    /**
     * Updates the name of a campaign. This API is idempotent.
     */
    public suspend fun updateCampaignName(input: UpdateCampaignNameRequest): UpdateCampaignNameResponse

    /**
     * Updates the outbound call config of a campaign. This API is idempotent.
     */
    public suspend fun updateCampaignOutboundCallConfig(input: UpdateCampaignOutboundCallConfigRequest): UpdateCampaignOutboundCallConfigResponse
}

/**
 * Creates a campaign for the specified Amazon Connect account. This API is idempotent.
 */
public suspend inline fun ConnectCampaignsClient.createCampaign(crossinline block: CreateCampaignRequest.Builder.() -> Unit): CreateCampaignResponse = createCampaign(CreateCampaignRequest.Builder().apply(block).build())

/**
 * Deletes a campaign from the specified Amazon Connect account.
 */
public suspend inline fun ConnectCampaignsClient.deleteCampaign(crossinline block: DeleteCampaignRequest.Builder.() -> Unit): DeleteCampaignResponse = deleteCampaign(DeleteCampaignRequest.Builder().apply(block).build())

/**
 * Deletes a connect instance config from the specified AWS account.
 */
public suspend inline fun ConnectCampaignsClient.deleteConnectInstanceConfig(crossinline block: DeleteConnectInstanceConfigRequest.Builder.() -> Unit): DeleteConnectInstanceConfigResponse = deleteConnectInstanceConfig(DeleteConnectInstanceConfigRequest.Builder().apply(block).build())

/**
 * Delete the Connect Campaigns onboarding job for the specified Amazon Connect instance.
 */
public suspend inline fun ConnectCampaignsClient.deleteInstanceOnboardingJob(crossinline block: DeleteInstanceOnboardingJobRequest.Builder.() -> Unit): DeleteInstanceOnboardingJobResponse = deleteInstanceOnboardingJob(DeleteInstanceOnboardingJobRequest.Builder().apply(block).build())

/**
 * Describes the specific campaign.
 */
public suspend inline fun ConnectCampaignsClient.describeCampaign(crossinline block: DescribeCampaignRequest.Builder.() -> Unit): DescribeCampaignResponse = describeCampaign(DescribeCampaignRequest.Builder().apply(block).build())

/**
 * Get state of a campaign for the specified Amazon Connect account.
 */
public suspend inline fun ConnectCampaignsClient.getCampaignState(crossinline block: GetCampaignStateRequest.Builder.() -> Unit): GetCampaignStateResponse = getCampaignState(GetCampaignStateRequest.Builder().apply(block).build())

/**
 * Get state of campaigns for the specified Amazon Connect account.
 */
public suspend inline fun ConnectCampaignsClient.getCampaignStateBatch(crossinline block: GetCampaignStateBatchRequest.Builder.() -> Unit): GetCampaignStateBatchResponse = getCampaignStateBatch(GetCampaignStateBatchRequest.Builder().apply(block).build())

/**
 * Get the specific Connect instance config.
 */
public suspend inline fun ConnectCampaignsClient.getConnectInstanceConfig(crossinline block: GetConnectInstanceConfigRequest.Builder.() -> Unit): GetConnectInstanceConfigResponse = getConnectInstanceConfig(GetConnectInstanceConfigRequest.Builder().apply(block).build())

/**
 * Get the specific instance onboarding job status.
 */
public suspend inline fun ConnectCampaignsClient.getInstanceOnboardingJobStatus(crossinline block: GetInstanceOnboardingJobStatusRequest.Builder.() -> Unit): GetInstanceOnboardingJobStatusResponse = getInstanceOnboardingJobStatus(GetInstanceOnboardingJobStatusRequest.Builder().apply(block).build())

/**
 * Provides summary information about the campaigns under the specified Amazon Connect account.
 */
public suspend inline fun ConnectCampaignsClient.listCampaigns(crossinline block: ListCampaignsRequest.Builder.() -> Unit): ListCampaignsResponse = listCampaigns(ListCampaignsRequest.Builder().apply(block).build())

/**
 * List tags for a resource.
 */
public suspend inline fun ConnectCampaignsClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Pauses a campaign for the specified Amazon Connect account.
 */
public suspend inline fun ConnectCampaignsClient.pauseCampaign(crossinline block: PauseCampaignRequest.Builder.() -> Unit): PauseCampaignResponse = pauseCampaign(PauseCampaignRequest.Builder().apply(block).build())

/**
 * Creates dials requests for the specified campaign Amazon Connect account. This API is idempotent.
 */
public suspend inline fun ConnectCampaignsClient.putDialRequestBatch(crossinline block: PutDialRequestBatchRequest.Builder.() -> Unit): PutDialRequestBatchResponse = putDialRequestBatch(PutDialRequestBatchRequest.Builder().apply(block).build())

/**
 * Stops a campaign for the specified Amazon Connect account.
 */
public suspend inline fun ConnectCampaignsClient.resumeCampaign(crossinline block: ResumeCampaignRequest.Builder.() -> Unit): ResumeCampaignResponse = resumeCampaign(ResumeCampaignRequest.Builder().apply(block).build())

/**
 * Starts a campaign for the specified Amazon Connect account.
 */
public suspend inline fun ConnectCampaignsClient.startCampaign(crossinline block: StartCampaignRequest.Builder.() -> Unit): StartCampaignResponse = startCampaign(StartCampaignRequest.Builder().apply(block).build())

/**
 * Onboard the specific Amazon Connect instance to Connect Campaigns.
 */
public suspend inline fun ConnectCampaignsClient.startInstanceOnboardingJob(crossinline block: StartInstanceOnboardingJobRequest.Builder.() -> Unit): StartInstanceOnboardingJobResponse = startInstanceOnboardingJob(StartInstanceOnboardingJobRequest.Builder().apply(block).build())

/**
 * Stops a campaign for the specified Amazon Connect account.
 */
public suspend inline fun ConnectCampaignsClient.stopCampaign(crossinline block: StopCampaignRequest.Builder.() -> Unit): StopCampaignResponse = stopCampaign(StopCampaignRequest.Builder().apply(block).build())

/**
 * Tag a resource.
 */
public suspend inline fun ConnectCampaignsClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Untag a resource.
 */
public suspend inline fun ConnectCampaignsClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates the dialer config of a campaign. This API is idempotent.
 */
public suspend inline fun ConnectCampaignsClient.updateCampaignDialerConfig(crossinline block: UpdateCampaignDialerConfigRequest.Builder.() -> Unit): UpdateCampaignDialerConfigResponse = updateCampaignDialerConfig(UpdateCampaignDialerConfigRequest.Builder().apply(block).build())

/**
 * Updates the name of a campaign. This API is idempotent.
 */
public suspend inline fun ConnectCampaignsClient.updateCampaignName(crossinline block: UpdateCampaignNameRequest.Builder.() -> Unit): UpdateCampaignNameResponse = updateCampaignName(UpdateCampaignNameRequest.Builder().apply(block).build())

/**
 * Updates the outbound call config of a campaign. This API is idempotent.
 */
public suspend inline fun ConnectCampaignsClient.updateCampaignOutboundCallConfig(crossinline block: UpdateCampaignOutboundCallConfigRequest.Builder.() -> Unit): UpdateCampaignOutboundCallConfigResponse = updateCampaignOutboundCallConfig(UpdateCampaignOutboundCallConfigRequest.Builder().apply(block).build())
