// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.transform

import aws.sdk.kotlin.services.connect.model.UpdateSecurityProfileRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateSecurityProfileOperationSerializer: HttpSerialize<UpdateSecurityProfileRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateSecurityProfileRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf<String>(
                "security-profiles",
                "${input.instanceId}".encodeLabel(),
                "${input.securityProfileId}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeUpdateSecurityProfileOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateSecurityProfileOperationBody(context: ExecutionContext, input: UpdateSecurityProfileRequest): ByteArray {
    val serializer = JsonSerializer()
    val ALLOWEDACCESSCONTROLTAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("AllowedAccessControlTags"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val PERMISSIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Permissions"))
    val TAGRESTRICTEDRESOURCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("TagRestrictedResources"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ALLOWEDACCESSCONTROLTAGS_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(PERMISSIONS_DESCRIPTOR)
        field(TAGRESTRICTEDRESOURCES_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.allowedAccessControlTags != null) {
            mapField(ALLOWEDACCESSCONTROLTAGS_DESCRIPTOR) {
                input.allowedAccessControlTags.forEach { (key, value) -> entry(key, value) }
            }
        }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        if (input.permissions != null) {
            listField(PERMISSIONS_DESCRIPTOR) {
                for (el0 in input.permissions) {
                    serializeString(el0)
                }
            }
        }
        if (input.tagRestrictedResources != null) {
            listField(TAGRESTRICTEDRESOURCES_DESCRIPTOR) {
                for (el0 in input.tagRestrictedResources) {
                    serializeString(el0)
                }
            }
        }
    }
    return serializer.toByteArray()
}
