// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.transform

import aws.sdk.kotlin.services.connect.model.MediaConcurrency
import aws.sdk.kotlin.services.connect.model.UpdateRoutingProfileConcurrencyRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateRoutingProfileConcurrencyOperationSerializer: HttpSerialize<UpdateRoutingProfileConcurrencyRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateRoutingProfileConcurrencyRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf<String>(
                "routing-profiles",
                "${input.instanceId}".encodeLabel(),
                "${input.routingProfileId}".encodeLabel(),
                "concurrency",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeUpdateRoutingProfileConcurrencyOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateRoutingProfileConcurrencyOperationBody(context: ExecutionContext, input: UpdateRoutingProfileConcurrencyRequest): ByteArray {
    val serializer = JsonSerializer()
    val MEDIACONCURRENCIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("MediaConcurrencies"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(MEDIACONCURRENCIES_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.mediaConcurrencies != null) {
            listField(MEDIACONCURRENCIES_DESCRIPTOR) {
                for (el0 in input.mediaConcurrencies) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeMediaConcurrencyDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
