// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.transform

import aws.sdk.kotlin.services.connect.model.ConnectException
import aws.sdk.kotlin.services.connect.model.UpdatePhoneNumberResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdatePhoneNumberOperationDeserializer: HttpDeserialize<UpdatePhoneNumberResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdatePhoneNumberResponse {
        if (!response.status.isSuccess()) {
            throwUpdatePhoneNumberError(context, response)
        }
        val builder = UpdatePhoneNumberResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdatePhoneNumberOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwUpdatePhoneNumberError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ConnectException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "IdempotencyException" -> IdempotencyExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServiceException" -> InternalServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceInUseException" -> ResourceInUseExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ConnectException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdatePhoneNumberOperationBody(builder: UpdatePhoneNumberResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val PHONENUMBERARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PhoneNumberArn"))
    val PHONENUMBERID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PhoneNumberId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(PHONENUMBERARN_DESCRIPTOR)
        field(PHONENUMBERID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                PHONENUMBERARN_DESCRIPTOR.index -> builder.phoneNumberArn = deserializeString()
                PHONENUMBERID_DESCRIPTOR.index -> builder.phoneNumberId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
