// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.transform

import aws.sdk.kotlin.services.connect.model.Reference
import aws.sdk.kotlin.services.connect.model.StartTaskContactRequest
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class StartTaskContactOperationSerializer: HttpSerialize<StartTaskContactRequest> {
    override suspend fun serialize(context: ExecutionContext, input: StartTaskContactRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            path = "/contact/task"
        }

        val payload = serializeStartTaskContactOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeStartTaskContactOperationBody(context: ExecutionContext, input: StartTaskContactRequest): ByteArray {
    val serializer = JsonSerializer()
    val ATTRIBUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Attributes"))
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ClientToken"))
    val CONTACTFLOWID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ContactFlowId"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val INSTANCEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("InstanceId"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val PREVIOUSCONTACTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PreviousContactId"))
    val QUICKCONNECTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("QuickConnectId"))
    val REFERENCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("References"))
    val RELATEDCONTACTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RelatedContactId"))
    val SCHEDULEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("ScheduledTime"))
    val TASKTEMPLATEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TaskTemplateId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ATTRIBUTES_DESCRIPTOR)
        field(CLIENTTOKEN_DESCRIPTOR)
        field(CONTACTFLOWID_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(INSTANCEID_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(PREVIOUSCONTACTID_DESCRIPTOR)
        field(QUICKCONNECTID_DESCRIPTOR)
        field(REFERENCES_DESCRIPTOR)
        field(RELATEDCONTACTID_DESCRIPTOR)
        field(SCHEDULEDTIME_DESCRIPTOR)
        field(TASKTEMPLATEID_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.attributes != null) {
            mapField(ATTRIBUTES_DESCRIPTOR) {
                input.attributes.forEach { (key, value) -> entry(key, value) }
            }
        }
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.contactFlowId?.let { field(CONTACTFLOWID_DESCRIPTOR, it) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.instanceId?.let { field(INSTANCEID_DESCRIPTOR, it) }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        input.previousContactId?.let { field(PREVIOUSCONTACTID_DESCRIPTOR, it) }
        input.quickConnectId?.let { field(QUICKCONNECTID_DESCRIPTOR, it) }
        if (input.references != null) {
            mapField(REFERENCES_DESCRIPTOR) {
                input.references.forEach { (key, value) -> entry(key, asSdkSerializable(value, ::serializeReferenceDocument)) }
            }
        }
        input.relatedContactId?.let { field(RELATEDCONTACTID_DESCRIPTOR, it) }
        input.scheduledTime?.let { field(SCHEDULEDTIME_DESCRIPTOR, it, TimestampFormat.EPOCH_SECONDS) }
        input.taskTemplateId?.let { field(TASKTEMPLATEID_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
