// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.transform

import aws.sdk.kotlin.services.connect.model.ConnectException
import aws.sdk.kotlin.services.connect.model.SearchSecurityProfilesResponse
import aws.sdk.kotlin.services.connect.model.SecurityProfileSearchSummary
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class SearchSecurityProfilesOperationDeserializer: HttpDeserialize<SearchSecurityProfilesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): SearchSecurityProfilesResponse {
        if (!response.status.isSuccess()) {
            throwSearchSecurityProfilesError(context, response)
        }
        val builder = SearchSecurityProfilesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeSearchSecurityProfilesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwSearchSecurityProfilesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ConnectException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServiceException" -> InternalServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ConnectException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeSearchSecurityProfilesOperationBody(builder: SearchSecurityProfilesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APPROXIMATETOTALCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("ApproximateTotalCount"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val SECURITYPROFILES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("SecurityProfiles"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPROXIMATETOTALCOUNT_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(SECURITYPROFILES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APPROXIMATETOTALCOUNT_DESCRIPTOR.index -> builder.approximateTotalCount = deserializeLong()
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                SECURITYPROFILES_DESCRIPTOR.index -> builder.securityProfiles =
                    deserializer.deserializeList(SECURITYPROFILES_DESCRIPTOR) {
                        val col0 = mutableListOf<SecurityProfileSearchSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeSecurityProfileSearchSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
