// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.transform

import aws.sdk.kotlin.services.connect.model.ConnectException
import aws.sdk.kotlin.services.connect.model.DescribeQuickConnectResponse
import aws.sdk.kotlin.services.connect.model.QuickConnect
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeQuickConnectOperationDeserializer: HttpDeserialize<DescribeQuickConnectResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeQuickConnectResponse {
        if (!response.status.isSuccess()) {
            throwDescribeQuickConnectError(context, response)
        }
        val builder = DescribeQuickConnectResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeQuickConnectOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeQuickConnectError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ConnectException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServiceException" -> InternalServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ConnectException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeQuickConnectOperationBody(builder: DescribeQuickConnectResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val QUICKCONNECT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("QuickConnect"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(QUICKCONNECT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                QUICKCONNECT_DESCRIPTOR.index -> builder.quickConnect = deserializeQuickConnectDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
