// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.transform

import aws.sdk.kotlin.services.connect.model.ConnectException
import aws.sdk.kotlin.services.connect.model.CreateUseCaseResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateUseCaseOperationDeserializer: HttpDeserialize<CreateUseCaseResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateUseCaseResponse {
        if (!response.status.isSuccess()) {
            throwCreateUseCaseError(context, response)
        }
        val builder = CreateUseCaseResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateUseCaseOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateUseCaseError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ConnectException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DuplicateResourceException" -> DuplicateResourceExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServiceException" -> InternalServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ConnectException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateUseCaseOperationBody(builder: CreateUseCaseResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val USECASEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("UseCaseArn"))
    val USECASEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("UseCaseId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(USECASEARN_DESCRIPTOR)
        field(USECASEID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                USECASEARN_DESCRIPTOR.index -> builder.useCaseArn = deserializeString()
                USECASEID_DESCRIPTOR.index -> builder.useCaseId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
