// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.transform

import aws.sdk.kotlin.services.connect.model.CreateRuleRequest
import aws.sdk.kotlin.services.connect.model.RuleAction
import aws.sdk.kotlin.services.connect.model.RulePublishStatus
import aws.sdk.kotlin.services.connect.model.RuleTriggerEventSource
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateRuleOperationSerializer: HttpSerialize<CreateRuleRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateRuleRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf<String>(
                "rules",
                "${input.instanceId}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeCreateRuleOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateRuleOperationBody(context: ExecutionContext, input: CreateRuleRequest): ByteArray {
    val serializer = JsonSerializer()
    val ACTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Actions"))
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ClientToken"))
    val FUNCTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Function"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val PUBLISHSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("PublishStatus"))
    val TRIGGEREVENTSOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("TriggerEventSource"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACTIONS_DESCRIPTOR)
        field(CLIENTTOKEN_DESCRIPTOR)
        field(FUNCTION_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(PUBLISHSTATUS_DESCRIPTOR)
        field(TRIGGEREVENTSOURCE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.actions != null) {
            listField(ACTIONS_DESCRIPTOR) {
                for (el0 in input.actions) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeRuleActionDocument))
                }
            }
        }
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.function?.let { field(FUNCTION_DESCRIPTOR, it) }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        input.publishStatus?.let { field(PUBLISHSTATUS_DESCRIPTOR, it.value) }
        input.triggerEventSource?.let { field(TRIGGEREVENTSOURCE_DESCRIPTOR, it, ::serializeRuleTriggerEventSourceDocument) }
    }
    return serializer.toByteArray()
}
