// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.transform

import aws.sdk.kotlin.services.connect.model.ConnectException
import aws.sdk.kotlin.services.connect.model.CreateQuickConnectResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateQuickConnectOperationDeserializer: HttpDeserialize<CreateQuickConnectResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateQuickConnectResponse {
        if (!response.status.isSuccess()) {
            throwCreateQuickConnectError(context, response)
        }
        val builder = CreateQuickConnectResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateQuickConnectOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateQuickConnectError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ConnectException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DuplicateResourceException" -> DuplicateResourceExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServiceException" -> InternalServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ConnectException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateQuickConnectOperationBody(builder: CreateQuickConnectResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val QUICKCONNECTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("QuickConnectARN"))
    val QUICKCONNECTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("QuickConnectId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(QUICKCONNECTARN_DESCRIPTOR)
        field(QUICKCONNECTID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                QUICKCONNECTARN_DESCRIPTOR.index -> builder.quickConnectArn = deserializeString()
                QUICKCONNECTID_DESCRIPTOR.index -> builder.quickConnectId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
