// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.paginators

import aws.sdk.kotlin.services.connect.ConnectClient
import aws.sdk.kotlin.services.connect.model.AgentStatusSummary
import aws.sdk.kotlin.services.connect.model.Attribute
import aws.sdk.kotlin.services.connect.model.AvailableNumberSummary
import aws.sdk.kotlin.services.connect.model.ContactFlowModuleSummary
import aws.sdk.kotlin.services.connect.model.ContactFlowSummary
import aws.sdk.kotlin.services.connect.model.DefaultVocabulary
import aws.sdk.kotlin.services.connect.model.GetCurrentMetricDataRequest
import aws.sdk.kotlin.services.connect.model.GetCurrentMetricDataResponse
import aws.sdk.kotlin.services.connect.model.GetCurrentUserDataRequest
import aws.sdk.kotlin.services.connect.model.GetCurrentUserDataResponse
import aws.sdk.kotlin.services.connect.model.GetMetricDataRequest
import aws.sdk.kotlin.services.connect.model.GetMetricDataResponse
import aws.sdk.kotlin.services.connect.model.GetMetricDataV2Request
import aws.sdk.kotlin.services.connect.model.GetMetricDataV2Response
import aws.sdk.kotlin.services.connect.model.HierarchyGroupSummary
import aws.sdk.kotlin.services.connect.model.HoursOfOperationSummary
import aws.sdk.kotlin.services.connect.model.InstanceStorageConfig
import aws.sdk.kotlin.services.connect.model.InstanceSummary
import aws.sdk.kotlin.services.connect.model.IntegrationAssociationSummary
import aws.sdk.kotlin.services.connect.model.LexBot
import aws.sdk.kotlin.services.connect.model.LexBotConfig
import aws.sdk.kotlin.services.connect.model.ListAgentStatusesRequest
import aws.sdk.kotlin.services.connect.model.ListAgentStatusesResponse
import aws.sdk.kotlin.services.connect.model.ListApprovedOriginsRequest
import aws.sdk.kotlin.services.connect.model.ListApprovedOriginsResponse
import aws.sdk.kotlin.services.connect.model.ListBotsRequest
import aws.sdk.kotlin.services.connect.model.ListBotsResponse
import aws.sdk.kotlin.services.connect.model.ListContactFlowModulesRequest
import aws.sdk.kotlin.services.connect.model.ListContactFlowModulesResponse
import aws.sdk.kotlin.services.connect.model.ListContactFlowsRequest
import aws.sdk.kotlin.services.connect.model.ListContactFlowsResponse
import aws.sdk.kotlin.services.connect.model.ListContactReferencesRequest
import aws.sdk.kotlin.services.connect.model.ListContactReferencesResponse
import aws.sdk.kotlin.services.connect.model.ListDefaultVocabulariesRequest
import aws.sdk.kotlin.services.connect.model.ListDefaultVocabulariesResponse
import aws.sdk.kotlin.services.connect.model.ListHoursOfOperationsRequest
import aws.sdk.kotlin.services.connect.model.ListHoursOfOperationsResponse
import aws.sdk.kotlin.services.connect.model.ListInstanceAttributesRequest
import aws.sdk.kotlin.services.connect.model.ListInstanceAttributesResponse
import aws.sdk.kotlin.services.connect.model.ListInstanceStorageConfigsRequest
import aws.sdk.kotlin.services.connect.model.ListInstanceStorageConfigsResponse
import aws.sdk.kotlin.services.connect.model.ListInstancesRequest
import aws.sdk.kotlin.services.connect.model.ListInstancesResponse
import aws.sdk.kotlin.services.connect.model.ListIntegrationAssociationsRequest
import aws.sdk.kotlin.services.connect.model.ListIntegrationAssociationsResponse
import aws.sdk.kotlin.services.connect.model.ListLambdaFunctionsRequest
import aws.sdk.kotlin.services.connect.model.ListLambdaFunctionsResponse
import aws.sdk.kotlin.services.connect.model.ListLexBotsRequest
import aws.sdk.kotlin.services.connect.model.ListLexBotsResponse
import aws.sdk.kotlin.services.connect.model.ListPhoneNumbersRequest
import aws.sdk.kotlin.services.connect.model.ListPhoneNumbersResponse
import aws.sdk.kotlin.services.connect.model.ListPhoneNumbersSummary
import aws.sdk.kotlin.services.connect.model.ListPhoneNumbersV2Request
import aws.sdk.kotlin.services.connect.model.ListPhoneNumbersV2Response
import aws.sdk.kotlin.services.connect.model.ListPromptsRequest
import aws.sdk.kotlin.services.connect.model.ListPromptsResponse
import aws.sdk.kotlin.services.connect.model.ListQueueQuickConnectsRequest
import aws.sdk.kotlin.services.connect.model.ListQueueQuickConnectsResponse
import aws.sdk.kotlin.services.connect.model.ListQueuesRequest
import aws.sdk.kotlin.services.connect.model.ListQueuesResponse
import aws.sdk.kotlin.services.connect.model.ListQuickConnectsRequest
import aws.sdk.kotlin.services.connect.model.ListQuickConnectsResponse
import aws.sdk.kotlin.services.connect.model.ListRoutingProfileQueuesRequest
import aws.sdk.kotlin.services.connect.model.ListRoutingProfileQueuesResponse
import aws.sdk.kotlin.services.connect.model.ListRoutingProfilesRequest
import aws.sdk.kotlin.services.connect.model.ListRoutingProfilesResponse
import aws.sdk.kotlin.services.connect.model.ListRulesRequest
import aws.sdk.kotlin.services.connect.model.ListRulesResponse
import aws.sdk.kotlin.services.connect.model.ListSecurityKeysRequest
import aws.sdk.kotlin.services.connect.model.ListSecurityKeysResponse
import aws.sdk.kotlin.services.connect.model.ListSecurityProfilePermissionsRequest
import aws.sdk.kotlin.services.connect.model.ListSecurityProfilePermissionsResponse
import aws.sdk.kotlin.services.connect.model.ListSecurityProfilesRequest
import aws.sdk.kotlin.services.connect.model.ListSecurityProfilesResponse
import aws.sdk.kotlin.services.connect.model.ListTaskTemplatesRequest
import aws.sdk.kotlin.services.connect.model.ListTaskTemplatesResponse
import aws.sdk.kotlin.services.connect.model.ListTrafficDistributionGroupsRequest
import aws.sdk.kotlin.services.connect.model.ListTrafficDistributionGroupsResponse
import aws.sdk.kotlin.services.connect.model.ListUseCasesRequest
import aws.sdk.kotlin.services.connect.model.ListUseCasesResponse
import aws.sdk.kotlin.services.connect.model.ListUserHierarchyGroupsRequest
import aws.sdk.kotlin.services.connect.model.ListUserHierarchyGroupsResponse
import aws.sdk.kotlin.services.connect.model.ListUsersRequest
import aws.sdk.kotlin.services.connect.model.ListUsersResponse
import aws.sdk.kotlin.services.connect.model.PhoneNumberSummary
import aws.sdk.kotlin.services.connect.model.PromptSummary
import aws.sdk.kotlin.services.connect.model.Queue
import aws.sdk.kotlin.services.connect.model.QueueSummary
import aws.sdk.kotlin.services.connect.model.QuickConnectSummary
import aws.sdk.kotlin.services.connect.model.ReferenceSummary
import aws.sdk.kotlin.services.connect.model.RoutingProfile
import aws.sdk.kotlin.services.connect.model.RoutingProfileQueueConfigSummary
import aws.sdk.kotlin.services.connect.model.RoutingProfileSummary
import aws.sdk.kotlin.services.connect.model.RuleSummary
import aws.sdk.kotlin.services.connect.model.SearchAvailablePhoneNumbersRequest
import aws.sdk.kotlin.services.connect.model.SearchAvailablePhoneNumbersResponse
import aws.sdk.kotlin.services.connect.model.SearchQueuesRequest
import aws.sdk.kotlin.services.connect.model.SearchQueuesResponse
import aws.sdk.kotlin.services.connect.model.SearchRoutingProfilesRequest
import aws.sdk.kotlin.services.connect.model.SearchRoutingProfilesResponse
import aws.sdk.kotlin.services.connect.model.SearchSecurityProfilesRequest
import aws.sdk.kotlin.services.connect.model.SearchSecurityProfilesResponse
import aws.sdk.kotlin.services.connect.model.SearchUsersRequest
import aws.sdk.kotlin.services.connect.model.SearchUsersResponse
import aws.sdk.kotlin.services.connect.model.SearchVocabulariesRequest
import aws.sdk.kotlin.services.connect.model.SearchVocabulariesResponse
import aws.sdk.kotlin.services.connect.model.SecurityKey
import aws.sdk.kotlin.services.connect.model.SecurityProfileSearchSummary
import aws.sdk.kotlin.services.connect.model.SecurityProfileSummary
import aws.sdk.kotlin.services.connect.model.TaskTemplateMetadata
import aws.sdk.kotlin.services.connect.model.TrafficDistributionGroupSummary
import aws.sdk.kotlin.services.connect.model.UseCase
import aws.sdk.kotlin.services.connect.model.UserSearchSummary
import aws.sdk.kotlin.services.connect.model.UserSummary
import aws.sdk.kotlin.services.connect.model.VocabularySummary
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [GetCurrentMetricDataResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetCurrentMetricDataRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetCurrentMetricDataResponse]
 */
public fun ConnectClient.getCurrentMetricDataPaginated(initialRequest: GetCurrentMetricDataRequest): Flow<GetCurrentMetricDataResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getCurrentMetricDataPaginated.getCurrentMetricData(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [GetCurrentMetricDataResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetCurrentMetricDataResponse]
 */
public fun ConnectClient.getCurrentMetricDataPaginated(block: GetCurrentMetricDataRequest.Builder.() -> Unit): Flow<GetCurrentMetricDataResponse> =
    getCurrentMetricDataPaginated(GetCurrentMetricDataRequest.Builder().apply(block).build())

/**
 * Paginate over [GetCurrentUserDataResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetCurrentUserDataRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetCurrentUserDataResponse]
 */
public fun ConnectClient.getCurrentUserDataPaginated(initialRequest: GetCurrentUserDataRequest): Flow<GetCurrentUserDataResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getCurrentUserDataPaginated.getCurrentUserData(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [GetCurrentUserDataResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetCurrentUserDataResponse]
 */
public fun ConnectClient.getCurrentUserDataPaginated(block: GetCurrentUserDataRequest.Builder.() -> Unit): Flow<GetCurrentUserDataResponse> =
    getCurrentUserDataPaginated(GetCurrentUserDataRequest.Builder().apply(block).build())

/**
 * Paginate over [GetMetricDataResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetMetricDataRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetMetricDataResponse]
 */
public fun ConnectClient.getMetricDataPaginated(initialRequest: GetMetricDataRequest): Flow<GetMetricDataResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getMetricDataPaginated.getMetricData(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [GetMetricDataResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetMetricDataResponse]
 */
public fun ConnectClient.getMetricDataPaginated(block: GetMetricDataRequest.Builder.() -> Unit): Flow<GetMetricDataResponse> =
    getMetricDataPaginated(GetMetricDataRequest.Builder().apply(block).build())

/**
 * Paginate over [GetMetricDataV2Response] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetMetricDataV2Request] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetMetricDataV2Response]
 */
public fun ConnectClient.getMetricDataV2Paginated(initialRequest: GetMetricDataV2Request): Flow<GetMetricDataV2Response> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getMetricDataV2Paginated.getMetricDataV2(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [GetMetricDataV2Response] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetMetricDataV2Response]
 */
public fun ConnectClient.getMetricDataV2Paginated(block: GetMetricDataV2Request.Builder.() -> Unit): Flow<GetMetricDataV2Response> =
    getMetricDataV2Paginated(GetMetricDataV2Request.Builder().apply(block).build())

/**
 * Paginate over [ListAgentStatusesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAgentStatusesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAgentStatusesResponse]
 */
public fun ConnectClient.listAgentStatusesPaginated(initialRequest: ListAgentStatusesRequest): Flow<ListAgentStatusesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAgentStatusesPaginated.listAgentStatuses(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListAgentStatusesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAgentStatusesResponse]
 */
public fun ConnectClient.listAgentStatusesPaginated(block: ListAgentStatusesRequest.Builder.() -> Unit): Flow<ListAgentStatusesResponse> =
    listAgentStatusesPaginated(ListAgentStatusesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAgentStatusesPaginated]
 * to access the nested member [AgentStatusSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AgentStatusSummary]
 */
@JvmName("listAgentStatusesResponseAgentStatusSummary")
public fun Flow<ListAgentStatusesResponse>.agentStatusSummaryList(): Flow<AgentStatusSummary> =
    transform() { response ->
        response.agentStatusSummaryList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListApprovedOriginsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListApprovedOriginsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListApprovedOriginsResponse]
 */
public fun ConnectClient.listApprovedOriginsPaginated(initialRequest: ListApprovedOriginsRequest): Flow<ListApprovedOriginsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listApprovedOriginsPaginated.listApprovedOrigins(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListApprovedOriginsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListApprovedOriginsResponse]
 */
public fun ConnectClient.listApprovedOriginsPaginated(block: ListApprovedOriginsRequest.Builder.() -> Unit): Flow<ListApprovedOriginsResponse> =
    listApprovedOriginsPaginated(ListApprovedOriginsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listApprovedOriginsPaginated]
 * to access the nested member [Origin]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Origin]
 */
@JvmName("listApprovedOriginsResponseOrigin")
public fun Flow<ListApprovedOriginsResponse>.origins(): Flow<String> =
    transform() { response ->
        response.origins?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListBotsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListBotsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBotsResponse]
 */
public fun ConnectClient.listBotsPaginated(initialRequest: ListBotsRequest): Flow<ListBotsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listBotsPaginated.listBots(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListBotsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBotsResponse]
 */
public fun ConnectClient.listBotsPaginated(block: ListBotsRequest.Builder.() -> Unit): Flow<ListBotsResponse> =
    listBotsPaginated(ListBotsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listBotsPaginated]
 * to access the nested member [LexBotConfig]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [LexBotConfig]
 */
@JvmName("listBotsResponseLexBotConfig")
public fun Flow<ListBotsResponse>.lexBots(): Flow<LexBotConfig> =
    transform() { response ->
        response.lexBots?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListContactFlowModulesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListContactFlowModulesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListContactFlowModulesResponse]
 */
public fun ConnectClient.listContactFlowModulesPaginated(initialRequest: ListContactFlowModulesRequest): Flow<ListContactFlowModulesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listContactFlowModulesPaginated.listContactFlowModules(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListContactFlowModulesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListContactFlowModulesResponse]
 */
public fun ConnectClient.listContactFlowModulesPaginated(block: ListContactFlowModulesRequest.Builder.() -> Unit): Flow<ListContactFlowModulesResponse> =
    listContactFlowModulesPaginated(ListContactFlowModulesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listContactFlowModulesPaginated]
 * to access the nested member [ContactFlowModuleSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ContactFlowModuleSummary]
 */
@JvmName("listContactFlowModulesResponseContactFlowModuleSummary")
public fun Flow<ListContactFlowModulesResponse>.contactFlowModulesSummaryList(): Flow<ContactFlowModuleSummary> =
    transform() { response ->
        response.contactFlowModulesSummaryList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListContactFlowsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListContactFlowsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListContactFlowsResponse]
 */
public fun ConnectClient.listContactFlowsPaginated(initialRequest: ListContactFlowsRequest): Flow<ListContactFlowsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listContactFlowsPaginated.listContactFlows(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListContactFlowsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListContactFlowsResponse]
 */
public fun ConnectClient.listContactFlowsPaginated(block: ListContactFlowsRequest.Builder.() -> Unit): Flow<ListContactFlowsResponse> =
    listContactFlowsPaginated(ListContactFlowsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listContactFlowsPaginated]
 * to access the nested member [ContactFlowSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ContactFlowSummary]
 */
@JvmName("listContactFlowsResponseContactFlowSummary")
public fun Flow<ListContactFlowsResponse>.contactFlowSummaryList(): Flow<ContactFlowSummary> =
    transform() { response ->
        response.contactFlowSummaryList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListContactReferencesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListContactReferencesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListContactReferencesResponse]
 */
public fun ConnectClient.listContactReferencesPaginated(initialRequest: ListContactReferencesRequest): Flow<ListContactReferencesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listContactReferencesPaginated.listContactReferences(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListContactReferencesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListContactReferencesResponse]
 */
public fun ConnectClient.listContactReferencesPaginated(block: ListContactReferencesRequest.Builder.() -> Unit): Flow<ListContactReferencesResponse> =
    listContactReferencesPaginated(ListContactReferencesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listContactReferencesPaginated]
 * to access the nested member [ReferenceSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ReferenceSummary]
 */
@JvmName("listContactReferencesResponseReferenceSummary")
public fun Flow<ListContactReferencesResponse>.referenceSummaryList(): Flow<ReferenceSummary> =
    transform() { response ->
        response.referenceSummaryList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDefaultVocabulariesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDefaultVocabulariesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDefaultVocabulariesResponse]
 */
public fun ConnectClient.listDefaultVocabulariesPaginated(initialRequest: ListDefaultVocabulariesRequest): Flow<ListDefaultVocabulariesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDefaultVocabulariesPaginated.listDefaultVocabularies(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListDefaultVocabulariesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDefaultVocabulariesResponse]
 */
public fun ConnectClient.listDefaultVocabulariesPaginated(block: ListDefaultVocabulariesRequest.Builder.() -> Unit): Flow<ListDefaultVocabulariesResponse> =
    listDefaultVocabulariesPaginated(ListDefaultVocabulariesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDefaultVocabulariesPaginated]
 * to access the nested member [DefaultVocabulary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DefaultVocabulary]
 */
@JvmName("listDefaultVocabulariesResponseDefaultVocabulary")
public fun Flow<ListDefaultVocabulariesResponse>.defaultVocabularyList(): Flow<DefaultVocabulary> =
    transform() { response ->
        response.defaultVocabularyList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListHoursOfOperationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListHoursOfOperationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListHoursOfOperationsResponse]
 */
public fun ConnectClient.listHoursOfOperationsPaginated(initialRequest: ListHoursOfOperationsRequest): Flow<ListHoursOfOperationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listHoursOfOperationsPaginated.listHoursOfOperations(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListHoursOfOperationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListHoursOfOperationsResponse]
 */
public fun ConnectClient.listHoursOfOperationsPaginated(block: ListHoursOfOperationsRequest.Builder.() -> Unit): Flow<ListHoursOfOperationsResponse> =
    listHoursOfOperationsPaginated(ListHoursOfOperationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listHoursOfOperationsPaginated]
 * to access the nested member [HoursOfOperationSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [HoursOfOperationSummary]
 */
@JvmName("listHoursOfOperationsResponseHoursOfOperationSummary")
public fun Flow<ListHoursOfOperationsResponse>.hoursOfOperationSummaryList(): Flow<HoursOfOperationSummary> =
    transform() { response ->
        response.hoursOfOperationSummaryList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListInstanceAttributesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListInstanceAttributesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListInstanceAttributesResponse]
 */
public fun ConnectClient.listInstanceAttributesPaginated(initialRequest: ListInstanceAttributesRequest): Flow<ListInstanceAttributesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listInstanceAttributesPaginated.listInstanceAttributes(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListInstanceAttributesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListInstanceAttributesResponse]
 */
public fun ConnectClient.listInstanceAttributesPaginated(block: ListInstanceAttributesRequest.Builder.() -> Unit): Flow<ListInstanceAttributesResponse> =
    listInstanceAttributesPaginated(ListInstanceAttributesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listInstanceAttributesPaginated]
 * to access the nested member [Attribute]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Attribute]
 */
@JvmName("listInstanceAttributesResponseAttribute")
public fun Flow<ListInstanceAttributesResponse>.attributes(): Flow<Attribute> =
    transform() { response ->
        response.attributes?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListInstancesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListInstancesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListInstancesResponse]
 */
public fun ConnectClient.listInstancesPaginated(initialRequest: ListInstancesRequest): Flow<ListInstancesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listInstancesPaginated.listInstances(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListInstancesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListInstancesResponse]
 */
public fun ConnectClient.listInstancesPaginated(block: ListInstancesRequest.Builder.() -> Unit): Flow<ListInstancesResponse> =
    listInstancesPaginated(ListInstancesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listInstancesPaginated]
 * to access the nested member [InstanceSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [InstanceSummary]
 */
@JvmName("listInstancesResponseInstanceSummary")
public fun Flow<ListInstancesResponse>.instanceSummaryList(): Flow<InstanceSummary> =
    transform() { response ->
        response.instanceSummaryList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListInstanceStorageConfigsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListInstanceStorageConfigsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListInstanceStorageConfigsResponse]
 */
public fun ConnectClient.listInstanceStorageConfigsPaginated(initialRequest: ListInstanceStorageConfigsRequest): Flow<ListInstanceStorageConfigsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listInstanceStorageConfigsPaginated.listInstanceStorageConfigs(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListInstanceStorageConfigsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListInstanceStorageConfigsResponse]
 */
public fun ConnectClient.listInstanceStorageConfigsPaginated(block: ListInstanceStorageConfigsRequest.Builder.() -> Unit): Flow<ListInstanceStorageConfigsResponse> =
    listInstanceStorageConfigsPaginated(ListInstanceStorageConfigsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listInstanceStorageConfigsPaginated]
 * to access the nested member [InstanceStorageConfig]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [InstanceStorageConfig]
 */
@JvmName("listInstanceStorageConfigsResponseInstanceStorageConfig")
public fun Flow<ListInstanceStorageConfigsResponse>.storageConfigs(): Flow<InstanceStorageConfig> =
    transform() { response ->
        response.storageConfigs?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListIntegrationAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListIntegrationAssociationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListIntegrationAssociationsResponse]
 */
public fun ConnectClient.listIntegrationAssociationsPaginated(initialRequest: ListIntegrationAssociationsRequest): Flow<ListIntegrationAssociationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listIntegrationAssociationsPaginated.listIntegrationAssociations(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListIntegrationAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListIntegrationAssociationsResponse]
 */
public fun ConnectClient.listIntegrationAssociationsPaginated(block: ListIntegrationAssociationsRequest.Builder.() -> Unit): Flow<ListIntegrationAssociationsResponse> =
    listIntegrationAssociationsPaginated(ListIntegrationAssociationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listIntegrationAssociationsPaginated]
 * to access the nested member [IntegrationAssociationSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [IntegrationAssociationSummary]
 */
@JvmName("listIntegrationAssociationsResponseIntegrationAssociationSummary")
public fun Flow<ListIntegrationAssociationsResponse>.integrationAssociationSummaryList(): Flow<IntegrationAssociationSummary> =
    transform() { response ->
        response.integrationAssociationSummaryList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListLambdaFunctionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListLambdaFunctionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLambdaFunctionsResponse]
 */
public fun ConnectClient.listLambdaFunctionsPaginated(initialRequest: ListLambdaFunctionsRequest): Flow<ListLambdaFunctionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listLambdaFunctionsPaginated.listLambdaFunctions(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListLambdaFunctionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLambdaFunctionsResponse]
 */
public fun ConnectClient.listLambdaFunctionsPaginated(block: ListLambdaFunctionsRequest.Builder.() -> Unit): Flow<ListLambdaFunctionsResponse> =
    listLambdaFunctionsPaginated(ListLambdaFunctionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listLambdaFunctionsPaginated]
 * to access the nested member [FunctionArn]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [FunctionArn]
 */
@JvmName("listLambdaFunctionsResponseFunctionArn")
public fun Flow<ListLambdaFunctionsResponse>.lambdaFunctions(): Flow<String> =
    transform() { response ->
        response.lambdaFunctions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListLexBotsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListLexBotsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLexBotsResponse]
 */
public fun ConnectClient.listLexBotsPaginated(initialRequest: ListLexBotsRequest): Flow<ListLexBotsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listLexBotsPaginated.listLexBots(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListLexBotsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLexBotsResponse]
 */
public fun ConnectClient.listLexBotsPaginated(block: ListLexBotsRequest.Builder.() -> Unit): Flow<ListLexBotsResponse> =
    listLexBotsPaginated(ListLexBotsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listLexBotsPaginated]
 * to access the nested member [LexBot]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [LexBot]
 */
@JvmName("listLexBotsResponseLexBot")
public fun Flow<ListLexBotsResponse>.lexBots(): Flow<LexBot> =
    transform() { response ->
        response.lexBots?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListPhoneNumbersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPhoneNumbersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPhoneNumbersResponse]
 */
public fun ConnectClient.listPhoneNumbersPaginated(initialRequest: ListPhoneNumbersRequest): Flow<ListPhoneNumbersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPhoneNumbersPaginated.listPhoneNumbers(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListPhoneNumbersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPhoneNumbersResponse]
 */
public fun ConnectClient.listPhoneNumbersPaginated(block: ListPhoneNumbersRequest.Builder.() -> Unit): Flow<ListPhoneNumbersResponse> =
    listPhoneNumbersPaginated(ListPhoneNumbersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listPhoneNumbersPaginated]
 * to access the nested member [PhoneNumberSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PhoneNumberSummary]
 */
@JvmName("listPhoneNumbersResponsePhoneNumberSummary")
public fun Flow<ListPhoneNumbersResponse>.phoneNumberSummaryList(): Flow<PhoneNumberSummary> =
    transform() { response ->
        response.phoneNumberSummaryList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListPhoneNumbersV2Response] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPhoneNumbersV2Request] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPhoneNumbersV2Response]
 */
public fun ConnectClient.listPhoneNumbersV2Paginated(initialRequest: ListPhoneNumbersV2Request): Flow<ListPhoneNumbersV2Response> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPhoneNumbersV2Paginated.listPhoneNumbersV2(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListPhoneNumbersV2Response] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPhoneNumbersV2Response]
 */
public fun ConnectClient.listPhoneNumbersV2Paginated(block: ListPhoneNumbersV2Request.Builder.() -> Unit): Flow<ListPhoneNumbersV2Response> =
    listPhoneNumbersV2Paginated(ListPhoneNumbersV2Request.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listPhoneNumbersV2Paginated]
 * to access the nested member [ListPhoneNumbersSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPhoneNumbersSummary]
 */
@JvmName("listPhoneNumbersV2ResponseListPhoneNumbersSummary")
public fun Flow<ListPhoneNumbersV2Response>.listPhoneNumbersSummaryList(): Flow<ListPhoneNumbersSummary> =
    transform() { response ->
        response.listPhoneNumbersSummaryList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListPromptsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPromptsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPromptsResponse]
 */
public fun ConnectClient.listPromptsPaginated(initialRequest: ListPromptsRequest): Flow<ListPromptsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPromptsPaginated.listPrompts(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListPromptsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPromptsResponse]
 */
public fun ConnectClient.listPromptsPaginated(block: ListPromptsRequest.Builder.() -> Unit): Flow<ListPromptsResponse> =
    listPromptsPaginated(ListPromptsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listPromptsPaginated]
 * to access the nested member [PromptSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PromptSummary]
 */
@JvmName("listPromptsResponsePromptSummary")
public fun Flow<ListPromptsResponse>.promptSummaryList(): Flow<PromptSummary> =
    transform() { response ->
        response.promptSummaryList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListQueueQuickConnectsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListQueueQuickConnectsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListQueueQuickConnectsResponse]
 */
public fun ConnectClient.listQueueQuickConnectsPaginated(initialRequest: ListQueueQuickConnectsRequest): Flow<ListQueueQuickConnectsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listQueueQuickConnectsPaginated.listQueueQuickConnects(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListQueueQuickConnectsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListQueueQuickConnectsResponse]
 */
public fun ConnectClient.listQueueQuickConnectsPaginated(block: ListQueueQuickConnectsRequest.Builder.() -> Unit): Flow<ListQueueQuickConnectsResponse> =
    listQueueQuickConnectsPaginated(ListQueueQuickConnectsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listQueueQuickConnectsPaginated]
 * to access the nested member [QuickConnectSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [QuickConnectSummary]
 */
@JvmName("listQueueQuickConnectsResponseQuickConnectSummary")
public fun Flow<ListQueueQuickConnectsResponse>.quickConnectSummaryList(): Flow<QuickConnectSummary> =
    transform() { response ->
        response.quickConnectSummaryList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListQueuesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListQueuesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListQueuesResponse]
 */
public fun ConnectClient.listQueuesPaginated(initialRequest: ListQueuesRequest): Flow<ListQueuesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listQueuesPaginated.listQueues(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListQueuesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListQueuesResponse]
 */
public fun ConnectClient.listQueuesPaginated(block: ListQueuesRequest.Builder.() -> Unit): Flow<ListQueuesResponse> =
    listQueuesPaginated(ListQueuesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listQueuesPaginated]
 * to access the nested member [QueueSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [QueueSummary]
 */
@JvmName("listQueuesResponseQueueSummary")
public fun Flow<ListQueuesResponse>.queueSummaryList(): Flow<QueueSummary> =
    transform() { response ->
        response.queueSummaryList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListQuickConnectsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListQuickConnectsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListQuickConnectsResponse]
 */
public fun ConnectClient.listQuickConnectsPaginated(initialRequest: ListQuickConnectsRequest): Flow<ListQuickConnectsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listQuickConnectsPaginated.listQuickConnects(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListQuickConnectsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListQuickConnectsResponse]
 */
public fun ConnectClient.listQuickConnectsPaginated(block: ListQuickConnectsRequest.Builder.() -> Unit): Flow<ListQuickConnectsResponse> =
    listQuickConnectsPaginated(ListQuickConnectsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listQuickConnectsPaginated]
 * to access the nested member [QuickConnectSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [QuickConnectSummary]
 */
@JvmName("listQuickConnectsResponseQuickConnectSummary")
public fun Flow<ListQuickConnectsResponse>.quickConnectSummaryList(): Flow<QuickConnectSummary> =
    transform() { response ->
        response.quickConnectSummaryList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListRoutingProfileQueuesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRoutingProfileQueuesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRoutingProfileQueuesResponse]
 */
public fun ConnectClient.listRoutingProfileQueuesPaginated(initialRequest: ListRoutingProfileQueuesRequest): Flow<ListRoutingProfileQueuesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRoutingProfileQueuesPaginated.listRoutingProfileQueues(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListRoutingProfileQueuesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRoutingProfileQueuesResponse]
 */
public fun ConnectClient.listRoutingProfileQueuesPaginated(block: ListRoutingProfileQueuesRequest.Builder.() -> Unit): Flow<ListRoutingProfileQueuesResponse> =
    listRoutingProfileQueuesPaginated(ListRoutingProfileQueuesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listRoutingProfileQueuesPaginated]
 * to access the nested member [RoutingProfileQueueConfigSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [RoutingProfileQueueConfigSummary]
 */
@JvmName("listRoutingProfileQueuesResponseRoutingProfileQueueConfigSummary")
public fun Flow<ListRoutingProfileQueuesResponse>.routingProfileQueueConfigSummaryList(): Flow<RoutingProfileQueueConfigSummary> =
    transform() { response ->
        response.routingProfileQueueConfigSummaryList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListRoutingProfilesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRoutingProfilesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRoutingProfilesResponse]
 */
public fun ConnectClient.listRoutingProfilesPaginated(initialRequest: ListRoutingProfilesRequest): Flow<ListRoutingProfilesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRoutingProfilesPaginated.listRoutingProfiles(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListRoutingProfilesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRoutingProfilesResponse]
 */
public fun ConnectClient.listRoutingProfilesPaginated(block: ListRoutingProfilesRequest.Builder.() -> Unit): Flow<ListRoutingProfilesResponse> =
    listRoutingProfilesPaginated(ListRoutingProfilesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listRoutingProfilesPaginated]
 * to access the nested member [RoutingProfileSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [RoutingProfileSummary]
 */
@JvmName("listRoutingProfilesResponseRoutingProfileSummary")
public fun Flow<ListRoutingProfilesResponse>.routingProfileSummaryList(): Flow<RoutingProfileSummary> =
    transform() { response ->
        response.routingProfileSummaryList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListRulesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRulesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRulesResponse]
 */
public fun ConnectClient.listRulesPaginated(initialRequest: ListRulesRequest): Flow<ListRulesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRulesPaginated.listRules(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListRulesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRulesResponse]
 */
public fun ConnectClient.listRulesPaginated(block: ListRulesRequest.Builder.() -> Unit): Flow<ListRulesResponse> =
    listRulesPaginated(ListRulesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listRulesPaginated]
 * to access the nested member [RuleSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [RuleSummary]
 */
@JvmName("listRulesResponseRuleSummary")
public fun Flow<ListRulesResponse>.ruleSummaryList(): Flow<RuleSummary> =
    transform() { response ->
        response.ruleSummaryList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListSecurityKeysResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSecurityKeysRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSecurityKeysResponse]
 */
public fun ConnectClient.listSecurityKeysPaginated(initialRequest: ListSecurityKeysRequest): Flow<ListSecurityKeysResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSecurityKeysPaginated.listSecurityKeys(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListSecurityKeysResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSecurityKeysResponse]
 */
public fun ConnectClient.listSecurityKeysPaginated(block: ListSecurityKeysRequest.Builder.() -> Unit): Flow<ListSecurityKeysResponse> =
    listSecurityKeysPaginated(ListSecurityKeysRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listSecurityKeysPaginated]
 * to access the nested member [SecurityKey]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SecurityKey]
 */
@JvmName("listSecurityKeysResponseSecurityKey")
public fun Flow<ListSecurityKeysResponse>.securityKeys(): Flow<SecurityKey> =
    transform() { response ->
        response.securityKeys?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListSecurityProfilePermissionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSecurityProfilePermissionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSecurityProfilePermissionsResponse]
 */
public fun ConnectClient.listSecurityProfilePermissionsPaginated(initialRequest: ListSecurityProfilePermissionsRequest): Flow<ListSecurityProfilePermissionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSecurityProfilePermissionsPaginated.listSecurityProfilePermissions(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListSecurityProfilePermissionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSecurityProfilePermissionsResponse]
 */
public fun ConnectClient.listSecurityProfilePermissionsPaginated(block: ListSecurityProfilePermissionsRequest.Builder.() -> Unit): Flow<ListSecurityProfilePermissionsResponse> =
    listSecurityProfilePermissionsPaginated(ListSecurityProfilePermissionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listSecurityProfilePermissionsPaginated]
 * to access the nested member [SecurityProfilePermission]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SecurityProfilePermission]
 */
@JvmName("listSecurityProfilePermissionsResponseSecurityProfilePermission")
public fun Flow<ListSecurityProfilePermissionsResponse>.permissions(): Flow<String> =
    transform() { response ->
        response.permissions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListSecurityProfilesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSecurityProfilesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSecurityProfilesResponse]
 */
public fun ConnectClient.listSecurityProfilesPaginated(initialRequest: ListSecurityProfilesRequest): Flow<ListSecurityProfilesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSecurityProfilesPaginated.listSecurityProfiles(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListSecurityProfilesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSecurityProfilesResponse]
 */
public fun ConnectClient.listSecurityProfilesPaginated(block: ListSecurityProfilesRequest.Builder.() -> Unit): Flow<ListSecurityProfilesResponse> =
    listSecurityProfilesPaginated(ListSecurityProfilesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listSecurityProfilesPaginated]
 * to access the nested member [SecurityProfileSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SecurityProfileSummary]
 */
@JvmName("listSecurityProfilesResponseSecurityProfileSummary")
public fun Flow<ListSecurityProfilesResponse>.securityProfileSummaryList(): Flow<SecurityProfileSummary> =
    transform() { response ->
        response.securityProfileSummaryList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTaskTemplatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTaskTemplatesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTaskTemplatesResponse]
 */
public fun ConnectClient.listTaskTemplatesPaginated(initialRequest: ListTaskTemplatesRequest): Flow<ListTaskTemplatesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTaskTemplatesPaginated.listTaskTemplates(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListTaskTemplatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTaskTemplatesResponse]
 */
public fun ConnectClient.listTaskTemplatesPaginated(block: ListTaskTemplatesRequest.Builder.() -> Unit): Flow<ListTaskTemplatesResponse> =
    listTaskTemplatesPaginated(ListTaskTemplatesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTaskTemplatesPaginated]
 * to access the nested member [TaskTemplateMetadata]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TaskTemplateMetadata]
 */
@JvmName("listTaskTemplatesResponseTaskTemplateMetadata")
public fun Flow<ListTaskTemplatesResponse>.taskTemplates(): Flow<TaskTemplateMetadata> =
    transform() { response ->
        response.taskTemplates?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTrafficDistributionGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTrafficDistributionGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTrafficDistributionGroupsResponse]
 */
public fun ConnectClient.listTrafficDistributionGroupsPaginated(initialRequest: ListTrafficDistributionGroupsRequest): Flow<ListTrafficDistributionGroupsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTrafficDistributionGroupsPaginated.listTrafficDistributionGroups(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListTrafficDistributionGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTrafficDistributionGroupsResponse]
 */
public fun ConnectClient.listTrafficDistributionGroupsPaginated(block: ListTrafficDistributionGroupsRequest.Builder.() -> Unit): Flow<ListTrafficDistributionGroupsResponse> =
    listTrafficDistributionGroupsPaginated(ListTrafficDistributionGroupsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTrafficDistributionGroupsPaginated]
 * to access the nested member [TrafficDistributionGroupSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TrafficDistributionGroupSummary]
 */
@JvmName("listTrafficDistributionGroupsResponseTrafficDistributionGroupSummary")
public fun Flow<ListTrafficDistributionGroupsResponse>.trafficDistributionGroupSummaryList(): Flow<TrafficDistributionGroupSummary> =
    transform() { response ->
        response.trafficDistributionGroupSummaryList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListUseCasesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListUseCasesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListUseCasesResponse]
 */
public fun ConnectClient.listUseCasesPaginated(initialRequest: ListUseCasesRequest): Flow<ListUseCasesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listUseCasesPaginated.listUseCases(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListUseCasesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListUseCasesResponse]
 */
public fun ConnectClient.listUseCasesPaginated(block: ListUseCasesRequest.Builder.() -> Unit): Flow<ListUseCasesResponse> =
    listUseCasesPaginated(ListUseCasesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listUseCasesPaginated]
 * to access the nested member [UseCase]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [UseCase]
 */
@JvmName("listUseCasesResponseUseCase")
public fun Flow<ListUseCasesResponse>.useCaseSummaryList(): Flow<UseCase> =
    transform() { response ->
        response.useCaseSummaryList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListUserHierarchyGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListUserHierarchyGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListUserHierarchyGroupsResponse]
 */
public fun ConnectClient.listUserHierarchyGroupsPaginated(initialRequest: ListUserHierarchyGroupsRequest): Flow<ListUserHierarchyGroupsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listUserHierarchyGroupsPaginated.listUserHierarchyGroups(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListUserHierarchyGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListUserHierarchyGroupsResponse]
 */
public fun ConnectClient.listUserHierarchyGroupsPaginated(block: ListUserHierarchyGroupsRequest.Builder.() -> Unit): Flow<ListUserHierarchyGroupsResponse> =
    listUserHierarchyGroupsPaginated(ListUserHierarchyGroupsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listUserHierarchyGroupsPaginated]
 * to access the nested member [HierarchyGroupSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [HierarchyGroupSummary]
 */
@JvmName("listUserHierarchyGroupsResponseHierarchyGroupSummary")
public fun Flow<ListUserHierarchyGroupsResponse>.userHierarchyGroupSummaryList(): Flow<HierarchyGroupSummary> =
    transform() { response ->
        response.userHierarchyGroupSummaryList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListUsersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListUsersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListUsersResponse]
 */
public fun ConnectClient.listUsersPaginated(initialRequest: ListUsersRequest): Flow<ListUsersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listUsersPaginated.listUsers(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListUsersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListUsersResponse]
 */
public fun ConnectClient.listUsersPaginated(block: ListUsersRequest.Builder.() -> Unit): Flow<ListUsersResponse> =
    listUsersPaginated(ListUsersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listUsersPaginated]
 * to access the nested member [UserSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [UserSummary]
 */
@JvmName("listUsersResponseUserSummary")
public fun Flow<ListUsersResponse>.userSummaryList(): Flow<UserSummary> =
    transform() { response ->
        response.userSummaryList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [SearchAvailablePhoneNumbersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [SearchAvailablePhoneNumbersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchAvailablePhoneNumbersResponse]
 */
public fun ConnectClient.searchAvailablePhoneNumbersPaginated(initialRequest: SearchAvailablePhoneNumbersRequest): Flow<SearchAvailablePhoneNumbersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@searchAvailablePhoneNumbersPaginated.searchAvailablePhoneNumbers(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [SearchAvailablePhoneNumbersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchAvailablePhoneNumbersResponse]
 */
public fun ConnectClient.searchAvailablePhoneNumbersPaginated(block: SearchAvailablePhoneNumbersRequest.Builder.() -> Unit): Flow<SearchAvailablePhoneNumbersResponse> =
    searchAvailablePhoneNumbersPaginated(SearchAvailablePhoneNumbersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [searchAvailablePhoneNumbersPaginated]
 * to access the nested member [AvailableNumberSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AvailableNumberSummary]
 */
@JvmName("searchAvailablePhoneNumbersResponseAvailableNumberSummary")
public fun Flow<SearchAvailablePhoneNumbersResponse>.availableNumbersList(): Flow<AvailableNumberSummary> =
    transform() { response ->
        response.availableNumbersList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [SearchQueuesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [SearchQueuesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchQueuesResponse]
 */
public fun ConnectClient.searchQueuesPaginated(initialRequest: SearchQueuesRequest): Flow<SearchQueuesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@searchQueuesPaginated.searchQueues(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [SearchQueuesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchQueuesResponse]
 */
public fun ConnectClient.searchQueuesPaginated(block: SearchQueuesRequest.Builder.() -> Unit): Flow<SearchQueuesResponse> =
    searchQueuesPaginated(SearchQueuesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [searchQueuesPaginated]
 * to access the nested member [Queue]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Queue]
 */
@JvmName("searchQueuesResponseQueue")
public fun Flow<SearchQueuesResponse>.queues(): Flow<Queue> =
    transform() { response ->
        response.queues?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [SearchRoutingProfilesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [SearchRoutingProfilesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchRoutingProfilesResponse]
 */
public fun ConnectClient.searchRoutingProfilesPaginated(initialRequest: SearchRoutingProfilesRequest): Flow<SearchRoutingProfilesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@searchRoutingProfilesPaginated.searchRoutingProfiles(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [SearchRoutingProfilesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchRoutingProfilesResponse]
 */
public fun ConnectClient.searchRoutingProfilesPaginated(block: SearchRoutingProfilesRequest.Builder.() -> Unit): Flow<SearchRoutingProfilesResponse> =
    searchRoutingProfilesPaginated(SearchRoutingProfilesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [searchRoutingProfilesPaginated]
 * to access the nested member [RoutingProfile]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [RoutingProfile]
 */
@JvmName("searchRoutingProfilesResponseRoutingProfile")
public fun Flow<SearchRoutingProfilesResponse>.routingProfiles(): Flow<RoutingProfile> =
    transform() { response ->
        response.routingProfiles?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [SearchSecurityProfilesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [SearchSecurityProfilesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchSecurityProfilesResponse]
 */
public fun ConnectClient.searchSecurityProfilesPaginated(initialRequest: SearchSecurityProfilesRequest): Flow<SearchSecurityProfilesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@searchSecurityProfilesPaginated.searchSecurityProfiles(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [SearchSecurityProfilesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchSecurityProfilesResponse]
 */
public fun ConnectClient.searchSecurityProfilesPaginated(block: SearchSecurityProfilesRequest.Builder.() -> Unit): Flow<SearchSecurityProfilesResponse> =
    searchSecurityProfilesPaginated(SearchSecurityProfilesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [searchSecurityProfilesPaginated]
 * to access the nested member [SecurityProfileSearchSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SecurityProfileSearchSummary]
 */
@JvmName("searchSecurityProfilesResponseSecurityProfileSearchSummary")
public fun Flow<SearchSecurityProfilesResponse>.securityProfiles(): Flow<SecurityProfileSearchSummary> =
    transform() { response ->
        response.securityProfiles?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [SearchUsersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [SearchUsersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchUsersResponse]
 */
public fun ConnectClient.searchUsersPaginated(initialRequest: SearchUsersRequest): Flow<SearchUsersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@searchUsersPaginated.searchUsers(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [SearchUsersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchUsersResponse]
 */
public fun ConnectClient.searchUsersPaginated(block: SearchUsersRequest.Builder.() -> Unit): Flow<SearchUsersResponse> =
    searchUsersPaginated(SearchUsersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [searchUsersPaginated]
 * to access the nested member [UserSearchSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [UserSearchSummary]
 */
@JvmName("searchUsersResponseUserSearchSummary")
public fun Flow<SearchUsersResponse>.users(): Flow<UserSearchSummary> =
    transform() { response ->
        response.users?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [SearchVocabulariesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [SearchVocabulariesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchVocabulariesResponse]
 */
public fun ConnectClient.searchVocabulariesPaginated(initialRequest: SearchVocabulariesRequest): Flow<SearchVocabulariesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@searchVocabulariesPaginated.searchVocabularies(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [SearchVocabulariesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchVocabulariesResponse]
 */
public fun ConnectClient.searchVocabulariesPaginated(block: SearchVocabulariesRequest.Builder.() -> Unit): Flow<SearchVocabulariesResponse> =
    searchVocabulariesPaginated(SearchVocabulariesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [searchVocabulariesPaginated]
 * to access the nested member [VocabularySummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [VocabularySummary]
 */
@JvmName("searchVocabulariesResponseVocabularySummary")
public fun Flow<SearchVocabulariesResponse>.vocabularySummaryList(): Flow<VocabularySummary> =
    transform() { response ->
        response.vocabularySummaryList?.forEach {
            emit(it)
        }
    }
