// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model



public class UpdateRuleRequest private constructor(builder: Builder) {
    /**
     * A list of actions to be run when the rule is triggered.
     */
    public val actions: List<RuleAction>? = builder.actions
    /**
     * The conditions of the rule.
     */
    public val function: kotlin.String? = builder.function
    /**
     * The identifier of the Amazon Connect instance. You can [find the instance ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html) in the Amazon Resource Name (ARN) of the instance.
     */
    public val instanceId: kotlin.String? = requireNotNull(builder.instanceId) { "A non-null value must be provided for instanceId" }
    /**
     * The name of the rule. You can change the name only if `TriggerEventSource` is one of the following values: `OnZendeskTicketCreate` | `OnZendeskTicketStatusUpdate` | `OnSalesforceCaseCreate`
     */
    public val name: kotlin.String? = builder.name
    /**
     * The publish status of the rule.
     */
    public val publishStatus: aws.sdk.kotlin.services.connect.model.RulePublishStatus? = builder.publishStatus
    /**
     * A unique identifier for the rule.
     */
    public val ruleId: kotlin.String? = requireNotNull(builder.ruleId) { "A non-null value must be provided for ruleId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.UpdateRuleRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateRuleRequest(")
        append("actions=$actions,")
        append("function=$function,")
        append("instanceId=$instanceId,")
        append("name=$name,")
        append("publishStatus=$publishStatus,")
        append("ruleId=$ruleId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actions?.hashCode() ?: 0
        result = 31 * result + (function?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (publishStatus?.hashCode() ?: 0)
        result = 31 * result + (ruleId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateRuleRequest

        if (actions != other.actions) return false
        if (function != other.function) return false
        if (instanceId != other.instanceId) return false
        if (name != other.name) return false
        if (publishStatus != other.publishStatus) return false
        if (ruleId != other.ruleId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.UpdateRuleRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of actions to be run when the rule is triggered.
         */
        public var actions: List<RuleAction>? = null
        /**
         * The conditions of the rule.
         */
        public var function: kotlin.String? = null
        /**
         * The identifier of the Amazon Connect instance. You can [find the instance ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html) in the Amazon Resource Name (ARN) of the instance.
         */
        public var instanceId: kotlin.String? = null
        /**
         * The name of the rule. You can change the name only if `TriggerEventSource` is one of the following values: `OnZendeskTicketCreate` | `OnZendeskTicketStatusUpdate` | `OnSalesforceCaseCreate`
         */
        public var name: kotlin.String? = null
        /**
         * The publish status of the rule.
         */
        public var publishStatus: aws.sdk.kotlin.services.connect.model.RulePublishStatus? = null
        /**
         * A unique identifier for the rule.
         */
        public var ruleId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.UpdateRuleRequest) : this() {
            this.actions = x.actions
            this.function = x.function
            this.instanceId = x.instanceId
            this.name = x.name
            this.publishStatus = x.publishStatus
            this.ruleId = x.ruleId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.UpdateRuleRequest = UpdateRuleRequest(this)
    }
}
