// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model



/**
 * Contains summary information about a routing profile queue.
 */
public class RoutingProfileQueueConfigSummary private constructor(builder: Builder) {
    /**
     * The channels this queue supports.
     */
    public val channel: aws.sdk.kotlin.services.connect.model.Channel? = builder.channel
    /**
     * The delay, in seconds, that a contact should be in the queue before they are routed to an available agent. For more information, see [Queues: priority and delay](https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html) in the *Amazon Connect Administrator Guide*.
     */
    public val delay: kotlin.Int = builder.delay
    /**
     * The order in which contacts are to be handled for the queue. For more information, see [Queues: priority and delay](https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html).
     */
    public val priority: kotlin.Int = builder.priority
    /**
     * The Amazon Resource Name (ARN) of the queue.
     */
    public val queueArn: kotlin.String? = builder.queueArn
    /**
     * The identifier for the queue.
     */
    public val queueId: kotlin.String? = builder.queueId
    /**
     * The name of the queue.
     */
    public val queueName: kotlin.String? = builder.queueName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.RoutingProfileQueueConfigSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RoutingProfileQueueConfigSummary(")
        append("channel=$channel,")
        append("delay=$delay,")
        append("priority=$priority,")
        append("queueArn=$queueArn,")
        append("queueId=$queueId,")
        append("queueName=$queueName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = channel?.hashCode() ?: 0
        result = 31 * result + (delay)
        result = 31 * result + (priority)
        result = 31 * result + (queueArn?.hashCode() ?: 0)
        result = 31 * result + (queueId?.hashCode() ?: 0)
        result = 31 * result + (queueName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RoutingProfileQueueConfigSummary

        if (channel != other.channel) return false
        if (delay != other.delay) return false
        if (priority != other.priority) return false
        if (queueArn != other.queueArn) return false
        if (queueId != other.queueId) return false
        if (queueName != other.queueName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.RoutingProfileQueueConfigSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The channels this queue supports.
         */
        public var channel: aws.sdk.kotlin.services.connect.model.Channel? = null
        /**
         * The delay, in seconds, that a contact should be in the queue before they are routed to an available agent. For more information, see [Queues: priority and delay](https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html) in the *Amazon Connect Administrator Guide*.
         */
        public var delay: kotlin.Int = 0
        /**
         * The order in which contacts are to be handled for the queue. For more information, see [Queues: priority and delay](https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html).
         */
        public var priority: kotlin.Int = 0
        /**
         * The Amazon Resource Name (ARN) of the queue.
         */
        public var queueArn: kotlin.String? = null
        /**
         * The identifier for the queue.
         */
        public var queueId: kotlin.String? = null
        /**
         * The name of the queue.
         */
        public var queueName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.RoutingProfileQueueConfigSummary) : this() {
            this.channel = x.channel
            this.delay = x.delay
            this.priority = x.priority
            this.queueArn = x.queueArn
            this.queueId = x.queueId
            this.queueName = x.queueName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.RoutingProfileQueueConfigSummary = RoutingProfileQueueConfigSummary(this)
    }
}
