// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model



/**
 * Enable persistent chats. For more information about enabling persistent chat, and for example use cases and how to configure for them, see [Enable persistent chat](https://docs.aws.amazon.com/connect/latest/adminguide/chat-persistence.html).
 */
public class PersistentChat private constructor(builder: Builder) {
    /**
     * The contactId that is used for rehydration depends on the rehydration type. RehydrationType is required for persistent chat.
     * + `ENTIRE_PAST_SESSION`: Rehydrates a chat from the most recently terminated past chat contact of the specified past ended chat session. To use this type, provide the `initialContactId` of the past ended chat session in the `sourceContactId` field. In this type, Amazon Connect determines the most recent chat contact on the specified chat session that has ended, and uses it to start a persistent chat.
     * + `FROM_SEGMENT`: Rehydrates a chat from the past chat contact that is specified in the `sourceContactId` field.
     *
     * The actual contactId used for rehydration is provided in the response of this API.
     */
    public val rehydrationType: aws.sdk.kotlin.services.connect.model.RehydrationType? = builder.rehydrationType
    /**
     * The contactId from which a persistent chat session must be started.
     */
    public val sourceContactId: kotlin.String? = builder.sourceContactId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.PersistentChat = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PersistentChat(")
        append("rehydrationType=$rehydrationType,")
        append("sourceContactId=$sourceContactId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = rehydrationType?.hashCode() ?: 0
        result = 31 * result + (sourceContactId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PersistentChat

        if (rehydrationType != other.rehydrationType) return false
        if (sourceContactId != other.sourceContactId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.PersistentChat = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The contactId that is used for rehydration depends on the rehydration type. RehydrationType is required for persistent chat.
         * + `ENTIRE_PAST_SESSION`: Rehydrates a chat from the most recently terminated past chat contact of the specified past ended chat session. To use this type, provide the `initialContactId` of the past ended chat session in the `sourceContactId` field. In this type, Amazon Connect determines the most recent chat contact on the specified chat session that has ended, and uses it to start a persistent chat.
         * + `FROM_SEGMENT`: Rehydrates a chat from the past chat contact that is specified in the `sourceContactId` field.
         *
         * The actual contactId used for rehydration is provided in the response of this API.
         */
        public var rehydrationType: aws.sdk.kotlin.services.connect.model.RehydrationType? = null
        /**
         * The contactId from which a persistent chat session must be started.
         */
        public var sourceContactId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.PersistentChat) : this() {
            this.rehydrationType = x.rehydrationType
            this.sourceContactId = x.sourceContactId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.PersistentChat = PersistentChat(this)
    }
}
