// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model



/**
 * Configuration information for the timer. After the timer configuration is set, it persists for the duration of the chat. It persists across new contacts in the chain, for example, transfer contacts.
 *
 * For more information about how chat timeouts work, see [Set up chat timeouts for human participants](https://docs.aws.amazon.com/connect/latest/adminguide/setup-chat-timeouts.html).
 */
public class ParticipantTimerConfiguration private constructor(builder: Builder) {
    /**
     * The role of the participant in the chat conversation.
     */
    public val participantRole: aws.sdk.kotlin.services.connect.model.TimerEligibleParticipantRoles? = builder.participantRole
    /**
     * The type of timer. `IDLE` indicates the timer applies for considering a human chat participant as idle. `DISCONNECT_NONCUSTOMER` indicates the timer applies to automatically disconnecting a chat participant due to idleness.
     */
    public val timerType: aws.sdk.kotlin.services.connect.model.ParticipantTimerType? = builder.timerType
    /**
     * The value of the timer. Either the timer action (Unset to delete the timer), or the duration of the timer in minutes. Only one value can be set.
     */
    public val timerValue: aws.sdk.kotlin.services.connect.model.ParticipantTimerValue? = builder.timerValue

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.ParticipantTimerConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ParticipantTimerConfiguration(")
        append("participantRole=$participantRole,")
        append("timerType=$timerType,")
        append("timerValue=$timerValue")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = participantRole?.hashCode() ?: 0
        result = 31 * result + (timerType?.hashCode() ?: 0)
        result = 31 * result + (timerValue?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ParticipantTimerConfiguration

        if (participantRole != other.participantRole) return false
        if (timerType != other.timerType) return false
        if (timerValue != other.timerValue) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.ParticipantTimerConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The role of the participant in the chat conversation.
         */
        public var participantRole: aws.sdk.kotlin.services.connect.model.TimerEligibleParticipantRoles? = null
        /**
         * The type of timer. `IDLE` indicates the timer applies for considering a human chat participant as idle. `DISCONNECT_NONCUSTOMER` indicates the timer applies to automatically disconnecting a chat participant due to idleness.
         */
        public var timerType: aws.sdk.kotlin.services.connect.model.ParticipantTimerType? = null
        /**
         * The value of the timer. Either the timer action (Unset to delete the timer), or the duration of the timer in minutes. Only one value can be set.
         */
        public var timerValue: aws.sdk.kotlin.services.connect.model.ParticipantTimerValue? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.ParticipantTimerConfiguration) : this() {
            this.participantRole = x.participantRole
            this.timerType = x.timerType
            this.timerValue = x.timerValue
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.ParticipantTimerConfiguration = ParticipantTimerConfiguration(this)
    }
}
