// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model



public class GetCurrentUserDataRequest private constructor(builder: Builder) {
    /**
     * The filters to apply to returned user data. You can filter up to the following limits:
     * + Queues: 100
     * + Routing profiles: 100
     * + Agents: 100
     * + Contact states: 9
     * + User hierarchy groups: 1
     *
     *  The user data is retrieved for only the specified values/resources in the filter. A maximum of one filter can be passed from queues, routing profiles, agents, and user hierarchy groups.
     *
     * Currently tagging is only supported on the resources that are passed in the filter.
     */
    public val filters: aws.sdk.kotlin.services.connect.model.UserDataFilters? = builder.filters
    /**
     * The identifier of the Amazon Connect instance. You can [find the instance ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html) in the Amazon Resource Name (ARN) of the instance.
     */
    public val instanceId: kotlin.String? = requireNotNull(builder.instanceId) { "A non-null value must be provided for instanceId" }
    /**
     * The maximum number of results to return per page.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
     */
    public val nextToken: kotlin.String? = builder.nextToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.GetCurrentUserDataRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetCurrentUserDataRequest(")
        append("filters=$filters,")
        append("instanceId=$instanceId,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = filters?.hashCode() ?: 0
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetCurrentUserDataRequest

        if (filters != other.filters) return false
        if (instanceId != other.instanceId) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.GetCurrentUserDataRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The filters to apply to returned user data. You can filter up to the following limits:
         * + Queues: 100
         * + Routing profiles: 100
         * + Agents: 100
         * + Contact states: 9
         * + User hierarchy groups: 1
         *
         *  The user data is retrieved for only the specified values/resources in the filter. A maximum of one filter can be passed from queues, routing profiles, agents, and user hierarchy groups.
         *
         * Currently tagging is only supported on the resources that are passed in the filter.
         */
        public var filters: aws.sdk.kotlin.services.connect.model.UserDataFilters? = null
        /**
         * The identifier of the Amazon Connect instance. You can [find the instance ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html) in the Amazon Resource Name (ARN) of the instance.
         */
        public var instanceId: kotlin.String? = null
        /**
         * The maximum number of results to return per page.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
         */
        public var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.GetCurrentUserDataRequest) : this() {
            this.filters = x.filters
            this.instanceId = x.instanceId
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.GetCurrentUserDataRequest = GetCurrentUserDataRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.UserDataFilters] inside the given [block]
         */
        public fun filters(block: aws.sdk.kotlin.services.connect.model.UserDataFilters.Builder.() -> kotlin.Unit) {
            this.filters = aws.sdk.kotlin.services.connect.model.UserDataFilters.invoke(block)
        }
    }
}
