// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model



public class GetCurrentMetricDataRequest private constructor(builder: Builder) {
    /**
     * The metrics to retrieve. Specify the name and unit for each metric. The following metrics are available. For a description of all the metrics, see [Real-time Metrics Definitions](https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html) in the *Amazon Connect Administrator Guide*.
     *
     * ## AGENTS_AFTER_CONTACT_WORK
     * Unit: COUNT
     *
     * Name in real-time metrics report: [ACW](https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#aftercallwork-real-time)
     *
     * ## AGENTS_AVAILABLE
     * Unit: COUNT
     *
     * Name in real-time metrics report: [Available](https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#available-real-time)
     *
     * ## AGENTS_ERROR
     * Unit: COUNT
     *
     * Name in real-time metrics report: [Error](https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#error-real-time)
     *
     * ## AGENTS_NON_PRODUCTIVE
     * Unit: COUNT
     *
     * Name in real-time metrics report: [NPT (Non-Productive Time)](https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#non-productive-time-real-time)
     *
     * ## AGENTS_ON_CALL
     * Unit: COUNT
     *
     * Name in real-time metrics report: [On contact](https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#on-call-real-time)
     *
     * ## AGENTS_ON_CONTACT
     * Unit: COUNT
     *
     * Name in real-time metrics report: [On contact](https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#on-call-real-time)
     *
     * ## AGENTS_ONLINE
     * Unit: COUNT
     *
     * Name in real-time metrics report: [Online](https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#online-real-time)
     *
     * ## AGENTS_STAFFED
     * Unit: COUNT
     *
     * Name in real-time metrics report: [Staffed](https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#staffed-real-time)
     *
     * ## CONTACTS_IN_QUEUE
     * Unit: COUNT
     *
     * Name in real-time metrics report: [In queue](https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#in-queue-real-time)
     *
     * ## CONTACTS_SCHEDULED
     * Unit: COUNT
     *
     * Name in real-time metrics report: [Scheduled](https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#scheduled-real-time)
     *
     * ## OLDEST_CONTACT_AGE
     * Unit: SECONDS
     *
     * When you use groupings, Unit says SECONDS and the Value is returned in SECONDS.
     *
     * When you do not use groupings, Unit says SECONDS but the Value is returned in MILLISECONDS. For example, if you get a response like this:
     *
     * `{ "Metric": { "Name": "OLDEST_CONTACT_AGE", "Unit": "SECONDS" }, "Value": 24113.0 `}
     *
     * The actual OLDEST_CONTACT_AGE is 24 seconds.
     *
     * Name in real-time metrics report: [Oldest](https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#oldest-real-time)
     *
     * ## SLOTS_ACTIVE
     * Unit: COUNT
     *
     * Name in real-time metrics report: [Active](https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#active-real-time)
     *
     * ## SLOTS_AVAILABLE
     * Unit: COUNT
     *
     * Name in real-time metrics report: [Availability](https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#availability-real-time)
     */
    public val currentMetrics: List<CurrentMetric>? = builder.currentMetrics
    /**
     * The filters to apply to returned metrics. You can filter up to the following limits:
     * + Queues: 100
     * + Routing profiles: 100
     * + Channels: 3 (VOICE, CHAT, and TASK channels are supported.)
     *
     * Metric data is retrieved only for the resources associated with the queues or routing profiles, and by any channels included in the filter. (You cannot filter by both queue AND routing profile.) You can include both resource IDs and resource ARNs in the same request.
     *
     * Currently tagging is only supported on the resources that are passed in the filter.
     */
    public val filters: aws.sdk.kotlin.services.connect.model.Filters? = builder.filters
    /**
     * The grouping applied to the metrics returned. For example, when grouped by `QUEUE`, the metrics returned apply to each queue rather than aggregated for all queues.
     * + If you group by `CHANNEL`, you should include a Channels filter. VOICE, CHAT, and TASK channels are supported.
     * + If you group by `ROUTING_PROFILE`, you must include either a queue or routing profile filter. In addition, a routing profile filter is required for metrics `CONTACTS_SCHEDULED`, `CONTACTS_IN_QUEUE`, and ` OLDEST_CONTACT_AGE`.
     * + If no `Grouping` is included in the request, a summary of metrics is returned.
     */
    public val groupings: List<Grouping>? = builder.groupings
    /**
     * The identifier of the Amazon Connect instance. You can [find the instance ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html) in the Amazon Resource Name (ARN) of the instance.
     */
    public val instanceId: kotlin.String? = requireNotNull(builder.instanceId) { "A non-null value must be provided for instanceId" }
    /**
     * The maximum number of results to return per page.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
     *
     * The token expires after 5 minutes from the time it is created. Subsequent requests that use the token must use the same request parameters as the request that generated the token.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The way to sort the resulting response based on metrics. You can enter one sort criteria. By default resources are sorted based on `AGENTS_ONLINE`, `DESCENDING`. The metric collection is sorted based on the input metrics.
     *
     * Note the following:
     * + Sorting on `SLOTS_ACTIVE` and `SLOTS_AVAILABLE` is not supported.
     */
    public val sortCriteria: List<CurrentMetricSortCriteria>? = builder.sortCriteria

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.GetCurrentMetricDataRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetCurrentMetricDataRequest(")
        append("currentMetrics=$currentMetrics,")
        append("filters=$filters,")
        append("groupings=$groupings,")
        append("instanceId=$instanceId,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("sortCriteria=$sortCriteria")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = currentMetrics?.hashCode() ?: 0
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (groupings?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (sortCriteria?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetCurrentMetricDataRequest

        if (currentMetrics != other.currentMetrics) return false
        if (filters != other.filters) return false
        if (groupings != other.groupings) return false
        if (instanceId != other.instanceId) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (sortCriteria != other.sortCriteria) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.GetCurrentMetricDataRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The metrics to retrieve. Specify the name and unit for each metric. The following metrics are available. For a description of all the metrics, see [Real-time Metrics Definitions](https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html) in the *Amazon Connect Administrator Guide*.
         *
         * ## AGENTS_AFTER_CONTACT_WORK
         * Unit: COUNT
         *
         * Name in real-time metrics report: [ACW](https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#aftercallwork-real-time)
         *
         * ## AGENTS_AVAILABLE
         * Unit: COUNT
         *
         * Name in real-time metrics report: [Available](https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#available-real-time)
         *
         * ## AGENTS_ERROR
         * Unit: COUNT
         *
         * Name in real-time metrics report: [Error](https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#error-real-time)
         *
         * ## AGENTS_NON_PRODUCTIVE
         * Unit: COUNT
         *
         * Name in real-time metrics report: [NPT (Non-Productive Time)](https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#non-productive-time-real-time)
         *
         * ## AGENTS_ON_CALL
         * Unit: COUNT
         *
         * Name in real-time metrics report: [On contact](https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#on-call-real-time)
         *
         * ## AGENTS_ON_CONTACT
         * Unit: COUNT
         *
         * Name in real-time metrics report: [On contact](https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#on-call-real-time)
         *
         * ## AGENTS_ONLINE
         * Unit: COUNT
         *
         * Name in real-time metrics report: [Online](https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#online-real-time)
         *
         * ## AGENTS_STAFFED
         * Unit: COUNT
         *
         * Name in real-time metrics report: [Staffed](https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#staffed-real-time)
         *
         * ## CONTACTS_IN_QUEUE
         * Unit: COUNT
         *
         * Name in real-time metrics report: [In queue](https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#in-queue-real-time)
         *
         * ## CONTACTS_SCHEDULED
         * Unit: COUNT
         *
         * Name in real-time metrics report: [Scheduled](https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#scheduled-real-time)
         *
         * ## OLDEST_CONTACT_AGE
         * Unit: SECONDS
         *
         * When you use groupings, Unit says SECONDS and the Value is returned in SECONDS.
         *
         * When you do not use groupings, Unit says SECONDS but the Value is returned in MILLISECONDS. For example, if you get a response like this:
         *
         * `{ "Metric": { "Name": "OLDEST_CONTACT_AGE", "Unit": "SECONDS" }, "Value": 24113.0 `}
         *
         * The actual OLDEST_CONTACT_AGE is 24 seconds.
         *
         * Name in real-time metrics report: [Oldest](https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#oldest-real-time)
         *
         * ## SLOTS_ACTIVE
         * Unit: COUNT
         *
         * Name in real-time metrics report: [Active](https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#active-real-time)
         *
         * ## SLOTS_AVAILABLE
         * Unit: COUNT
         *
         * Name in real-time metrics report: [Availability](https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#availability-real-time)
         */
        public var currentMetrics: List<CurrentMetric>? = null
        /**
         * The filters to apply to returned metrics. You can filter up to the following limits:
         * + Queues: 100
         * + Routing profiles: 100
         * + Channels: 3 (VOICE, CHAT, and TASK channels are supported.)
         *
         * Metric data is retrieved only for the resources associated with the queues or routing profiles, and by any channels included in the filter. (You cannot filter by both queue AND routing profile.) You can include both resource IDs and resource ARNs in the same request.
         *
         * Currently tagging is only supported on the resources that are passed in the filter.
         */
        public var filters: aws.sdk.kotlin.services.connect.model.Filters? = null
        /**
         * The grouping applied to the metrics returned. For example, when grouped by `QUEUE`, the metrics returned apply to each queue rather than aggregated for all queues.
         * + If you group by `CHANNEL`, you should include a Channels filter. VOICE, CHAT, and TASK channels are supported.
         * + If you group by `ROUTING_PROFILE`, you must include either a queue or routing profile filter. In addition, a routing profile filter is required for metrics `CONTACTS_SCHEDULED`, `CONTACTS_IN_QUEUE`, and ` OLDEST_CONTACT_AGE`.
         * + If no `Grouping` is included in the request, a summary of metrics is returned.
         */
        public var groupings: List<Grouping>? = null
        /**
         * The identifier of the Amazon Connect instance. You can [find the instance ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html) in the Amazon Resource Name (ARN) of the instance.
         */
        public var instanceId: kotlin.String? = null
        /**
         * The maximum number of results to return per page.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
         *
         * The token expires after 5 minutes from the time it is created. Subsequent requests that use the token must use the same request parameters as the request that generated the token.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The way to sort the resulting response based on metrics. You can enter one sort criteria. By default resources are sorted based on `AGENTS_ONLINE`, `DESCENDING`. The metric collection is sorted based on the input metrics.
         *
         * Note the following:
         * + Sorting on `SLOTS_ACTIVE` and `SLOTS_AVAILABLE` is not supported.
         */
        public var sortCriteria: List<CurrentMetricSortCriteria>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.GetCurrentMetricDataRequest) : this() {
            this.currentMetrics = x.currentMetrics
            this.filters = x.filters
            this.groupings = x.groupings
            this.instanceId = x.instanceId
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.sortCriteria = x.sortCriteria
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.GetCurrentMetricDataRequest = GetCurrentMetricDataRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.Filters] inside the given [block]
         */
        public fun filters(block: aws.sdk.kotlin.services.connect.model.Filters.Builder.() -> kotlin.Unit) {
            this.filters = aws.sdk.kotlin.services.connect.model.Filters.invoke(block)
        }
    }
}
