// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.services.connect.auth.AuthSchemeProviderAdapter
import aws.sdk.kotlin.services.connect.auth.IdentityProviderConfigAdapter
import aws.sdk.kotlin.services.connect.endpoints.internal.EndpointResolverAdapter
import aws.sdk.kotlin.services.connect.model.*
import aws.sdk.kotlin.services.connect.transform.*
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.auth.HttpAuthScheme
import aws.smithy.kotlin.runtime.http.auth.SigV4AuthScheme
import aws.smithy.kotlin.runtime.http.operation.OperationAuthConfig
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.sdkRequestId
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.tracing.withRootTraceSpan
import aws.smithy.kotlin.runtime.util.putIfAbsent
import kotlin.coroutines.coroutineContext


public const val ServiceId: String = "Connect"
public const val ServiceApiVersion: String = "2017-08-08"
public const val SdkVersion: String = "0.22.1-beta"

internal class DefaultConnectClient(override val config: ConnectClient.Config) : ConnectClient {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClientEngine)
    private val identityProviderConfig = IdentityProviderConfigAdapter(config)
    private val configuredAuthSchemes = with(config.authSchemes.associateBy(HttpAuthScheme::schemeId).toMutableMap()){
        getOrPut(AuthSchemeId.AwsSigV4){
            SigV4AuthScheme(DefaultAwsSigner, "connect")
        }
        toMap()
    }

    init {
        managedResources.addIfManaged(config.httpClientEngine)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Associates an approved origin to an Amazon Connect instance.
     */
    override suspend fun associateApprovedOrigin(input: AssociateApprovedOriginRequest): AssociateApprovedOriginResponse {
        val op = SdkHttpOperation.build<AssociateApprovedOriginRequest, AssociateApprovedOriginResponse> {
            serializer = AssociateApprovedOriginOperationSerializer()
            deserializer = AssociateApprovedOriginOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "AssociateApprovedOrigin"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("AssociateApprovedOrigin-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Allows the specified Amazon Connect instance to access the specified Amazon Lex or Amazon Lex V2 bot.
     */
    override suspend fun associateBot(input: AssociateBotRequest): AssociateBotResponse {
        val op = SdkHttpOperation.build<AssociateBotRequest, AssociateBotResponse> {
            serializer = AssociateBotOperationSerializer()
            deserializer = AssociateBotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "AssociateBot"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("AssociateBot-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Associates an existing vocabulary as the default. Contact Lens for Amazon Connect uses the vocabulary in post-call and real-time analysis sessions for the given language.
     */
    override suspend fun associateDefaultVocabulary(input: AssociateDefaultVocabularyRequest): AssociateDefaultVocabularyResponse {
        val op = SdkHttpOperation.build<AssociateDefaultVocabularyRequest, AssociateDefaultVocabularyResponse> {
            serializer = AssociateDefaultVocabularyOperationSerializer()
            deserializer = AssociateDefaultVocabularyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "AssociateDefaultVocabulary"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("AssociateDefaultVocabulary-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Associates a storage resource type for the first time. You can only associate one type of storage configuration in a single call. This means, for example, that you can't define an instance with multiple S3 buckets for storing chat transcripts.
     *
     * This API does not create a resource that doesn't exist. It only associates it to the instance. Ensure that the resource being specified in the storage configuration, like an S3 bucket, exists when being used for association.
     */
    override suspend fun associateInstanceStorageConfig(input: AssociateInstanceStorageConfigRequest): AssociateInstanceStorageConfigResponse {
        val op = SdkHttpOperation.build<AssociateInstanceStorageConfigRequest, AssociateInstanceStorageConfigResponse> {
            serializer = AssociateInstanceStorageConfigOperationSerializer()
            deserializer = AssociateInstanceStorageConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "AssociateInstanceStorageConfig"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("AssociateInstanceStorageConfig-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Allows the specified Amazon Connect instance to access the specified Lambda function.
     */
    override suspend fun associateLambdaFunction(input: AssociateLambdaFunctionRequest): AssociateLambdaFunctionResponse {
        val op = SdkHttpOperation.build<AssociateLambdaFunctionRequest, AssociateLambdaFunctionResponse> {
            serializer = AssociateLambdaFunctionOperationSerializer()
            deserializer = AssociateLambdaFunctionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "AssociateLambdaFunction"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("AssociateLambdaFunction-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Allows the specified Amazon Connect instance to access the specified Amazon Lex V1 bot. This API only supports the association of Amazon Lex V1 bots.
     */
    override suspend fun associateLexBot(input: AssociateLexBotRequest): AssociateLexBotResponse {
        val op = SdkHttpOperation.build<AssociateLexBotRequest, AssociateLexBotResponse> {
            serializer = AssociateLexBotOperationSerializer()
            deserializer = AssociateLexBotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "AssociateLexBot"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("AssociateLexBot-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Associates a flow with a phone number claimed to your Amazon Connect instance.
     *
     * If the number is claimed to a traffic distribution group, and you are calling this API using an instance in the Amazon Web Services Region where the traffic distribution group was created, you can use either a full phone number ARN or UUID value for the `PhoneNumberId` URI request parameter. However, if the number is claimed to a traffic distribution group and you are calling this API using an instance in the alternate Amazon Web Services Region associated with the traffic distribution group, you must provide a full phone number ARN. If a UUID is provided in this scenario, you will receive a `ResourceNotFoundException`.
     */
    override suspend fun associatePhoneNumberContactFlow(input: AssociatePhoneNumberContactFlowRequest): AssociatePhoneNumberContactFlowResponse {
        val op = SdkHttpOperation.build<AssociatePhoneNumberContactFlowRequest, AssociatePhoneNumberContactFlowResponse> {
            serializer = AssociatePhoneNumberContactFlowOperationSerializer()
            deserializer = AssociatePhoneNumberContactFlowOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "AssociatePhoneNumberContactFlow"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("AssociatePhoneNumberContactFlow-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Associates a set of quick connects with a queue.
     */
    override suspend fun associateQueueQuickConnects(input: AssociateQueueQuickConnectsRequest): AssociateQueueQuickConnectsResponse {
        val op = SdkHttpOperation.build<AssociateQueueQuickConnectsRequest, AssociateQueueQuickConnectsResponse> {
            serializer = AssociateQueueQuickConnectsOperationSerializer()
            deserializer = AssociateQueueQuickConnectsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "AssociateQueueQuickConnects"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("AssociateQueueQuickConnects-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Associates a set of queues with a routing profile.
     */
    override suspend fun associateRoutingProfileQueues(input: AssociateRoutingProfileQueuesRequest): AssociateRoutingProfileQueuesResponse {
        val op = SdkHttpOperation.build<AssociateRoutingProfileQueuesRequest, AssociateRoutingProfileQueuesResponse> {
            serializer = AssociateRoutingProfileQueuesOperationSerializer()
            deserializer = AssociateRoutingProfileQueuesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "AssociateRoutingProfileQueues"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("AssociateRoutingProfileQueues-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Associates a security key to the instance.
     */
    override suspend fun associateSecurityKey(input: AssociateSecurityKeyRequest): AssociateSecurityKeyResponse {
        val op = SdkHttpOperation.build<AssociateSecurityKeyRequest, AssociateSecurityKeyResponse> {
            serializer = AssociateSecurityKeyOperationSerializer()
            deserializer = AssociateSecurityKeyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "AssociateSecurityKey"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("AssociateSecurityKey-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Claims an available phone number to your Amazon Connect instance or traffic distribution group. You can call this API only in the same Amazon Web Services Region where the Amazon Connect instance or traffic distribution group was created.
     *
     * For more information about how to use this operation, see [Claim a phone number in your country](https://docs.aws.amazon.com/connect/latest/adminguide/claim-phone-number.html) and [Claim phone numbers to traffic distribution groups](https://docs.aws.amazon.com/connect/latest/adminguide/claim-phone-numbers-traffic-distribution-groups.html) in the *Amazon Connect Administrator Guide*.
     *
     * You can call the [SearchAvailablePhoneNumbers](https://docs.aws.amazon.com/connect/latest/APIReference/API_SearchAvailablePhoneNumbers.html) API for available phone numbers that you can claim. Call the [DescribePhoneNumber](https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribePhoneNumber.html) API to verify the status of a previous [ClaimPhoneNumber](https://docs.aws.amazon.com/connect/latest/APIReference/API_ClaimPhoneNumber.html) operation.
     */
    override suspend fun claimPhoneNumber(input: ClaimPhoneNumberRequest): ClaimPhoneNumberResponse {
        val op = SdkHttpOperation.build<ClaimPhoneNumberRequest, ClaimPhoneNumberResponse> {
            serializer = ClaimPhoneNumberOperationSerializer()
            deserializer = ClaimPhoneNumberOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ClaimPhoneNumber"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ClaimPhoneNumber-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Creates an agent status for the specified Amazon Connect instance.
     */
    override suspend fun createAgentStatus(input: CreateAgentStatusRequest): CreateAgentStatusResponse {
        val op = SdkHttpOperation.build<CreateAgentStatusRequest, CreateAgentStatusResponse> {
            serializer = CreateAgentStatusOperationSerializer()
            deserializer = CreateAgentStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateAgentStatus"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateAgentStatus-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a flow for the specified Amazon Connect instance.
     *
     * You can also create and update flows using the [Amazon Connect Flow language](https://docs.aws.amazon.com/connect/latest/APIReference/flow-language.html).
     */
    override suspend fun createContactFlow(input: CreateContactFlowRequest): CreateContactFlowResponse {
        val op = SdkHttpOperation.build<CreateContactFlowRequest, CreateContactFlowResponse> {
            serializer = CreateContactFlowOperationSerializer()
            deserializer = CreateContactFlowOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateContactFlow"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateContactFlow-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a flow module for the specified Amazon Connect instance.
     */
    override suspend fun createContactFlowModule(input: CreateContactFlowModuleRequest): CreateContactFlowModuleResponse {
        val op = SdkHttpOperation.build<CreateContactFlowModuleRequest, CreateContactFlowModuleResponse> {
            serializer = CreateContactFlowModuleOperationSerializer()
            deserializer = CreateContactFlowModuleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateContactFlowModule"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateContactFlowModule-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Creates hours of operation.
     */
    override suspend fun createHoursOfOperation(input: CreateHoursOfOperationRequest): CreateHoursOfOperationResponse {
        val op = SdkHttpOperation.build<CreateHoursOfOperationRequest, CreateHoursOfOperationResponse> {
            serializer = CreateHoursOfOperationOperationSerializer()
            deserializer = CreateHoursOfOperationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateHoursOfOperation"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateHoursOfOperation-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Initiates an Amazon Connect instance with all the supported channels enabled. It does not attach any storage, such as Amazon Simple Storage Service (Amazon S3) or Amazon Kinesis. It also does not allow for any configurations on features, such as Contact Lens for Amazon Connect.
     *
     * Amazon Connect enforces a limit on the total number of instances that you can create or delete in 30 days. If you exceed this limit, you will get an error message indicating there has been an excessive number of attempts at creating or deleting instances. You must wait 30 days before you can restart creating and deleting instances in your account.
     */
    override suspend fun createInstance(input: CreateInstanceRequest): CreateInstanceResponse {
        val op = SdkHttpOperation.build<CreateInstanceRequest, CreateInstanceResponse> {
            serializer = CreateInstanceOperationSerializer()
            deserializer = CreateInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateInstance"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateInstance-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates an Amazon Web Services resource association with an Amazon Connect instance.
     */
    override suspend fun createIntegrationAssociation(input: CreateIntegrationAssociationRequest): CreateIntegrationAssociationResponse {
        val op = SdkHttpOperation.build<CreateIntegrationAssociationRequest, CreateIntegrationAssociationResponse> {
            serializer = CreateIntegrationAssociationOperationSerializer()
            deserializer = CreateIntegrationAssociationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateIntegrationAssociation"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateIntegrationAssociation-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Creates a new queue for the specified Amazon Connect instance.
     *
     * If the number being used in the input is claimed to a traffic distribution group, and you are calling this API using an instance in the Amazon Web Services Region where the traffic distribution group was created, you can use either a full phone number ARN or UUID value for the `OutboundCallerIdNumberId` value of the [OutboundCallerConfig](https://docs.aws.amazon.com/connect/latest/APIReference/API_OutboundCallerConfig) request body parameter. However, if the number is claimed to a traffic distribution group and you are calling this API using an instance in the alternate Amazon Web Services Region associated with the traffic distribution group, you must provide a full phone number ARN. If a UUID is provided in this scenario, you will receive a `ResourceNotFoundException`.
     */
    override suspend fun createQueue(input: CreateQueueRequest): CreateQueueResponse {
        val op = SdkHttpOperation.build<CreateQueueRequest, CreateQueueResponse> {
            serializer = CreateQueueOperationSerializer()
            deserializer = CreateQueueOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateQueue"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateQueue-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a quick connect for the specified Amazon Connect instance.
     */
    override suspend fun createQuickConnect(input: CreateQuickConnectRequest): CreateQuickConnectResponse {
        val op = SdkHttpOperation.build<CreateQuickConnectRequest, CreateQuickConnectResponse> {
            serializer = CreateQuickConnectOperationSerializer()
            deserializer = CreateQuickConnectOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateQuickConnect"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateQuickConnect-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a new routing profile.
     */
    override suspend fun createRoutingProfile(input: CreateRoutingProfileRequest): CreateRoutingProfileResponse {
        val op = SdkHttpOperation.build<CreateRoutingProfileRequest, CreateRoutingProfileResponse> {
            serializer = CreateRoutingProfileOperationSerializer()
            deserializer = CreateRoutingProfileOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateRoutingProfile"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateRoutingProfile-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a rule for the specified Amazon Connect instance.
     *
     * Use the [Rules Function language](https://docs.aws.amazon.com/connect/latest/APIReference/connect-rules-language.html) to code conditions for the rule.
     */
    override suspend fun createRule(input: CreateRuleRequest): CreateRuleResponse {
        val op = SdkHttpOperation.build<CreateRuleRequest, CreateRuleResponse> {
            serializer = CreateRuleOperationSerializer()
            deserializer = CreateRuleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateRule"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateRule-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Creates a security profile.
     */
    override suspend fun createSecurityProfile(input: CreateSecurityProfileRequest): CreateSecurityProfileResponse {
        val op = SdkHttpOperation.build<CreateSecurityProfileRequest, CreateSecurityProfileResponse> {
            serializer = CreateSecurityProfileOperationSerializer()
            deserializer = CreateSecurityProfileOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateSecurityProfile"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateSecurityProfile-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a new task template in the specified Amazon Connect instance.
     */
    override suspend fun createTaskTemplate(input: CreateTaskTemplateRequest): CreateTaskTemplateResponse {
        val op = SdkHttpOperation.build<CreateTaskTemplateRequest, CreateTaskTemplateResponse> {
            serializer = CreateTaskTemplateOperationSerializer()
            deserializer = CreateTaskTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateTaskTemplate"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateTaskTemplate-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a traffic distribution group given an Amazon Connect instance that has been replicated.
     *
     * For more information about creating traffic distribution groups, see [Set up traffic distribution groups](https://docs.aws.amazon.com/connect/latest/adminguide/setup-traffic-distribution-groups.html) in the *Amazon Connect Administrator Guide*.
     */
    override suspend fun createTrafficDistributionGroup(input: CreateTrafficDistributionGroupRequest): CreateTrafficDistributionGroupResponse {
        val op = SdkHttpOperation.build<CreateTrafficDistributionGroupRequest, CreateTrafficDistributionGroupResponse> {
            serializer = CreateTrafficDistributionGroupOperationSerializer()
            deserializer = CreateTrafficDistributionGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateTrafficDistributionGroup"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateTrafficDistributionGroup-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a use case for an integration association.
     */
    override suspend fun createUseCase(input: CreateUseCaseRequest): CreateUseCaseResponse {
        val op = SdkHttpOperation.build<CreateUseCaseRequest, CreateUseCaseResponse> {
            serializer = CreateUseCaseOperationSerializer()
            deserializer = CreateUseCaseOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateUseCase"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateUseCase-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a user account for the specified Amazon Connect instance.
     *
     * For information about how to create user accounts using the Amazon Connect console, see [Add Users](https://docs.aws.amazon.com/connect/latest/adminguide/user-management.html) in the *Amazon Connect Administrator Guide*.
     */
    override suspend fun createUser(input: CreateUserRequest): CreateUserResponse {
        val op = SdkHttpOperation.build<CreateUserRequest, CreateUserResponse> {
            serializer = CreateUserOperationSerializer()
            deserializer = CreateUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateUser"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateUser-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a new user hierarchy group.
     */
    override suspend fun createUserHierarchyGroup(input: CreateUserHierarchyGroupRequest): CreateUserHierarchyGroupResponse {
        val op = SdkHttpOperation.build<CreateUserHierarchyGroupRequest, CreateUserHierarchyGroupResponse> {
            serializer = CreateUserHierarchyGroupOperationSerializer()
            deserializer = CreateUserHierarchyGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateUserHierarchyGroup"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateUserHierarchyGroup-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a custom vocabulary associated with your Amazon Connect instance. You can set a custom vocabulary to be your default vocabulary for a given language. Contact Lens for Amazon Connect uses the default vocabulary in post-call and real-time contact analysis sessions for that language.
     */
    override suspend fun createVocabulary(input: CreateVocabularyRequest): CreateVocabularyResponse {
        val op = SdkHttpOperation.build<CreateVocabularyRequest, CreateVocabularyResponse> {
            serializer = CreateVocabularyOperationSerializer()
            deserializer = CreateVocabularyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateVocabulary"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateVocabulary-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a flow for the specified Amazon Connect instance.
     */
    override suspend fun deleteContactFlow(input: DeleteContactFlowRequest): DeleteContactFlowResponse {
        val op = SdkHttpOperation.build<DeleteContactFlowRequest, DeleteContactFlowResponse> {
            serializer = DeleteContactFlowOperationSerializer()
            deserializer = DeleteContactFlowOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DeleteContactFlow"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteContactFlow-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes the specified flow module.
     */
    override suspend fun deleteContactFlowModule(input: DeleteContactFlowModuleRequest): DeleteContactFlowModuleResponse {
        val op = SdkHttpOperation.build<DeleteContactFlowModuleRequest, DeleteContactFlowModuleResponse> {
            serializer = DeleteContactFlowModuleOperationSerializer()
            deserializer = DeleteContactFlowModuleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DeleteContactFlowModule"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteContactFlowModule-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Deletes an hours of operation.
     */
    override suspend fun deleteHoursOfOperation(input: DeleteHoursOfOperationRequest): DeleteHoursOfOperationResponse {
        val op = SdkHttpOperation.build<DeleteHoursOfOperationRequest, DeleteHoursOfOperationResponse> {
            serializer = DeleteHoursOfOperationOperationSerializer()
            deserializer = DeleteHoursOfOperationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DeleteHoursOfOperation"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteHoursOfOperation-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Deletes the Amazon Connect instance.
     *
     * Amazon Connect enforces a limit on the total number of instances that you can create or delete in 30 days. If you exceed this limit, you will get an error message indicating there has been an excessive number of attempts at creating or deleting instances. You must wait 30 days before you can restart creating and deleting instances in your account.
     */
    override suspend fun deleteInstance(input: DeleteInstanceRequest): DeleteInstanceResponse {
        val op = SdkHttpOperation.build<DeleteInstanceRequest, DeleteInstanceResponse> {
            serializer = DeleteInstanceOperationSerializer()
            deserializer = DeleteInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DeleteInstance"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteInstance-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes an Amazon Web Services resource association from an Amazon Connect instance. The association must not have any use cases associated with it.
     */
    override suspend fun deleteIntegrationAssociation(input: DeleteIntegrationAssociationRequest): DeleteIntegrationAssociationResponse {
        val op = SdkHttpOperation.build<DeleteIntegrationAssociationRequest, DeleteIntegrationAssociationResponse> {
            serializer = DeleteIntegrationAssociationOperationSerializer()
            deserializer = DeleteIntegrationAssociationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DeleteIntegrationAssociation"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteIntegrationAssociation-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a quick connect.
     */
    override suspend fun deleteQuickConnect(input: DeleteQuickConnectRequest): DeleteQuickConnectResponse {
        val op = SdkHttpOperation.build<DeleteQuickConnectRequest, DeleteQuickConnectResponse> {
            serializer = DeleteQuickConnectOperationSerializer()
            deserializer = DeleteQuickConnectOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DeleteQuickConnect"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteQuickConnect-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a rule for the specified Amazon Connect instance.
     */
    override suspend fun deleteRule(input: DeleteRuleRequest): DeleteRuleResponse {
        val op = SdkHttpOperation.build<DeleteRuleRequest, DeleteRuleResponse> {
            serializer = DeleteRuleOperationSerializer()
            deserializer = DeleteRuleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DeleteRule"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteRule-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Deletes a security profile.
     */
    override suspend fun deleteSecurityProfile(input: DeleteSecurityProfileRequest): DeleteSecurityProfileResponse {
        val op = SdkHttpOperation.build<DeleteSecurityProfileRequest, DeleteSecurityProfileResponse> {
            serializer = DeleteSecurityProfileOperationSerializer()
            deserializer = DeleteSecurityProfileOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DeleteSecurityProfile"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteSecurityProfile-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes the task template.
     */
    override suspend fun deleteTaskTemplate(input: DeleteTaskTemplateRequest): DeleteTaskTemplateResponse {
        val op = SdkHttpOperation.build<DeleteTaskTemplateRequest, DeleteTaskTemplateResponse> {
            serializer = DeleteTaskTemplateOperationSerializer()
            deserializer = DeleteTaskTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DeleteTaskTemplate"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteTaskTemplate-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a traffic distribution group. This API can be called only in the Region where the traffic distribution group is created.
     *
     * For more information about deleting traffic distribution groups, see [Delete traffic distribution groups](https://docs.aws.amazon.com/connect/latest/adminguide/delete-traffic-distribution-groups.html) in the *Amazon Connect Administrator Guide*.
     */
    override suspend fun deleteTrafficDistributionGroup(input: DeleteTrafficDistributionGroupRequest): DeleteTrafficDistributionGroupResponse {
        val op = SdkHttpOperation.build<DeleteTrafficDistributionGroupRequest, DeleteTrafficDistributionGroupResponse> {
            serializer = DeleteTrafficDistributionGroupOperationSerializer()
            deserializer = DeleteTrafficDistributionGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DeleteTrafficDistributionGroup"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteTrafficDistributionGroup-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a use case from an integration association.
     */
    override suspend fun deleteUseCase(input: DeleteUseCaseRequest): DeleteUseCaseResponse {
        val op = SdkHttpOperation.build<DeleteUseCaseRequest, DeleteUseCaseResponse> {
            serializer = DeleteUseCaseOperationSerializer()
            deserializer = DeleteUseCaseOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DeleteUseCase"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteUseCase-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a user account from the specified Amazon Connect instance.
     *
     * For information about what happens to a user's data when their account is deleted, see [Delete Users from Your Amazon Connect Instance](https://docs.aws.amazon.com/connect/latest/adminguide/delete-users.html) in the *Amazon Connect Administrator Guide*.
     */
    override suspend fun deleteUser(input: DeleteUserRequest): DeleteUserResponse {
        val op = SdkHttpOperation.build<DeleteUserRequest, DeleteUserResponse> {
            serializer = DeleteUserOperationSerializer()
            deserializer = DeleteUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DeleteUser"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteUser-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes an existing user hierarchy group. It must not be associated with any agents or have any active child groups.
     */
    override suspend fun deleteUserHierarchyGroup(input: DeleteUserHierarchyGroupRequest): DeleteUserHierarchyGroupResponse {
        val op = SdkHttpOperation.build<DeleteUserHierarchyGroupRequest, DeleteUserHierarchyGroupResponse> {
            serializer = DeleteUserHierarchyGroupOperationSerializer()
            deserializer = DeleteUserHierarchyGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DeleteUserHierarchyGroup"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteUserHierarchyGroup-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes the vocabulary that has the given identifier.
     */
    override suspend fun deleteVocabulary(input: DeleteVocabularyRequest): DeleteVocabularyResponse {
        val op = SdkHttpOperation.build<DeleteVocabularyRequest, DeleteVocabularyResponse> {
            serializer = DeleteVocabularyOperationSerializer()
            deserializer = DeleteVocabularyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DeleteVocabulary"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteVocabulary-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Describes an agent status.
     */
    override suspend fun describeAgentStatus(input: DescribeAgentStatusRequest): DescribeAgentStatusResponse {
        val op = SdkHttpOperation.build<DescribeAgentStatusRequest, DescribeAgentStatusResponse> {
            serializer = DescribeAgentStatusOperationSerializer()
            deserializer = DescribeAgentStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeAgentStatus"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeAgentStatus-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Describes the specified contact.
     *
     * Contact information remains available in Amazon Connect for 24 months, and then it is deleted.
     *
     * Only data from November 12, 2021, and later is returned by this API.
     */
    override suspend fun describeContact(input: DescribeContactRequest): DescribeContactResponse {
        val op = SdkHttpOperation.build<DescribeContactRequest, DescribeContactResponse> {
            serializer = DescribeContactOperationSerializer()
            deserializer = DescribeContactOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeContact"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeContact-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Describes the specified flow.
     *
     * You can also create and update flows using the [Amazon Connect Flow language](https://docs.aws.amazon.com/connect/latest/APIReference/flow-language.html).
     */
    override suspend fun describeContactFlow(input: DescribeContactFlowRequest): DescribeContactFlowResponse {
        val op = SdkHttpOperation.build<DescribeContactFlowRequest, DescribeContactFlowResponse> {
            serializer = DescribeContactFlowOperationSerializer()
            deserializer = DescribeContactFlowOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeContactFlow"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeContactFlow-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Describes the specified flow module.
     */
    override suspend fun describeContactFlowModule(input: DescribeContactFlowModuleRequest): DescribeContactFlowModuleResponse {
        val op = SdkHttpOperation.build<DescribeContactFlowModuleRequest, DescribeContactFlowModuleResponse> {
            serializer = DescribeContactFlowModuleOperationSerializer()
            deserializer = DescribeContactFlowModuleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeContactFlowModule"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeContactFlowModule-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Describes the hours of operation.
     */
    override suspend fun describeHoursOfOperation(input: DescribeHoursOfOperationRequest): DescribeHoursOfOperationResponse {
        val op = SdkHttpOperation.build<DescribeHoursOfOperationRequest, DescribeHoursOfOperationResponse> {
            serializer = DescribeHoursOfOperationOperationSerializer()
            deserializer = DescribeHoursOfOperationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeHoursOfOperation"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeHoursOfOperation-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Returns the current state of the specified instance identifier. It tracks the instance while it is being created and returns an error status, if applicable.
     *
     * If an instance is not created successfully, the instance status reason field returns details relevant to the reason. The instance in a failed state is returned only for 24 hours after the CreateInstance API was invoked.
     */
    override suspend fun describeInstance(input: DescribeInstanceRequest): DescribeInstanceResponse {
        val op = SdkHttpOperation.build<DescribeInstanceRequest, DescribeInstanceResponse> {
            serializer = DescribeInstanceOperationSerializer()
            deserializer = DescribeInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeInstance"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeInstance-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Describes the specified instance attribute.
     */
    override suspend fun describeInstanceAttribute(input: DescribeInstanceAttributeRequest): DescribeInstanceAttributeResponse {
        val op = SdkHttpOperation.build<DescribeInstanceAttributeRequest, DescribeInstanceAttributeResponse> {
            serializer = DescribeInstanceAttributeOperationSerializer()
            deserializer = DescribeInstanceAttributeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeInstanceAttribute"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeInstanceAttribute-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Retrieves the current storage configurations for the specified resource type, association ID, and instance ID.
     */
    override suspend fun describeInstanceStorageConfig(input: DescribeInstanceStorageConfigRequest): DescribeInstanceStorageConfigResponse {
        val op = SdkHttpOperation.build<DescribeInstanceStorageConfigRequest, DescribeInstanceStorageConfigResponse> {
            serializer = DescribeInstanceStorageConfigOperationSerializer()
            deserializer = DescribeInstanceStorageConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeInstanceStorageConfig"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeInstanceStorageConfig-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets details and status of a phone number that’s claimed to your Amazon Connect instance or traffic distribution group.
     *
     * If the number is claimed to a traffic distribution group, and you are calling in the Amazon Web Services Region where the traffic distribution group was created, you can use either a phone number ARN or UUID value for the `PhoneNumberId` URI request parameter. However, if the number is claimed to a traffic distribution group and you are calling this API in the alternate Amazon Web Services Region associated with the traffic distribution group, you must provide a full phone number ARN. If a UUID is provided in this scenario, you will receive a `ResourceNotFoundException`.
     */
    override suspend fun describePhoneNumber(input: DescribePhoneNumberRequest): DescribePhoneNumberResponse {
        val op = SdkHttpOperation.build<DescribePhoneNumberRequest, DescribePhoneNumberResponse> {
            serializer = DescribePhoneNumberOperationSerializer()
            deserializer = DescribePhoneNumberOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribePhoneNumber"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribePhoneNumber-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Describes the specified queue.
     */
    override suspend fun describeQueue(input: DescribeQueueRequest): DescribeQueueResponse {
        val op = SdkHttpOperation.build<DescribeQueueRequest, DescribeQueueResponse> {
            serializer = DescribeQueueOperationSerializer()
            deserializer = DescribeQueueOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeQueue"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeQueue-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Describes the quick connect.
     */
    override suspend fun describeQuickConnect(input: DescribeQuickConnectRequest): DescribeQuickConnectResponse {
        val op = SdkHttpOperation.build<DescribeQuickConnectRequest, DescribeQuickConnectResponse> {
            serializer = DescribeQuickConnectOperationSerializer()
            deserializer = DescribeQuickConnectOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeQuickConnect"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeQuickConnect-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Describes the specified routing profile.
     */
    override suspend fun describeRoutingProfile(input: DescribeRoutingProfileRequest): DescribeRoutingProfileResponse {
        val op = SdkHttpOperation.build<DescribeRoutingProfileRequest, DescribeRoutingProfileResponse> {
            serializer = DescribeRoutingProfileOperationSerializer()
            deserializer = DescribeRoutingProfileOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeRoutingProfile"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeRoutingProfile-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Describes a rule for the specified Amazon Connect instance.
     */
    override suspend fun describeRule(input: DescribeRuleRequest): DescribeRuleResponse {
        val op = SdkHttpOperation.build<DescribeRuleRequest, DescribeRuleResponse> {
            serializer = DescribeRuleOperationSerializer()
            deserializer = DescribeRuleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeRule"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeRule-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Gets basic information about the security profle.
     */
    override suspend fun describeSecurityProfile(input: DescribeSecurityProfileRequest): DescribeSecurityProfileResponse {
        val op = SdkHttpOperation.build<DescribeSecurityProfileRequest, DescribeSecurityProfileResponse> {
            serializer = DescribeSecurityProfileOperationSerializer()
            deserializer = DescribeSecurityProfileOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeSecurityProfile"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeSecurityProfile-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets details and status of a traffic distribution group.
     */
    override suspend fun describeTrafficDistributionGroup(input: DescribeTrafficDistributionGroupRequest): DescribeTrafficDistributionGroupResponse {
        val op = SdkHttpOperation.build<DescribeTrafficDistributionGroupRequest, DescribeTrafficDistributionGroupResponse> {
            serializer = DescribeTrafficDistributionGroupOperationSerializer()
            deserializer = DescribeTrafficDistributionGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeTrafficDistributionGroup"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeTrafficDistributionGroup-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Describes the specified user account. You can [find the instance ID in the Amazon Connect console](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html) (it’s the final part of the ARN). The console does not display the user IDs. Instead, list the users and note the IDs provided in the output.
     */
    override suspend fun describeUser(input: DescribeUserRequest): DescribeUserResponse {
        val op = SdkHttpOperation.build<DescribeUserRequest, DescribeUserResponse> {
            serializer = DescribeUserOperationSerializer()
            deserializer = DescribeUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeUser"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeUser-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Describes the specified hierarchy group.
     */
    override suspend fun describeUserHierarchyGroup(input: DescribeUserHierarchyGroupRequest): DescribeUserHierarchyGroupResponse {
        val op = SdkHttpOperation.build<DescribeUserHierarchyGroupRequest, DescribeUserHierarchyGroupResponse> {
            serializer = DescribeUserHierarchyGroupOperationSerializer()
            deserializer = DescribeUserHierarchyGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeUserHierarchyGroup"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeUserHierarchyGroup-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Describes the hierarchy structure of the specified Amazon Connect instance.
     */
    override suspend fun describeUserHierarchyStructure(input: DescribeUserHierarchyStructureRequest): DescribeUserHierarchyStructureResponse {
        val op = SdkHttpOperation.build<DescribeUserHierarchyStructureRequest, DescribeUserHierarchyStructureResponse> {
            serializer = DescribeUserHierarchyStructureOperationSerializer()
            deserializer = DescribeUserHierarchyStructureOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeUserHierarchyStructure"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeUserHierarchyStructure-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Describes the specified vocabulary.
     */
    override suspend fun describeVocabulary(input: DescribeVocabularyRequest): DescribeVocabularyResponse {
        val op = SdkHttpOperation.build<DescribeVocabularyRequest, DescribeVocabularyResponse> {
            serializer = DescribeVocabularyOperationSerializer()
            deserializer = DescribeVocabularyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeVocabulary"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeVocabulary-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Revokes access to integrated applications from Amazon Connect.
     */
    override suspend fun disassociateApprovedOrigin(input: DisassociateApprovedOriginRequest): DisassociateApprovedOriginResponse {
        val op = SdkHttpOperation.build<DisassociateApprovedOriginRequest, DisassociateApprovedOriginResponse> {
            serializer = DisassociateApprovedOriginOperationSerializer()
            deserializer = DisassociateApprovedOriginOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DisassociateApprovedOrigin"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DisassociateApprovedOrigin-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Revokes authorization from the specified instance to access the specified Amazon Lex or Amazon Lex V2 bot.
     */
    override suspend fun disassociateBot(input: DisassociateBotRequest): DisassociateBotResponse {
        val op = SdkHttpOperation.build<DisassociateBotRequest, DisassociateBotResponse> {
            serializer = DisassociateBotOperationSerializer()
            deserializer = DisassociateBotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DisassociateBot"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DisassociateBot-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Removes the storage type configurations for the specified resource type and association ID.
     */
    override suspend fun disassociateInstanceStorageConfig(input: DisassociateInstanceStorageConfigRequest): DisassociateInstanceStorageConfigResponse {
        val op = SdkHttpOperation.build<DisassociateInstanceStorageConfigRequest, DisassociateInstanceStorageConfigResponse> {
            serializer = DisassociateInstanceStorageConfigOperationSerializer()
            deserializer = DisassociateInstanceStorageConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DisassociateInstanceStorageConfig"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DisassociateInstanceStorageConfig-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Remove the Lambda function from the dropdown options available in the relevant flow blocks.
     */
    override suspend fun disassociateLambdaFunction(input: DisassociateLambdaFunctionRequest): DisassociateLambdaFunctionResponse {
        val op = SdkHttpOperation.build<DisassociateLambdaFunctionRequest, DisassociateLambdaFunctionResponse> {
            serializer = DisassociateLambdaFunctionOperationSerializer()
            deserializer = DisassociateLambdaFunctionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DisassociateLambdaFunction"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DisassociateLambdaFunction-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Revokes authorization from the specified instance to access the specified Amazon Lex bot.
     */
    override suspend fun disassociateLexBot(input: DisassociateLexBotRequest): DisassociateLexBotResponse {
        val op = SdkHttpOperation.build<DisassociateLexBotRequest, DisassociateLexBotResponse> {
            serializer = DisassociateLexBotOperationSerializer()
            deserializer = DisassociateLexBotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DisassociateLexBot"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DisassociateLexBot-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Removes the flow association from a phone number claimed to your Amazon Connect instance.
     *
     * If the number is claimed to a traffic distribution group, and you are calling this API using an instance in the Amazon Web Services Region where the traffic distribution group was created, you can use either a full phone number ARN or UUID value for the `PhoneNumberId` URI request parameter. However, if the number is claimed to a traffic distribution group and you are calling this API using an instance in the alternate Amazon Web Services Region associated with the traffic distribution group, you must provide a full phone number ARN. If a UUID is provided in this scenario, you will receive a `ResourceNotFoundException`.
     */
    override suspend fun disassociatePhoneNumberContactFlow(input: DisassociatePhoneNumberContactFlowRequest): DisassociatePhoneNumberContactFlowResponse {
        val op = SdkHttpOperation.build<DisassociatePhoneNumberContactFlowRequest, DisassociatePhoneNumberContactFlowResponse> {
            serializer = DisassociatePhoneNumberContactFlowOperationSerializer()
            deserializer = DisassociatePhoneNumberContactFlowOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DisassociatePhoneNumberContactFlow"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DisassociatePhoneNumberContactFlow-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Disassociates a set of quick connects from a queue.
     */
    override suspend fun disassociateQueueQuickConnects(input: DisassociateQueueQuickConnectsRequest): DisassociateQueueQuickConnectsResponse {
        val op = SdkHttpOperation.build<DisassociateQueueQuickConnectsRequest, DisassociateQueueQuickConnectsResponse> {
            serializer = DisassociateQueueQuickConnectsOperationSerializer()
            deserializer = DisassociateQueueQuickConnectsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DisassociateQueueQuickConnects"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DisassociateQueueQuickConnects-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Disassociates a set of queues from a routing profile.
     */
    override suspend fun disassociateRoutingProfileQueues(input: DisassociateRoutingProfileQueuesRequest): DisassociateRoutingProfileQueuesResponse {
        val op = SdkHttpOperation.build<DisassociateRoutingProfileQueuesRequest, DisassociateRoutingProfileQueuesResponse> {
            serializer = DisassociateRoutingProfileQueuesOperationSerializer()
            deserializer = DisassociateRoutingProfileQueuesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DisassociateRoutingProfileQueues"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DisassociateRoutingProfileQueues-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Deletes the specified security key.
     */
    override suspend fun disassociateSecurityKey(input: DisassociateSecurityKeyRequest): DisassociateSecurityKeyResponse {
        val op = SdkHttpOperation.build<DisassociateSecurityKeyRequest, DisassociateSecurityKeyResponse> {
            serializer = DisassociateSecurityKeyOperationSerializer()
            deserializer = DisassociateSecurityKeyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DisassociateSecurityKey"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DisassociateSecurityKey-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Dismisses contacts from an agent’s CCP and returns the agent to an available state, which allows the agent to receive a new routed contact. Contacts can only be dismissed if they are in a `MISSED`, `ERROR`, `ENDED`, or `REJECTED` state in the [Agent Event Stream](https://docs.aws.amazon.com/connect/latest/adminguide/about-contact-states.html).
     */
    override suspend fun dismissUserContact(input: DismissUserContactRequest): DismissUserContactResponse {
        val op = SdkHttpOperation.build<DismissUserContactRequest, DismissUserContactResponse> {
            serializer = DismissUserContactOperationSerializer()
            deserializer = DismissUserContactOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DismissUserContact"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DismissUserContact-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves the contact attributes for the specified contact.
     */
    override suspend fun getContactAttributes(input: GetContactAttributesRequest): GetContactAttributesResponse {
        val op = SdkHttpOperation.build<GetContactAttributesRequest, GetContactAttributesResponse> {
            serializer = GetContactAttributesOperationSerializer()
            deserializer = GetContactAttributesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetContactAttributes"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetContactAttributes-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets the real-time metric data from the specified Amazon Connect instance.
     *
     * For a description of each metric, see [Real-time Metrics Definitions](https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html) in the *Amazon Connect Administrator Guide*.
     */
    override suspend fun getCurrentMetricData(input: GetCurrentMetricDataRequest): GetCurrentMetricDataResponse {
        val op = SdkHttpOperation.build<GetCurrentMetricDataRequest, GetCurrentMetricDataResponse> {
            serializer = GetCurrentMetricDataOperationSerializer()
            deserializer = GetCurrentMetricDataOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetCurrentMetricData"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetCurrentMetricData-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets the real-time active user data from the specified Amazon Connect instance.
     */
    override suspend fun getCurrentUserData(input: GetCurrentUserDataRequest): GetCurrentUserDataResponse {
        val op = SdkHttpOperation.build<GetCurrentUserDataRequest, GetCurrentUserDataResponse> {
            serializer = GetCurrentUserDataOperationSerializer()
            deserializer = GetCurrentUserDataOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetCurrentUserData"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetCurrentUserData-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves a token for federation.
     *
     * This API doesn't support root users. If you try to invoke GetFederationToken with root credentials, an error message similar to the following one appears:
     *
     * `Provided identity: Principal: .... User: .... cannot be used for federation with Amazon Connect`
     */
    override suspend fun getFederationToken(input: GetFederationTokenRequest): GetFederationTokenResponse {
        val op = SdkHttpOperation.build<GetFederationTokenRequest, GetFederationTokenResponse> {
            serializer = GetFederationTokenOperationSerializer()
            deserializer = GetFederationTokenOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetFederationToken"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetFederationToken-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets historical metric data from the specified Amazon Connect instance.
     *
     * For a description of each historical metric, see [Historical Metrics Definitions](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html) in the *Amazon Connect Administrator Guide*.
     */
    override suspend fun getMetricData(input: GetMetricDataRequest): GetMetricDataResponse {
        val op = SdkHttpOperation.build<GetMetricDataRequest, GetMetricDataResponse> {
            serializer = GetMetricDataOperationSerializer()
            deserializer = GetMetricDataOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetMetricData"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetMetricData-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets metric data from the specified Amazon Connect instance.
     *
     * `GetMetricDataV2` offers more features than [GetMetricData](https://docs.aws.amazon.com/connect/latest/APIReference/API_GetMetricData.html), the previous version of this API. It has new metrics, offers filtering at a metric level, and offers the ability to filter and group data by channels, queues, routing profiles, agents, and agent hierarchy levels. It can retrieve historical data for the last 14 days, in 24-hour intervals.
     *
     * For a description of the historical metrics that are supported by `GetMetricDataV2` and `GetMetricData`, see [Historical metrics definitions](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html) in the *Amazon Connect Administrator's Guide*.
     *
     * This API is not available in the Amazon Web Services GovCloud (US) Regions.
     */
    override suspend fun getMetricDataV2(input: GetMetricDataV2Request): GetMetricDataV2Response {
        val op = SdkHttpOperation.build<GetMetricDataV2Request, GetMetricDataV2Response> {
            serializer = GetMetricDataV2OperationSerializer()
            deserializer = GetMetricDataV2OperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetMetricDataV2"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetMetricDataV2-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets details about a specific task template in the specified Amazon Connect instance.
     */
    override suspend fun getTaskTemplate(input: GetTaskTemplateRequest): GetTaskTemplateResponse {
        val op = SdkHttpOperation.build<GetTaskTemplateRequest, GetTaskTemplateResponse> {
            serializer = GetTaskTemplateOperationSerializer()
            deserializer = GetTaskTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetTaskTemplate"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetTaskTemplate-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves the current traffic distribution for a given traffic distribution group.
     */
    override suspend fun getTrafficDistribution(input: GetTrafficDistributionRequest): GetTrafficDistributionResponse {
        val op = SdkHttpOperation.build<GetTrafficDistributionRequest, GetTrafficDistributionResponse> {
            serializer = GetTrafficDistributionOperationSerializer()
            deserializer = GetTrafficDistributionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetTrafficDistribution"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetTrafficDistribution-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Lists agent statuses.
     */
    override suspend fun listAgentStatuses(input: ListAgentStatusesRequest): ListAgentStatusesResponse {
        val op = SdkHttpOperation.build<ListAgentStatusesRequest, ListAgentStatusesResponse> {
            serializer = ListAgentStatusesOperationSerializer()
            deserializer = ListAgentStatusesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListAgentStatuses"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListAgentStatuses-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Returns a paginated list of all approved origins associated with the instance.
     */
    override suspend fun listApprovedOrigins(input: ListApprovedOriginsRequest): ListApprovedOriginsResponse {
        val op = SdkHttpOperation.build<ListApprovedOriginsRequest, ListApprovedOriginsResponse> {
            serializer = ListApprovedOriginsOperationSerializer()
            deserializer = ListApprovedOriginsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListApprovedOrigins"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListApprovedOrigins-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * For the specified version of Amazon Lex, returns a paginated list of all the Amazon Lex bots currently associated with the instance. Use this API to returns both Amazon Lex V1 and V2 bots.
     */
    override suspend fun listBots(input: ListBotsRequest): ListBotsResponse {
        val op = SdkHttpOperation.build<ListBotsRequest, ListBotsResponse> {
            serializer = ListBotsOperationSerializer()
            deserializer = ListBotsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListBots"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListBots-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Provides information about the flow modules for the specified Amazon Connect instance.
     */
    override suspend fun listContactFlowModules(input: ListContactFlowModulesRequest): ListContactFlowModulesResponse {
        val op = SdkHttpOperation.build<ListContactFlowModulesRequest, ListContactFlowModulesResponse> {
            serializer = ListContactFlowModulesOperationSerializer()
            deserializer = ListContactFlowModulesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListContactFlowModules"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListContactFlowModules-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Provides information about the flows for the specified Amazon Connect instance.
     *
     * You can also create and update flows using the [Amazon Connect Flow language](https://docs.aws.amazon.com/connect/latest/APIReference/flow-language.html).
     *
     * For more information about flows, see [Flows](https://docs.aws.amazon.com/connect/latest/adminguide/concepts-contact-flows.html) in the *Amazon Connect Administrator Guide*.
     */
    override suspend fun listContactFlows(input: ListContactFlowsRequest): ListContactFlowsResponse {
        val op = SdkHttpOperation.build<ListContactFlowsRequest, ListContactFlowsResponse> {
            serializer = ListContactFlowsOperationSerializer()
            deserializer = ListContactFlowsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListContactFlows"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListContactFlows-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * For the specified `referenceTypes`, returns a list of references associated with the contact.
     */
    override suspend fun listContactReferences(input: ListContactReferencesRequest): ListContactReferencesResponse {
        val op = SdkHttpOperation.build<ListContactReferencesRequest, ListContactReferencesResponse> {
            serializer = ListContactReferencesOperationSerializer()
            deserializer = ListContactReferencesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListContactReferences"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListContactReferences-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists the default vocabularies for the specified Amazon Connect instance.
     */
    override suspend fun listDefaultVocabularies(input: ListDefaultVocabulariesRequest): ListDefaultVocabulariesResponse {
        val op = SdkHttpOperation.build<ListDefaultVocabulariesRequest, ListDefaultVocabulariesResponse> {
            serializer = ListDefaultVocabulariesOperationSerializer()
            deserializer = ListDefaultVocabulariesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListDefaultVocabularies"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListDefaultVocabularies-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Provides information about the hours of operation for the specified Amazon Connect instance.
     *
     * For more information about hours of operation, see [Set the Hours of Operation for a Queue](https://docs.aws.amazon.com/connect/latest/adminguide/set-hours-operation.html) in the *Amazon Connect Administrator Guide*.
     */
    override suspend fun listHoursOfOperations(input: ListHoursOfOperationsRequest): ListHoursOfOperationsResponse {
        val op = SdkHttpOperation.build<ListHoursOfOperationsRequest, ListHoursOfOperationsResponse> {
            serializer = ListHoursOfOperationsOperationSerializer()
            deserializer = ListHoursOfOperationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListHoursOfOperations"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListHoursOfOperations-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Returns a paginated list of all attribute types for the given instance.
     */
    override suspend fun listInstanceAttributes(input: ListInstanceAttributesRequest): ListInstanceAttributesResponse {
        val op = SdkHttpOperation.build<ListInstanceAttributesRequest, ListInstanceAttributesResponse> {
            serializer = ListInstanceAttributesOperationSerializer()
            deserializer = ListInstanceAttributesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListInstanceAttributes"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListInstanceAttributes-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Returns a paginated list of storage configs for the identified instance and resource type.
     */
    override suspend fun listInstanceStorageConfigs(input: ListInstanceStorageConfigsRequest): ListInstanceStorageConfigsResponse {
        val op = SdkHttpOperation.build<ListInstanceStorageConfigsRequest, ListInstanceStorageConfigsResponse> {
            serializer = ListInstanceStorageConfigsOperationSerializer()
            deserializer = ListInstanceStorageConfigsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListInstanceStorageConfigs"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListInstanceStorageConfigs-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Return a list of instances which are in active state, creation-in-progress state, and failed state. Instances that aren't successfully created (they are in a failed state) are returned only for 24 hours after the CreateInstance API was invoked.
     */
    override suspend fun listInstances(input: ListInstancesRequest): ListInstancesResponse {
        val op = SdkHttpOperation.build<ListInstancesRequest, ListInstancesResponse> {
            serializer = ListInstancesOperationSerializer()
            deserializer = ListInstancesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListInstances"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListInstances-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Provides summary information about the Amazon Web Services resource associations for the specified Amazon Connect instance.
     */
    override suspend fun listIntegrationAssociations(input: ListIntegrationAssociationsRequest): ListIntegrationAssociationsResponse {
        val op = SdkHttpOperation.build<ListIntegrationAssociationsRequest, ListIntegrationAssociationsResponse> {
            serializer = ListIntegrationAssociationsOperationSerializer()
            deserializer = ListIntegrationAssociationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListIntegrationAssociations"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListIntegrationAssociations-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Returns a paginated list of all Lambda functions that display in the dropdown options in the relevant flow blocks.
     */
    override suspend fun listLambdaFunctions(input: ListLambdaFunctionsRequest): ListLambdaFunctionsResponse {
        val op = SdkHttpOperation.build<ListLambdaFunctionsRequest, ListLambdaFunctionsResponse> {
            serializer = ListLambdaFunctionsOperationSerializer()
            deserializer = ListLambdaFunctionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListLambdaFunctions"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListLambdaFunctions-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Returns a paginated list of all the Amazon Lex V1 bots currently associated with the instance. To return both Amazon Lex V1 and V2 bots, use the [ListBots](https://docs.aws.amazon.com/connect/latest/APIReference/API_ListBots.html) API.
     */
    override suspend fun listLexBots(input: ListLexBotsRequest): ListLexBotsResponse {
        val op = SdkHttpOperation.build<ListLexBotsRequest, ListLexBotsResponse> {
            serializer = ListLexBotsOperationSerializer()
            deserializer = ListLexBotsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListLexBots"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListLexBots-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Provides information about the phone numbers for the specified Amazon Connect instance.
     *
     * For more information about phone numbers, see [Set Up Phone Numbers for Your Contact Center](https://docs.aws.amazon.com/connect/latest/adminguide/contact-center-phone-number.html) in the *Amazon Connect Administrator Guide*.
     *
     * The phone number `Arn` value that is returned from each of the items in the [PhoneNumberSummaryList](https://docs.aws.amazon.com/connect/latest/APIReference/API_ListPhoneNumbers.html#connect-ListPhoneNumbers-response-PhoneNumberSummaryList) cannot be used to tag phone number resources. It will fail with a `ResourceNotFoundException`. Instead, use the [ListPhoneNumbersV2](https://docs.aws.amazon.com/connect/latest/APIReference/API_ListPhoneNumbersV2.html) API. It returns the new phone number ARN that can be used to tag phone number resources.
     */
    override suspend fun listPhoneNumbers(input: ListPhoneNumbersRequest): ListPhoneNumbersResponse {
        val op = SdkHttpOperation.build<ListPhoneNumbersRequest, ListPhoneNumbersResponse> {
            serializer = ListPhoneNumbersOperationSerializer()
            deserializer = ListPhoneNumbersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListPhoneNumbers"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListPhoneNumbers-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists phone numbers claimed to your Amazon Connect instance or traffic distribution group. If the provided `TargetArn` is a traffic distribution group, you can call this API in both Amazon Web Services Regions associated with traffic distribution group.
     *
     * For more information about phone numbers, see [Set Up Phone Numbers for Your Contact Center](https://docs.aws.amazon.com/connect/latest/adminguide/contact-center-phone-number.html) in the *Amazon Connect Administrator Guide*.
     */
    override suspend fun listPhoneNumbersV2(input: ListPhoneNumbersV2Request): ListPhoneNumbersV2Response {
        val op = SdkHttpOperation.build<ListPhoneNumbersV2Request, ListPhoneNumbersV2Response> {
            serializer = ListPhoneNumbersV2OperationSerializer()
            deserializer = ListPhoneNumbersV2OperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListPhoneNumbersV2"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListPhoneNumbersV2-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Provides information about the prompts for the specified Amazon Connect instance.
     */
    override suspend fun listPrompts(input: ListPromptsRequest): ListPromptsResponse {
        val op = SdkHttpOperation.build<ListPromptsRequest, ListPromptsResponse> {
            serializer = ListPromptsOperationSerializer()
            deserializer = ListPromptsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListPrompts"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListPrompts-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Lists the quick connects associated with a queue.
     */
    override suspend fun listQueueQuickConnects(input: ListQueueQuickConnectsRequest): ListQueueQuickConnectsResponse {
        val op = SdkHttpOperation.build<ListQueueQuickConnectsRequest, ListQueueQuickConnectsResponse> {
            serializer = ListQueueQuickConnectsOperationSerializer()
            deserializer = ListQueueQuickConnectsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListQueueQuickConnects"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListQueueQuickConnects-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Provides information about the queues for the specified Amazon Connect instance.
     *
     * If you do not specify a `QueueTypes` parameter, both standard and agent queues are returned. This might cause an unexpected truncation of results if you have more than 1000 agents and you limit the number of results of the API call in code.
     *
     * For more information about queues, see [Queues: Standard and Agent](https://docs.aws.amazon.com/connect/latest/adminguide/concepts-queues-standard-and-agent.html) in the *Amazon Connect Administrator Guide*.
     */
    override suspend fun listQueues(input: ListQueuesRequest): ListQueuesResponse {
        val op = SdkHttpOperation.build<ListQueuesRequest, ListQueuesResponse> {
            serializer = ListQueuesOperationSerializer()
            deserializer = ListQueuesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListQueues"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListQueues-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Provides information about the quick connects for the specified Amazon Connect instance.
     */
    override suspend fun listQuickConnects(input: ListQuickConnectsRequest): ListQuickConnectsResponse {
        val op = SdkHttpOperation.build<ListQuickConnectsRequest, ListQuickConnectsResponse> {
            serializer = ListQuickConnectsOperationSerializer()
            deserializer = ListQuickConnectsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListQuickConnects"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListQuickConnects-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists the queues associated with a routing profile.
     */
    override suspend fun listRoutingProfileQueues(input: ListRoutingProfileQueuesRequest): ListRoutingProfileQueuesResponse {
        val op = SdkHttpOperation.build<ListRoutingProfileQueuesRequest, ListRoutingProfileQueuesResponse> {
            serializer = ListRoutingProfileQueuesOperationSerializer()
            deserializer = ListRoutingProfileQueuesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListRoutingProfileQueues"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListRoutingProfileQueues-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Provides summary information about the routing profiles for the specified Amazon Connect instance.
     *
     * For more information about routing profiles, see [Routing Profiles](https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing.html) and [Create a Routing Profile](https://docs.aws.amazon.com/connect/latest/adminguide/routing-profiles.html) in the *Amazon Connect Administrator Guide*.
     */
    override suspend fun listRoutingProfiles(input: ListRoutingProfilesRequest): ListRoutingProfilesResponse {
        val op = SdkHttpOperation.build<ListRoutingProfilesRequest, ListRoutingProfilesResponse> {
            serializer = ListRoutingProfilesOperationSerializer()
            deserializer = ListRoutingProfilesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListRoutingProfiles"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListRoutingProfiles-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * List all rules for the specified Amazon Connect instance.
     */
    override suspend fun listRules(input: ListRulesRequest): ListRulesResponse {
        val op = SdkHttpOperation.build<ListRulesRequest, ListRulesResponse> {
            serializer = ListRulesOperationSerializer()
            deserializer = ListRulesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListRules"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListRules-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Returns a paginated list of all security keys associated with the instance.
     */
    override suspend fun listSecurityKeys(input: ListSecurityKeysRequest): ListSecurityKeysResponse {
        val op = SdkHttpOperation.build<ListSecurityKeysRequest, ListSecurityKeysResponse> {
            serializer = ListSecurityKeysOperationSerializer()
            deserializer = ListSecurityKeysOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListSecurityKeys"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListSecurityKeys-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Lists the permissions granted to a security profile.
     */
    override suspend fun listSecurityProfilePermissions(input: ListSecurityProfilePermissionsRequest): ListSecurityProfilePermissionsResponse {
        val op = SdkHttpOperation.build<ListSecurityProfilePermissionsRequest, ListSecurityProfilePermissionsResponse> {
            serializer = ListSecurityProfilePermissionsOperationSerializer()
            deserializer = ListSecurityProfilePermissionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListSecurityProfilePermissions"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListSecurityProfilePermissions-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Provides summary information about the security profiles for the specified Amazon Connect instance.
     *
     * For more information about security profiles, see [Security Profiles](https://docs.aws.amazon.com/connect/latest/adminguide/connect-security-profiles.html) in the *Amazon Connect Administrator Guide*.
     */
    override suspend fun listSecurityProfiles(input: ListSecurityProfilesRequest): ListSecurityProfilesResponse {
        val op = SdkHttpOperation.build<ListSecurityProfilesRequest, ListSecurityProfilesResponse> {
            serializer = ListSecurityProfilesOperationSerializer()
            deserializer = ListSecurityProfilesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListSecurityProfiles"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListSecurityProfiles-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists the tags for the specified resource.
     *
     * For sample policies that use tags, see [Amazon Connect Identity-Based Policy Examples](https://docs.aws.amazon.com/connect/latest/adminguide/security_iam_id-based-policy-examples.html) in the *Amazon Connect Administrator Guide*.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListTagsForResource"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListTagsForResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists task templates for the specified Amazon Connect instance.
     */
    override suspend fun listTaskTemplates(input: ListTaskTemplatesRequest): ListTaskTemplatesResponse {
        val op = SdkHttpOperation.build<ListTaskTemplatesRequest, ListTaskTemplatesResponse> {
            serializer = ListTaskTemplatesOperationSerializer()
            deserializer = ListTaskTemplatesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListTaskTemplates"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListTaskTemplates-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists traffic distribution groups.
     */
    override suspend fun listTrafficDistributionGroups(input: ListTrafficDistributionGroupsRequest): ListTrafficDistributionGroupsResponse {
        val op = SdkHttpOperation.build<ListTrafficDistributionGroupsRequest, ListTrafficDistributionGroupsResponse> {
            serializer = ListTrafficDistributionGroupsOperationSerializer()
            deserializer = ListTrafficDistributionGroupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListTrafficDistributionGroups"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListTrafficDistributionGroups-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists the use cases for the integration association.
     */
    override suspend fun listUseCases(input: ListUseCasesRequest): ListUseCasesResponse {
        val op = SdkHttpOperation.build<ListUseCasesRequest, ListUseCasesResponse> {
            serializer = ListUseCasesOperationSerializer()
            deserializer = ListUseCasesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListUseCases"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListUseCases-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Provides summary information about the hierarchy groups for the specified Amazon Connect instance.
     *
     * For more information about agent hierarchies, see [Set Up Agent Hierarchies](https://docs.aws.amazon.com/connect/latest/adminguide/agent-hierarchy.html) in the *Amazon Connect Administrator Guide*.
     */
    override suspend fun listUserHierarchyGroups(input: ListUserHierarchyGroupsRequest): ListUserHierarchyGroupsResponse {
        val op = SdkHttpOperation.build<ListUserHierarchyGroupsRequest, ListUserHierarchyGroupsResponse> {
            serializer = ListUserHierarchyGroupsOperationSerializer()
            deserializer = ListUserHierarchyGroupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListUserHierarchyGroups"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListUserHierarchyGroups-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Provides summary information about the users for the specified Amazon Connect instance.
     */
    override suspend fun listUsers(input: ListUsersRequest): ListUsersResponse {
        val op = SdkHttpOperation.build<ListUsersRequest, ListUsersResponse> {
            serializer = ListUsersOperationSerializer()
            deserializer = ListUsersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListUsers"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListUsers-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Initiates silent monitoring of a contact. The Contact Control Panel (CCP) of the user specified by *userId* will be set to silent monitoring mode on the contact.
     */
    override suspend fun monitorContact(input: MonitorContactRequest): MonitorContactResponse {
        val op = SdkHttpOperation.build<MonitorContactRequest, MonitorContactResponse> {
            serializer = MonitorContactOperationSerializer()
            deserializer = MonitorContactOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "MonitorContact"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("MonitorContact-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Changes the current status of a user or agent in Amazon Connect. If the agent is currently handling a contact, this sets the agent's next status.
     *
     * For more information, see [Agent status](https://docs.aws.amazon.com/connect/latest/adminguide/metrics-agent-status.html) and [Set your next status](https://docs.aws.amazon.com/connect/latest/adminguide/set-next-status.html) in the *Amazon Connect Administrator Guide*.
     */
    override suspend fun putUserStatus(input: PutUserStatusRequest): PutUserStatusResponse {
        val op = SdkHttpOperation.build<PutUserStatusRequest, PutUserStatusResponse> {
            serializer = PutUserStatusOperationSerializer()
            deserializer = PutUserStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "PutUserStatus"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("PutUserStatus-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Releases a phone number previously claimed to an Amazon Connect instance or traffic distribution group. You can call this API only in the Amazon Web Services Region where the number was claimed.
     *
     * To release phone numbers from a traffic distribution group, use the `ReleasePhoneNumber` API, not the Amazon Connect console.
     *
     * After releasing a phone number, the phone number enters into a cooldown period of 30 days. It cannot be searched for or claimed again until the period has ended. If you accidentally release a phone number, contact Amazon Web Services Support.
     */
    override suspend fun releasePhoneNumber(input: ReleasePhoneNumberRequest): ReleasePhoneNumberResponse {
        val op = SdkHttpOperation.build<ReleasePhoneNumberRequest, ReleasePhoneNumberResponse> {
            serializer = ReleasePhoneNumberOperationSerializer()
            deserializer = ReleasePhoneNumberOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ReleasePhoneNumber"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ReleasePhoneNumber-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Replicates an Amazon Connect instance in the specified Amazon Web Services Region.
     *
     * For more information about replicating an Amazon Connect instance, see [Create a replica of your existing Amazon Connect instance](https://docs.aws.amazon.com/connect/latest/adminguide/create-replica-connect-instance.html) in the *Amazon Connect Administrator Guide*.
     */
    override suspend fun replicateInstance(input: ReplicateInstanceRequest): ReplicateInstanceResponse {
        val op = SdkHttpOperation.build<ReplicateInstanceRequest, ReplicateInstanceResponse> {
            serializer = ReplicateInstanceOperationSerializer()
            deserializer = ReplicateInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ReplicateInstance"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ReplicateInstance-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * When a contact is being recorded, and the recording has been suspended using SuspendContactRecording, this API resumes recording the call.
     *
     * Only voice recordings are supported at this time.
     */
    override suspend fun resumeContactRecording(input: ResumeContactRecordingRequest): ResumeContactRecordingResponse {
        val op = SdkHttpOperation.build<ResumeContactRecordingRequest, ResumeContactRecordingResponse> {
            serializer = ResumeContactRecordingOperationSerializer()
            deserializer = ResumeContactRecordingOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ResumeContactRecording"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ResumeContactRecording-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Searches for available phone numbers that you can claim to your Amazon Connect instance or traffic distribution group. If the provided `TargetArn` is a traffic distribution group, you can call this API in both Amazon Web Services Regions associated with the traffic distribution group.
     */
    override suspend fun searchAvailablePhoneNumbers(input: SearchAvailablePhoneNumbersRequest): SearchAvailablePhoneNumbersResponse {
        val op = SdkHttpOperation.build<SearchAvailablePhoneNumbersRequest, SearchAvailablePhoneNumbersResponse> {
            serializer = SearchAvailablePhoneNumbersOperationSerializer()
            deserializer = SearchAvailablePhoneNumbersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "SearchAvailablePhoneNumbers"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("SearchAvailablePhoneNumbers-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Searches queues in an Amazon Connect instance, with optional filtering.
     */
    override suspend fun searchQueues(input: SearchQueuesRequest): SearchQueuesResponse {
        val op = SdkHttpOperation.build<SearchQueuesRequest, SearchQueuesResponse> {
            serializer = SearchQueuesOperationSerializer()
            deserializer = SearchQueuesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "SearchQueues"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("SearchQueues-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Searches routing profiles in an Amazon Connect instance, with optional filtering.
     */
    override suspend fun searchRoutingProfiles(input: SearchRoutingProfilesRequest): SearchRoutingProfilesResponse {
        val op = SdkHttpOperation.build<SearchRoutingProfilesRequest, SearchRoutingProfilesResponse> {
            serializer = SearchRoutingProfilesOperationSerializer()
            deserializer = SearchRoutingProfilesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "SearchRoutingProfiles"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("SearchRoutingProfiles-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Searches security profiles in an Amazon Connect instance, with optional filtering.
     */
    override suspend fun searchSecurityProfiles(input: SearchSecurityProfilesRequest): SearchSecurityProfilesResponse {
        val op = SdkHttpOperation.build<SearchSecurityProfilesRequest, SearchSecurityProfilesResponse> {
            serializer = SearchSecurityProfilesOperationSerializer()
            deserializer = SearchSecurityProfilesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "SearchSecurityProfiles"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("SearchSecurityProfiles-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Searches users in an Amazon Connect instance, with optional filtering.
     *
     * `AfterContactWorkTimeLimit` is returned in milliseconds.
     */
    override suspend fun searchUsers(input: SearchUsersRequest): SearchUsersResponse {
        val op = SdkHttpOperation.build<SearchUsersRequest, SearchUsersResponse> {
            serializer = SearchUsersOperationSerializer()
            deserializer = SearchUsersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "SearchUsers"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("SearchUsers-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Searches for vocabularies within a specific Amazon Connect instance using `State`, `NameStartsWith`, and `LanguageCode`.
     */
    override suspend fun searchVocabularies(input: SearchVocabulariesRequest): SearchVocabulariesResponse {
        val op = SdkHttpOperation.build<SearchVocabulariesRequest, SearchVocabulariesResponse> {
            serializer = SearchVocabulariesOperationSerializer()
            deserializer = SearchVocabulariesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "SearchVocabularies"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("SearchVocabularies-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Initiates a flow to start a new chat for the customer. Response of this API provides a token required to obtain credentials from the [CreateParticipantConnection](https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html) API in the Amazon Connect Participant Service.
     *
     * When a new chat contact is successfully created, clients must subscribe to the participant’s connection for the created chat within 5 minutes. This is achieved by invoking [CreateParticipantConnection](https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html) with WEBSOCKET and CONNECTION_CREDENTIALS.
     *
     * A 429 error occurs in the following situations:
     * + API rate limit is exceeded. API TPS throttling returns a `TooManyRequests` exception.
     * + The [quota for concurrent active chats](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html) is exceeded. Active chat throttling returns a `LimitExceededException`.
     *
     * If you use the `ChatDurationInMinutes` parameter and receive a 400 error, your account may not support the ability to configure custom chat durations. For more information, contact Amazon Web Services Support.
     *
     * For more information about chat, see [Chat](https://docs.aws.amazon.com/connect/latest/adminguide/chat.html) in the *Amazon Connect Administrator Guide*.
     */
    override suspend fun startChatContact(input: StartChatContactRequest): StartChatContactResponse {
        val op = SdkHttpOperation.build<StartChatContactRequest, StartChatContactResponse> {
            serializer = StartChatContactOperationSerializer()
            deserializer = StartChatContactOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "StartChatContact"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("StartChatContact-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Starts recording the contact:
     * + If the API is called *before* the agent joins the call, recording starts when the agent joins the call.
     * + If the API is called *after* the agent joins the call, recording starts at the time of the API call.
     *
     * StartContactRecording is a one-time action. For example, if you use StopContactRecording to stop recording an ongoing call, you can't use StartContactRecording to restart it. For scenarios where the recording has started and you want to suspend and resume it, such as when collecting sensitive information (for example, a credit card number), use SuspendContactRecording and ResumeContactRecording.
     *
     * You can use this API to override the recording behavior configured in the [Set recording behavior](https://docs.aws.amazon.com/connect/latest/adminguide/set-recording-behavior.html) block.
     *
     * Only voice recordings are supported at this time.
     */
    override suspend fun startContactRecording(input: StartContactRecordingRequest): StartContactRecordingResponse {
        val op = SdkHttpOperation.build<StartContactRecordingRequest, StartContactRecordingResponse> {
            serializer = StartContactRecordingOperationSerializer()
            deserializer = StartContactRecordingOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "StartContactRecording"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("StartContactRecording-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Initiates real-time message streaming for a new chat contact.
     *
     *  For more information about message streaming, see [Enable real-time chat message streaming](https://docs.aws.amazon.com/connect/latest/adminguide/chat-message-streaming.html) in the *Amazon Connect Administrator Guide*.
     */
    override suspend fun startContactStreaming(input: StartContactStreamingRequest): StartContactStreamingResponse {
        val op = SdkHttpOperation.build<StartContactStreamingRequest, StartContactStreamingResponse> {
            serializer = StartContactStreamingOperationSerializer()
            deserializer = StartContactStreamingOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "StartContactStreaming"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("StartContactStreaming-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Places an outbound call to a contact, and then initiates the flow. It performs the actions in the flow that's specified (in `ContactFlowId`).
     *
     * Agents do not initiate the outbound API, which means that they do not dial the contact. If the flow places an outbound call to a contact, and then puts the contact in queue, the call is then routed to the agent, like any other inbound case.
     *
     * There is a 60-second dialing timeout for this operation. If the call is not connected after 60 seconds, it fails.
     *
     * UK numbers with a 447 prefix are not allowed by default. Before you can dial these UK mobile numbers, you must submit a service quota increase request. For more information, see [Amazon Connect Service Quotas](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html) in the *Amazon Connect Administrator Guide*.
     *
     * Campaign calls are not allowed by default. Before you can make a call with `TrafficType` = `CAMPAIGN`, you must submit a service quota increase request to the quota [Amazon Connect campaigns](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#outbound-communications-quotas).
     */
    override suspend fun startOutboundVoiceContact(input: StartOutboundVoiceContactRequest): StartOutboundVoiceContactResponse {
        val op = SdkHttpOperation.build<StartOutboundVoiceContactRequest, StartOutboundVoiceContactResponse> {
            serializer = StartOutboundVoiceContactOperationSerializer()
            deserializer = StartOutboundVoiceContactOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "StartOutboundVoiceContact"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("StartOutboundVoiceContact-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Initiates a flow to start a new task.
     */
    override suspend fun startTaskContact(input: StartTaskContactRequest): StartTaskContactResponse {
        val op = SdkHttpOperation.build<StartTaskContactRequest, StartTaskContactResponse> {
            serializer = StartTaskContactOperationSerializer()
            deserializer = StartTaskContactOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "StartTaskContact"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("StartTaskContact-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Ends the specified contact. This call does not work for the following initiation methods:
     * + DISCONNECT
     * + TRANSFER
     * + QUEUE_TRANSFER
     */
    override suspend fun stopContact(input: StopContactRequest): StopContactResponse {
        val op = SdkHttpOperation.build<StopContactRequest, StopContactResponse> {
            serializer = StopContactOperationSerializer()
            deserializer = StopContactOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "StopContact"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("StopContact-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Stops recording a call when a contact is being recorded. StopContactRecording is a one-time action. If you use StopContactRecording to stop recording an ongoing call, you can't use StartContactRecording to restart it. For scenarios where the recording has started and you want to suspend it for sensitive information (for example, to collect a credit card number), and then restart it, use SuspendContactRecording and ResumeContactRecording.
     *
     * Only voice recordings are supported at this time.
     */
    override suspend fun stopContactRecording(input: StopContactRecordingRequest): StopContactRecordingResponse {
        val op = SdkHttpOperation.build<StopContactRecordingRequest, StopContactRecordingResponse> {
            serializer = StopContactRecordingOperationSerializer()
            deserializer = StopContactRecordingOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "StopContactRecording"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("StopContactRecording-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Ends message streaming on a specified contact. To restart message streaming on that contact, call the [StartContactStreaming](https://docs.aws.amazon.com/connect/latest/APIReference/API_StartContactStreaming.html) API.
     */
    override suspend fun stopContactStreaming(input: StopContactStreamingRequest): StopContactStreamingResponse {
        val op = SdkHttpOperation.build<StopContactStreamingRequest, StopContactStreamingResponse> {
            serializer = StopContactStreamingOperationSerializer()
            deserializer = StopContactStreamingOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "StopContactStreaming"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("StopContactStreaming-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * When a contact is being recorded, this API suspends recording the call. For example, you might suspend the call recording while collecting sensitive information, such as a credit card number. Then use ResumeContactRecording to restart recording.
     *
     * The period of time that the recording is suspended is filled with silence in the final recording.
     *
     * Only voice recordings are supported at this time.
     */
    override suspend fun suspendContactRecording(input: SuspendContactRecordingRequest): SuspendContactRecordingResponse {
        val op = SdkHttpOperation.build<SuspendContactRecordingRequest, SuspendContactRecordingResponse> {
            serializer = SuspendContactRecordingOperationSerializer()
            deserializer = SuspendContactRecordingOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "SuspendContactRecording"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("SuspendContactRecording-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Adds the specified tags to the specified resource.
     *
     * Some of the supported resource types are agents, routing profiles, queues, quick connects, contact flows, agent statuses, hours of operation, phone numbers, security profiles, and task templates. For a complete list, see [Tagging resources in Amazon Connect](https://docs.aws.amazon.com/connect/latest/adminguide/tagging.html).
     *
     * For sample policies that use tags, see [Amazon Connect Identity-Based Policy Examples](https://docs.aws.amazon.com/connect/latest/adminguide/security_iam_id-based-policy-examples.html) in the *Amazon Connect Administrator Guide*.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "TagResource"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("TagResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Transfers contacts from one agent or queue to another agent or queue at any point after a contact is created. You can transfer a contact to another queue by providing the flow which orchestrates the contact to the destination queue. This gives you more control over contact handling and helps you adhere to the service level agreement (SLA) guaranteed to your customers.
     *
     * Note the following requirements:
     * + Transfer is supported for only `TASK` contacts.
     * + Do not use both `QueueId` and `UserId` in the same call.
     * + The following flow types are supported: Inbound flow, Transfer to agent flow, and Transfer to queue flow.
     * + The `TransferContact` API can be called only on active contacts.
     * + A contact cannot be transferred more than 11 times.
     */
    override suspend fun transferContact(input: TransferContactRequest): TransferContactResponse {
        val op = SdkHttpOperation.build<TransferContactRequest, TransferContactResponse> {
            serializer = TransferContactOperationSerializer()
            deserializer = TransferContactOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "TransferContact"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("TransferContact-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Removes the specified tags from the specified resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UntagResource"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UntagResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Updates agent status.
     */
    override suspend fun updateAgentStatus(input: UpdateAgentStatusRequest): UpdateAgentStatusResponse {
        val op = SdkHttpOperation.build<UpdateAgentStatusRequest, UpdateAgentStatusResponse> {
            serializer = UpdateAgentStatusOperationSerializer()
            deserializer = UpdateAgentStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateAgentStatus"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateAgentStatus-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Adds or updates user-defined contact information associated with the specified contact. At least one field to be updated must be present in the request.
     *
     * You can add or update user-defined contact information for both ongoing and completed contacts.
     */
    override suspend fun updateContact(input: UpdateContactRequest): UpdateContactResponse {
        val op = SdkHttpOperation.build<UpdateContactRequest, UpdateContactResponse> {
            serializer = UpdateContactOperationSerializer()
            deserializer = UpdateContactOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateContact"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateContact-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates or updates user-defined contact attributes associated with the specified contact.
     *
     * You can create or update user-defined attributes for both ongoing and completed contacts. For example, while the call is active, you can update the customer's name or the reason the customer called. You can add notes about steps that the agent took during the call that display to the next agent that takes the call. You can also update attributes for a contact using data from your CRM application and save the data with the contact in Amazon Connect. You could also flag calls for additional analysis, such as legal review or to identify abusive callers.
     *
     * Contact attributes are available in Amazon Connect for 24 months, and are then deleted. For information about contact record retention and the maximum size of the contact record attributes section, see [Feature specifications](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#feature-limits) in the *Amazon Connect Administrator Guide*.
     */
    override suspend fun updateContactAttributes(input: UpdateContactAttributesRequest): UpdateContactAttributesResponse {
        val op = SdkHttpOperation.build<UpdateContactAttributesRequest, UpdateContactAttributesResponse> {
            serializer = UpdateContactAttributesOperationSerializer()
            deserializer = UpdateContactAttributesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateContactAttributes"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateContactAttributes-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates the specified flow.
     *
     * You can also create and update flows using the [Amazon Connect Flow language](https://docs.aws.amazon.com/connect/latest/APIReference/flow-language.html).
     */
    override suspend fun updateContactFlowContent(input: UpdateContactFlowContentRequest): UpdateContactFlowContentResponse {
        val op = SdkHttpOperation.build<UpdateContactFlowContentRequest, UpdateContactFlowContentResponse> {
            serializer = UpdateContactFlowContentOperationSerializer()
            deserializer = UpdateContactFlowContentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateContactFlowContent"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateContactFlowContent-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates metadata about specified flow.
     */
    override suspend fun updateContactFlowMetadata(input: UpdateContactFlowMetadataRequest): UpdateContactFlowMetadataResponse {
        val op = SdkHttpOperation.build<UpdateContactFlowMetadataRequest, UpdateContactFlowMetadataResponse> {
            serializer = UpdateContactFlowMetadataOperationSerializer()
            deserializer = UpdateContactFlowMetadataOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateContactFlowMetadata"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateContactFlowMetadata-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates specified flow module for the specified Amazon Connect instance.
     */
    override suspend fun updateContactFlowModuleContent(input: UpdateContactFlowModuleContentRequest): UpdateContactFlowModuleContentResponse {
        val op = SdkHttpOperation.build<UpdateContactFlowModuleContentRequest, UpdateContactFlowModuleContentResponse> {
            serializer = UpdateContactFlowModuleContentOperationSerializer()
            deserializer = UpdateContactFlowModuleContentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateContactFlowModuleContent"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateContactFlowModuleContent-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates metadata about specified flow module.
     */
    override suspend fun updateContactFlowModuleMetadata(input: UpdateContactFlowModuleMetadataRequest): UpdateContactFlowModuleMetadataResponse {
        val op = SdkHttpOperation.build<UpdateContactFlowModuleMetadataRequest, UpdateContactFlowModuleMetadataResponse> {
            serializer = UpdateContactFlowModuleMetadataOperationSerializer()
            deserializer = UpdateContactFlowModuleMetadataOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateContactFlowModuleMetadata"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateContactFlowModuleMetadata-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * The name of the flow.
     *
     * You can also create and update flows using the [Amazon Connect Flow language](https://docs.aws.amazon.com/connect/latest/APIReference/flow-language.html).
     */
    override suspend fun updateContactFlowName(input: UpdateContactFlowNameRequest): UpdateContactFlowNameResponse {
        val op = SdkHttpOperation.build<UpdateContactFlowNameRequest, UpdateContactFlowNameResponse> {
            serializer = UpdateContactFlowNameOperationSerializer()
            deserializer = UpdateContactFlowNameOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateContactFlowName"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateContactFlowName-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates the scheduled time of a task contact that is already scheduled.
     */
    override suspend fun updateContactSchedule(input: UpdateContactScheduleRequest): UpdateContactScheduleResponse {
        val op = SdkHttpOperation.build<UpdateContactScheduleRequest, UpdateContactScheduleResponse> {
            serializer = UpdateContactScheduleOperationSerializer()
            deserializer = UpdateContactScheduleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateContactSchedule"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateContactSchedule-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Updates the hours of operation.
     */
    override suspend fun updateHoursOfOperation(input: UpdateHoursOfOperationRequest): UpdateHoursOfOperationResponse {
        val op = SdkHttpOperation.build<UpdateHoursOfOperationRequest, UpdateHoursOfOperationResponse> {
            serializer = UpdateHoursOfOperationOperationSerializer()
            deserializer = UpdateHoursOfOperationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateHoursOfOperation"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateHoursOfOperation-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Updates the value for the specified attribute type.
     */
    override suspend fun updateInstanceAttribute(input: UpdateInstanceAttributeRequest): UpdateInstanceAttributeResponse {
        val op = SdkHttpOperation.build<UpdateInstanceAttributeRequest, UpdateInstanceAttributeResponse> {
            serializer = UpdateInstanceAttributeOperationSerializer()
            deserializer = UpdateInstanceAttributeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateInstanceAttribute"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateInstanceAttribute-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Updates an existing configuration for a resource type. This API is idempotent.
     */
    override suspend fun updateInstanceStorageConfig(input: UpdateInstanceStorageConfigRequest): UpdateInstanceStorageConfigResponse {
        val op = SdkHttpOperation.build<UpdateInstanceStorageConfigRequest, UpdateInstanceStorageConfigResponse> {
            serializer = UpdateInstanceStorageConfigOperationSerializer()
            deserializer = UpdateInstanceStorageConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateInstanceStorageConfig"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateInstanceStorageConfig-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates timeouts for when human chat participants are to be considered idle, and when agents are automatically disconnected from a chat due to idleness. You can set four timers:
     * + Customer idle timeout
     * + Customer auto-disconnect timeout
     * + Agent idle timeout
     * + Agent auto-disconnect timeout
     *
     * For more information about how chat timeouts work, see [Set up chat timeouts for human participants](https://docs.aws.amazon.com/connect/latest/adminguide/setup-chat-timeouts.html).
     */
    override suspend fun updateParticipantRoleConfig(input: UpdateParticipantRoleConfigRequest): UpdateParticipantRoleConfigResponse {
        val op = SdkHttpOperation.build<UpdateParticipantRoleConfigRequest, UpdateParticipantRoleConfigResponse> {
            serializer = UpdateParticipantRoleConfigOperationSerializer()
            deserializer = UpdateParticipantRoleConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateParticipantRoleConfig"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateParticipantRoleConfig-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates your claimed phone number from its current Amazon Connect instance or traffic distribution group to another Amazon Connect instance or traffic distribution group in the same Amazon Web Services Region.
     *
     * You can call [DescribePhoneNumber](https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribePhoneNumber.html) API to verify the status of a previous [UpdatePhoneNumber](https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdatePhoneNumber.html) operation.
     */
    override suspend fun updatePhoneNumber(input: UpdatePhoneNumberRequest): UpdatePhoneNumberResponse {
        val op = SdkHttpOperation.build<UpdatePhoneNumberRequest, UpdatePhoneNumberResponse> {
            serializer = UpdatePhoneNumberOperationSerializer()
            deserializer = UpdatePhoneNumberOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdatePhoneNumber"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdatePhoneNumber-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Updates the hours of operation for the specified queue.
     */
    override suspend fun updateQueueHoursOfOperation(input: UpdateQueueHoursOfOperationRequest): UpdateQueueHoursOfOperationResponse {
        val op = SdkHttpOperation.build<UpdateQueueHoursOfOperationRequest, UpdateQueueHoursOfOperationResponse> {
            serializer = UpdateQueueHoursOfOperationOperationSerializer()
            deserializer = UpdateQueueHoursOfOperationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateQueueHoursOfOperation"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateQueueHoursOfOperation-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Updates the maximum number of contacts allowed in a queue before it is considered full.
     */
    override suspend fun updateQueueMaxContacts(input: UpdateQueueMaxContactsRequest): UpdateQueueMaxContactsResponse {
        val op = SdkHttpOperation.build<UpdateQueueMaxContactsRequest, UpdateQueueMaxContactsResponse> {
            serializer = UpdateQueueMaxContactsOperationSerializer()
            deserializer = UpdateQueueMaxContactsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateQueueMaxContacts"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateQueueMaxContacts-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Updates the name and description of a queue. At least `Name` or `Description` must be provided.
     */
    override suspend fun updateQueueName(input: UpdateQueueNameRequest): UpdateQueueNameResponse {
        val op = SdkHttpOperation.build<UpdateQueueNameRequest, UpdateQueueNameResponse> {
            serializer = UpdateQueueNameOperationSerializer()
            deserializer = UpdateQueueNameOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateQueueName"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateQueueName-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Updates the outbound caller ID name, number, and outbound whisper flow for a specified queue.
     *
     * If the number being used in the input is claimed to a traffic distribution group, and you are calling this API using an instance in the Amazon Web Services Region where the traffic distribution group was created, you can use either a full phone number ARN or UUID value for the `OutboundCallerIdNumberId` value of the [OutboundCallerConfig](https://docs.aws.amazon.com/connect/latest/APIReference/API_OutboundCallerConfig) request body parameter. However, if the number is claimed to a traffic distribution group and you are calling this API using an instance in the alternate Amazon Web Services Region associated with the traffic distribution group, you must provide a full phone number ARN. If a UUID is provided in this scenario, you will receive a `ResourceNotFoundException`.
     */
    override suspend fun updateQueueOutboundCallerConfig(input: UpdateQueueOutboundCallerConfigRequest): UpdateQueueOutboundCallerConfigResponse {
        val op = SdkHttpOperation.build<UpdateQueueOutboundCallerConfigRequest, UpdateQueueOutboundCallerConfigResponse> {
            serializer = UpdateQueueOutboundCallerConfigOperationSerializer()
            deserializer = UpdateQueueOutboundCallerConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateQueueOutboundCallerConfig"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateQueueOutboundCallerConfig-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Updates the status of the queue.
     */
    override suspend fun updateQueueStatus(input: UpdateQueueStatusRequest): UpdateQueueStatusResponse {
        val op = SdkHttpOperation.build<UpdateQueueStatusRequest, UpdateQueueStatusResponse> {
            serializer = UpdateQueueStatusOperationSerializer()
            deserializer = UpdateQueueStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateQueueStatus"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateQueueStatus-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates the configuration settings for the specified quick connect.
     */
    override suspend fun updateQuickConnectConfig(input: UpdateQuickConnectConfigRequest): UpdateQuickConnectConfigResponse {
        val op = SdkHttpOperation.build<UpdateQuickConnectConfigRequest, UpdateQuickConnectConfigResponse> {
            serializer = UpdateQuickConnectConfigOperationSerializer()
            deserializer = UpdateQuickConnectConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateQuickConnectConfig"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateQuickConnectConfig-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates the name and description of a quick connect. The request accepts the following data in JSON format. At least `Name` or `Description` must be provided.
     */
    override suspend fun updateQuickConnectName(input: UpdateQuickConnectNameRequest): UpdateQuickConnectNameResponse {
        val op = SdkHttpOperation.build<UpdateQuickConnectNameRequest, UpdateQuickConnectNameResponse> {
            serializer = UpdateQuickConnectNameOperationSerializer()
            deserializer = UpdateQuickConnectNameOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateQuickConnectName"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateQuickConnectName-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates the channels that agents can handle in the Contact Control Panel (CCP) for a routing profile.
     */
    override suspend fun updateRoutingProfileConcurrency(input: UpdateRoutingProfileConcurrencyRequest): UpdateRoutingProfileConcurrencyResponse {
        val op = SdkHttpOperation.build<UpdateRoutingProfileConcurrencyRequest, UpdateRoutingProfileConcurrencyResponse> {
            serializer = UpdateRoutingProfileConcurrencyOperationSerializer()
            deserializer = UpdateRoutingProfileConcurrencyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateRoutingProfileConcurrency"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateRoutingProfileConcurrency-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates the default outbound queue of a routing profile.
     */
    override suspend fun updateRoutingProfileDefaultOutboundQueue(input: UpdateRoutingProfileDefaultOutboundQueueRequest): UpdateRoutingProfileDefaultOutboundQueueResponse {
        val op = SdkHttpOperation.build<UpdateRoutingProfileDefaultOutboundQueueRequest, UpdateRoutingProfileDefaultOutboundQueueResponse> {
            serializer = UpdateRoutingProfileDefaultOutboundQueueOperationSerializer()
            deserializer = UpdateRoutingProfileDefaultOutboundQueueOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateRoutingProfileDefaultOutboundQueue"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateRoutingProfileDefaultOutboundQueue-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates the name and description of a routing profile. The request accepts the following data in JSON format. At least `Name` or `Description` must be provided.
     */
    override suspend fun updateRoutingProfileName(input: UpdateRoutingProfileNameRequest): UpdateRoutingProfileNameResponse {
        val op = SdkHttpOperation.build<UpdateRoutingProfileNameRequest, UpdateRoutingProfileNameResponse> {
            serializer = UpdateRoutingProfileNameOperationSerializer()
            deserializer = UpdateRoutingProfileNameOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateRoutingProfileName"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateRoutingProfileName-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates the properties associated with a set of queues for a routing profile.
     */
    override suspend fun updateRoutingProfileQueues(input: UpdateRoutingProfileQueuesRequest): UpdateRoutingProfileQueuesResponse {
        val op = SdkHttpOperation.build<UpdateRoutingProfileQueuesRequest, UpdateRoutingProfileQueuesResponse> {
            serializer = UpdateRoutingProfileQueuesOperationSerializer()
            deserializer = UpdateRoutingProfileQueuesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateRoutingProfileQueues"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateRoutingProfileQueues-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates a rule for the specified Amazon Connect instance.
     *
     * Use the [Rules Function language](https://docs.aws.amazon.com/connect/latest/APIReference/connect-rules-language.html) to code conditions for the rule.
     */
    override suspend fun updateRule(input: UpdateRuleRequest): UpdateRuleResponse {
        val op = SdkHttpOperation.build<UpdateRuleRequest, UpdateRuleResponse> {
            serializer = UpdateRuleOperationSerializer()
            deserializer = UpdateRuleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateRule"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateRule-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Updates a security profile.
     */
    override suspend fun updateSecurityProfile(input: UpdateSecurityProfileRequest): UpdateSecurityProfileResponse {
        val op = SdkHttpOperation.build<UpdateSecurityProfileRequest, UpdateSecurityProfileResponse> {
            serializer = UpdateSecurityProfileOperationSerializer()
            deserializer = UpdateSecurityProfileOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateSecurityProfile"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateSecurityProfile-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates details about a specific task template in the specified Amazon Connect instance. This operation does not support partial updates. Instead it does a full update of template content.
     */
    override suspend fun updateTaskTemplate(input: UpdateTaskTemplateRequest): UpdateTaskTemplateResponse {
        val op = SdkHttpOperation.build<UpdateTaskTemplateRequest, UpdateTaskTemplateResponse> {
            serializer = UpdateTaskTemplateOperationSerializer()
            deserializer = UpdateTaskTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateTaskTemplate"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateTaskTemplate-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates the traffic distribution for a given traffic distribution group.
     *
     * For more information about updating a traffic distribution group, see [Update telephony traffic distribution across Amazon Web Services Regions ](https://docs.aws.amazon.com/connect/latest/adminguide/update-telephony-traffic-distribution.html) in the *Amazon Connect Administrator Guide*.
     */
    override suspend fun updateTrafficDistribution(input: UpdateTrafficDistributionRequest): UpdateTrafficDistributionResponse {
        val op = SdkHttpOperation.build<UpdateTrafficDistributionRequest, UpdateTrafficDistributionResponse> {
            serializer = UpdateTrafficDistributionOperationSerializer()
            deserializer = UpdateTrafficDistributionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateTrafficDistribution"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateTrafficDistribution-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Assigns the specified hierarchy group to the specified user.
     */
    override suspend fun updateUserHierarchy(input: UpdateUserHierarchyRequest): UpdateUserHierarchyResponse {
        val op = SdkHttpOperation.build<UpdateUserHierarchyRequest, UpdateUserHierarchyResponse> {
            serializer = UpdateUserHierarchyOperationSerializer()
            deserializer = UpdateUserHierarchyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateUserHierarchy"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateUserHierarchy-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates the name of the user hierarchy group.
     */
    override suspend fun updateUserHierarchyGroupName(input: UpdateUserHierarchyGroupNameRequest): UpdateUserHierarchyGroupNameResponse {
        val op = SdkHttpOperation.build<UpdateUserHierarchyGroupNameRequest, UpdateUserHierarchyGroupNameResponse> {
            serializer = UpdateUserHierarchyGroupNameOperationSerializer()
            deserializer = UpdateUserHierarchyGroupNameOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateUserHierarchyGroupName"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateUserHierarchyGroupName-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates the user hierarchy structure: add, remove, and rename user hierarchy levels.
     */
    override suspend fun updateUserHierarchyStructure(input: UpdateUserHierarchyStructureRequest): UpdateUserHierarchyStructureResponse {
        val op = SdkHttpOperation.build<UpdateUserHierarchyStructureRequest, UpdateUserHierarchyStructureResponse> {
            serializer = UpdateUserHierarchyStructureOperationSerializer()
            deserializer = UpdateUserHierarchyStructureOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateUserHierarchyStructure"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateUserHierarchyStructure-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates the identity information for the specified user.
     *
     * We strongly recommend limiting who has the ability to invoke `UpdateUserIdentityInfo`. Someone with that ability can change the login credentials of other users by changing their email address. This poses a security risk to your organization. They can change the email address of a user to the attacker's email address, and then reset the password through email. For more information, see [Best Practices for Security Profiles](https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-best-practices.html) in the *Amazon Connect Administrator Guide*.
     */
    override suspend fun updateUserIdentityInfo(input: UpdateUserIdentityInfoRequest): UpdateUserIdentityInfoResponse {
        val op = SdkHttpOperation.build<UpdateUserIdentityInfoRequest, UpdateUserIdentityInfoResponse> {
            serializer = UpdateUserIdentityInfoOperationSerializer()
            deserializer = UpdateUserIdentityInfoOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateUserIdentityInfo"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateUserIdentityInfo-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates the phone configuration settings for the specified user.
     */
    override suspend fun updateUserPhoneConfig(input: UpdateUserPhoneConfigRequest): UpdateUserPhoneConfigResponse {
        val op = SdkHttpOperation.build<UpdateUserPhoneConfigRequest, UpdateUserPhoneConfigResponse> {
            serializer = UpdateUserPhoneConfigOperationSerializer()
            deserializer = UpdateUserPhoneConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateUserPhoneConfig"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateUserPhoneConfig-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Assigns the specified routing profile to the specified user.
     */
    override suspend fun updateUserRoutingProfile(input: UpdateUserRoutingProfileRequest): UpdateUserRoutingProfileResponse {
        val op = SdkHttpOperation.build<UpdateUserRoutingProfileRequest, UpdateUserRoutingProfileResponse> {
            serializer = UpdateUserRoutingProfileOperationSerializer()
            deserializer = UpdateUserRoutingProfileOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateUserRoutingProfile"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateUserRoutingProfile-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Assigns the specified security profiles to the specified user.
     */
    override suspend fun updateUserSecurityProfiles(input: UpdateUserSecurityProfilesRequest): UpdateUserSecurityProfilesResponse {
        val op = SdkHttpOperation.build<UpdateUserSecurityProfilesRequest, UpdateUserSecurityProfilesResponse> {
            serializer = UpdateUserSecurityProfilesOperationSerializer()
            deserializer = UpdateUserSecurityProfilesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateUserSecurityProfiles"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateUserSecurityProfiles-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ClientName, config.clientName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "connect")
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
        config.idempotencyTokenProvider?.let { ctx[SdkClientOption.IdempotencyTokenProvider] = it }
    }
}
