// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.serde

import aws.sdk.kotlin.services.connect.model.Endpoint
import aws.sdk.kotlin.services.connect.model.QueueInfoInput
import aws.sdk.kotlin.services.connect.model.Reference
import aws.sdk.kotlin.services.connect.model.SegmentAttributeValue
import aws.sdk.kotlin.services.connect.model.UpdateContactRequest
import aws.sdk.kotlin.services.connect.model.UserInfo
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateContactOperationSerializer: HttpSerializer.NonStreaming<UpdateContactRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateContactRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.instanceId) { "instanceId is bound to the URI and must not be null" }
            requireNotNull(input.contactId) { "contactId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("contacts"))
                add(PercentEncoding.SmithyLabel.encode(input.instanceId))
                add(PercentEncoding.SmithyLabel.encode(input.contactId))
            }
        }

        val payload = serializeUpdateContactOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateContactOperationBody(context: ExecutionContext, input: UpdateContactRequest): ByteArray {
    val serializer = JsonSerializer()
    val CUSTOMERENDPOINT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("CustomerEndpoint"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val QUEUEINFO_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("QueueInfo"))
    val REFERENCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("References"))
    val SEGMENTATTRIBUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("SegmentAttributes"))
    val SYSTEMENDPOINT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SystemEndpoint"))
    val USERINFO_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("UserInfo"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CUSTOMERENDPOINT_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(QUEUEINFO_DESCRIPTOR)
        field(REFERENCES_DESCRIPTOR)
        field(SEGMENTATTRIBUTES_DESCRIPTOR)
        field(SYSTEMENDPOINT_DESCRIPTOR)
        field(USERINFO_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.customerEndpoint?.let { field(CUSTOMERENDPOINT_DESCRIPTOR, it, ::serializeEndpointDocument) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        input.queueInfo?.let { field(QUEUEINFO_DESCRIPTOR, it, ::serializeQueueInfoInputDocument) }
        if (input.references != null) {
            mapField(REFERENCES_DESCRIPTOR) {
                input.references.forEach { (key, value) -> entry(key, asSdkSerializable(value, ::serializeReferenceDocument)) }
            }
        }
        if (input.segmentAttributes != null) {
            mapField(SEGMENTATTRIBUTES_DESCRIPTOR) {
                input.segmentAttributes.forEach { (key, value) -> entry(key, asSdkSerializable(value, ::serializeSegmentAttributeValueDocument)) }
            }
        }
        input.systemEndpoint?.let { field(SYSTEMENDPOINT_DESCRIPTOR, it, ::serializeEndpointDocument) }
        input.userInfo?.let { field(USERINFO_DESCRIPTOR, it, ::serializeUserInfoDocument) }
    }
    return serializer.toByteArray()
}
