// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.serde

import aws.sdk.kotlin.services.connect.model.ChatMessage
import aws.sdk.kotlin.services.connect.model.Endpoint
import aws.sdk.kotlin.services.connect.model.ParticipantDetails
import aws.sdk.kotlin.services.connect.model.SegmentAttributeValue
import aws.sdk.kotlin.services.connect.model.StartOutboundChatContactRequest
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class StartOutboundChatContactOperationSerializer: HttpSerializer.NonStreaming<StartOutboundChatContactRequest> {
    override fun serialize(context: ExecutionContext, input: StartOutboundChatContactRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            path.encoded = "/contact/outbound-chat"
        }

        val payload = serializeStartOutboundChatContactOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeStartOutboundChatContactOperationBody(context: ExecutionContext, input: StartOutboundChatContactRequest): ByteArray {
    val serializer = JsonSerializer()
    val ATTRIBUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Attributes"))
    val CHATDURATIONINMINUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("ChatDurationInMinutes"))
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ClientToken"))
    val CONTACTFLOWID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ContactFlowId"))
    val DESTINATIONENDPOINT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DestinationEndpoint"))
    val INITIALSYSTEMMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("InitialSystemMessage"))
    val INSTANCEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("InstanceId"))
    val PARTICIPANTDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ParticipantDetails"))
    val RELATEDCONTACTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RelatedContactId"))
    val SEGMENTATTRIBUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("SegmentAttributes"))
    val SOURCEENDPOINT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SourceEndpoint"))
    val SUPPORTEDMESSAGINGCONTENTTYPES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("SupportedMessagingContentTypes"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ATTRIBUTES_DESCRIPTOR)
        field(CHATDURATIONINMINUTES_DESCRIPTOR)
        field(CLIENTTOKEN_DESCRIPTOR)
        field(CONTACTFLOWID_DESCRIPTOR)
        field(DESTINATIONENDPOINT_DESCRIPTOR)
        field(INITIALSYSTEMMESSAGE_DESCRIPTOR)
        field(INSTANCEID_DESCRIPTOR)
        field(PARTICIPANTDETAILS_DESCRIPTOR)
        field(RELATEDCONTACTID_DESCRIPTOR)
        field(SEGMENTATTRIBUTES_DESCRIPTOR)
        field(SOURCEENDPOINT_DESCRIPTOR)
        field(SUPPORTEDMESSAGINGCONTENTTYPES_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.attributes != null) {
            mapField(ATTRIBUTES_DESCRIPTOR) {
                input.attributes.forEach { (key, value) ->
                    entry(key, value)
                }
            }
        }
        input.chatDurationInMinutes?.let { field(CHATDURATIONINMINUTES_DESCRIPTOR, it) }
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.contactFlowId?.let { field(CONTACTFLOWID_DESCRIPTOR, it) }
        input.destinationEndpoint?.let { field(DESTINATIONENDPOINT_DESCRIPTOR, it, ::serializeEndpointDocument) }
        input.initialSystemMessage?.let { field(INITIALSYSTEMMESSAGE_DESCRIPTOR, it, ::serializeChatMessageDocument) }
        input.instanceId?.let { field(INSTANCEID_DESCRIPTOR, it) }
        input.participantDetails?.let { field(PARTICIPANTDETAILS_DESCRIPTOR, it, ::serializeParticipantDetailsDocument) }
        input.relatedContactId?.let { field(RELATEDCONTACTID_DESCRIPTOR, it) }
        if (input.segmentAttributes != null) {
            mapField(SEGMENTATTRIBUTES_DESCRIPTOR) {
                input.segmentAttributes.forEach { (key, value) -> entry(key, asSdkSerializable(value, ::serializeSegmentAttributeValueDocument)) }
            }
        }
        input.sourceEndpoint?.let { field(SOURCEENDPOINT_DESCRIPTOR, it, ::serializeEndpointDocument) }
        if (input.supportedMessagingContentTypes != null) {
            listField(SUPPORTEDMESSAGINGCONTENTTYPES_DESCRIPTOR) {
                for (el0 in input.supportedMessagingContentTypes) {
                    serializeString(el0)
                }
            }
        }
    }
    return serializer.toByteArray()
}
