// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.serde

import aws.sdk.kotlin.services.connect.model.ChatMessage
import aws.sdk.kotlin.services.connect.model.ParticipantDetails
import aws.sdk.kotlin.services.connect.model.PersistentChat
import aws.sdk.kotlin.services.connect.model.SegmentAttributeValue
import aws.sdk.kotlin.services.connect.model.StartChatContactRequest
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class StartChatContactOperationSerializer: HttpSerializer.NonStreaming<StartChatContactRequest> {
    override fun serialize(context: ExecutionContext, input: StartChatContactRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            path.encoded = "/contact/chat"
        }

        val payload = serializeStartChatContactOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeStartChatContactOperationBody(context: ExecutionContext, input: StartChatContactRequest): ByteArray {
    val serializer = JsonSerializer()
    val ATTRIBUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Attributes"))
    val CHATDURATIONINMINUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("ChatDurationInMinutes"))
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ClientToken"))
    val CONTACTFLOWID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ContactFlowId"))
    val CUSTOMERID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CustomerId"))
    val INITIALMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("InitialMessage"))
    val INSTANCEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("InstanceId"))
    val PARTICIPANTDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ParticipantDetails"))
    val PERSISTENTCHAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("PersistentChat"))
    val RELATEDCONTACTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RelatedContactId"))
    val SEGMENTATTRIBUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("SegmentAttributes"))
    val SUPPORTEDMESSAGINGCONTENTTYPES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("SupportedMessagingContentTypes"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ATTRIBUTES_DESCRIPTOR)
        field(CHATDURATIONINMINUTES_DESCRIPTOR)
        field(CLIENTTOKEN_DESCRIPTOR)
        field(CONTACTFLOWID_DESCRIPTOR)
        field(CUSTOMERID_DESCRIPTOR)
        field(INITIALMESSAGE_DESCRIPTOR)
        field(INSTANCEID_DESCRIPTOR)
        field(PARTICIPANTDETAILS_DESCRIPTOR)
        field(PERSISTENTCHAT_DESCRIPTOR)
        field(RELATEDCONTACTID_DESCRIPTOR)
        field(SEGMENTATTRIBUTES_DESCRIPTOR)
        field(SUPPORTEDMESSAGINGCONTENTTYPES_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.attributes != null) {
            mapField(ATTRIBUTES_DESCRIPTOR) {
                input.attributes.forEach { (key, value) ->
                    entry(key, value)
                }
            }
        }
        input.chatDurationInMinutes?.let { field(CHATDURATIONINMINUTES_DESCRIPTOR, it) }
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.contactFlowId?.let { field(CONTACTFLOWID_DESCRIPTOR, it) }
        input.customerId?.let { field(CUSTOMERID_DESCRIPTOR, it) }
        input.initialMessage?.let { field(INITIALMESSAGE_DESCRIPTOR, it, ::serializeChatMessageDocument) }
        input.instanceId?.let { field(INSTANCEID_DESCRIPTOR, it) }
        input.participantDetails?.let { field(PARTICIPANTDETAILS_DESCRIPTOR, it, ::serializeParticipantDetailsDocument) }
        input.persistentChat?.let { field(PERSISTENTCHAT_DESCRIPTOR, it, ::serializePersistentChatDocument) }
        input.relatedContactId?.let { field(RELATEDCONTACTID_DESCRIPTOR, it) }
        if (input.segmentAttributes != null) {
            mapField(SEGMENTATTRIBUTES_DESCRIPTOR) {
                input.segmentAttributes.forEach { (key, value) -> entry(key, asSdkSerializable(value, ::serializeSegmentAttributeValueDocument)) }
            }
        }
        if (input.supportedMessagingContentTypes != null) {
            listField(SUPPORTEDMESSAGINGCONTENTTYPES_DESCRIPTOR) {
                for (el0 in input.supportedMessagingContentTypes) {
                    serializeString(el0)
                }
            }
        }
    }
    return serializer.toByteArray()
}
