// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.serde

import aws.sdk.kotlin.services.connect.model.CreatedByInfo
import aws.sdk.kotlin.services.connect.model.FileUseCaseType
import aws.sdk.kotlin.services.connect.model.StartAttachedFileUploadRequest
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class StartAttachedFileUploadOperationSerializer: HttpSerializer.NonStreaming<StartAttachedFileUploadRequest> {
    override fun serialize(context: ExecutionContext, input: StartAttachedFileUploadRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.instanceId) { "instanceId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("attached-files"))
                add(PercentEncoding.SmithyLabel.encode(input.instanceId))
            }
            parameters.decodedParameters(PercentEncoding.SmithyLabel) {
                if (input.associatedResourceArn != null) add("associatedResourceArn", input.associatedResourceArn)
            }
        }

        val payload = serializeStartAttachedFileUploadOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeStartAttachedFileUploadOperationBody(context: ExecutionContext, input: StartAttachedFileUploadRequest): ByteArray {
    val serializer = JsonSerializer()
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ClientToken"))
    val CREATEDBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("CreatedBy"))
    val FILENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FileName"))
    val FILESIZEINBYTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("FileSizeInBytes"))
    val FILEUSECASETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("FileUseCaseType"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Tags"))
    val URLEXPIRYINSECONDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("UrlExpiryInSeconds"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLIENTTOKEN_DESCRIPTOR)
        field(CREATEDBY_DESCRIPTOR)
        field(FILENAME_DESCRIPTOR)
        field(FILESIZEINBYTES_DESCRIPTOR)
        field(FILEUSECASETYPE_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(URLEXPIRYINSECONDS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.createdBy?.let { field(CREATEDBY_DESCRIPTOR, it, ::serializeCreatedByInfoDocument) }
        input.fileName?.let { field(FILENAME_DESCRIPTOR, it) }
        input.fileSizeInBytes?.let { field(FILESIZEINBYTES_DESCRIPTOR, it) }
        input.fileUseCaseType?.let { field(FILEUSECASETYPE_DESCRIPTOR, it.value) }
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) ->
                    entry(key, value)
                }
            }
        }
        input.urlExpiryInSeconds?.let { field(URLEXPIRYINSECONDS_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
