// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.serde

import aws.sdk.kotlin.services.connect.model.EmailAddressInfo
import aws.sdk.kotlin.services.connect.model.OutboundAdditionalRecipients
import aws.sdk.kotlin.services.connect.model.OutboundEmailContent
import aws.sdk.kotlin.services.connect.model.SendOutboundEmailRequest
import aws.sdk.kotlin.services.connect.model.SourceCampaign
import aws.sdk.kotlin.services.connect.model.TrafficType
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class SendOutboundEmailOperationSerializer: HttpSerializer.NonStreaming<SendOutboundEmailRequest> {
    override fun serialize(context: ExecutionContext, input: SendOutboundEmailRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.instanceId) { "instanceId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("instance"))
                add(PercentEncoding.SmithyLabel.encode(input.instanceId))
                add(PercentEncoding.Path.encode("outbound-email"))
            }
        }

        val payload = serializeSendOutboundEmailOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeSendOutboundEmailOperationBody(context: ExecutionContext, input: SendOutboundEmailRequest): ByteArray {
    val serializer = JsonSerializer()
    val ADDITIONALRECIPIENTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AdditionalRecipients"))
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ClientToken"))
    val DESTINATIONEMAILADDRESS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DestinationEmailAddress"))
    val EMAILMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("EmailMessage"))
    val FROMEMAILADDRESS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("FromEmailAddress"))
    val SOURCECAMPAIGN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SourceCampaign"))
    val TRAFFICTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("TrafficType"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ADDITIONALRECIPIENTS_DESCRIPTOR)
        field(CLIENTTOKEN_DESCRIPTOR)
        field(DESTINATIONEMAILADDRESS_DESCRIPTOR)
        field(EMAILMESSAGE_DESCRIPTOR)
        field(FROMEMAILADDRESS_DESCRIPTOR)
        field(SOURCECAMPAIGN_DESCRIPTOR)
        field(TRAFFICTYPE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.additionalRecipients?.let { field(ADDITIONALRECIPIENTS_DESCRIPTOR, it, ::serializeOutboundAdditionalRecipientsDocument) }
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.destinationEmailAddress?.let { field(DESTINATIONEMAILADDRESS_DESCRIPTOR, it, ::serializeEmailAddressInfoDocument) }
        input.emailMessage?.let { field(EMAILMESSAGE_DESCRIPTOR, it, ::serializeOutboundEmailContentDocument) }
        input.fromEmailAddress?.let { field(FROMEMAILADDRESS_DESCRIPTOR, it, ::serializeEmailAddressInfoDocument) }
        input.sourceCampaign?.let { field(SOURCECAMPAIGN_DESCRIPTOR, it, ::serializeSourceCampaignDocument) }
        input.trafficType?.let { field(TRAFFICTYPE_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
