// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.serde

import aws.sdk.kotlin.services.connect.model.FilterV2
import aws.sdk.kotlin.services.connect.model.GetMetricDataV2Request
import aws.sdk.kotlin.services.connect.model.IntervalDetails
import aws.sdk.kotlin.services.connect.model.MetricV2
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class GetMetricDataV2OperationSerializer: HttpSerializer.NonStreaming<GetMetricDataV2Request> {
    override fun serialize(context: ExecutionContext, input: GetMetricDataV2Request): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/metrics/data"
        }

        val payload = serializeGetMetricDataV2OperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeGetMetricDataV2OperationBody(context: ExecutionContext, input: GetMetricDataV2Request): ByteArray {
    val serializer = JsonSerializer()
    val ENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("EndTime"))
    val FILTERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Filters"))
    val GROUPINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Groupings"))
    val INTERVAL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Interval"))
    val MAXRESULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MaxResults"))
    val METRICS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Metrics"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val RESOURCEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ResourceArn"))
    val STARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("StartTime"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ENDTIME_DESCRIPTOR)
        field(FILTERS_DESCRIPTOR)
        field(GROUPINGS_DESCRIPTOR)
        field(INTERVAL_DESCRIPTOR)
        field(MAXRESULTS_DESCRIPTOR)
        field(METRICS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(RESOURCEARN_DESCRIPTOR)
        field(STARTTIME_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.endTime?.let { field(ENDTIME_DESCRIPTOR, it, TimestampFormat.EPOCH_SECONDS) }
        if (input.filters != null) {
            listField(FILTERS_DESCRIPTOR) {
                for (el0 in input.filters) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeFilterV2Document))
                }
            }
        }
        if (input.groupings != null) {
            listField(GROUPINGS_DESCRIPTOR) {
                for (el0 in input.groupings) {
                    serializeString(el0)
                }
            }
        }
        input.interval?.let { field(INTERVAL_DESCRIPTOR, it, ::serializeIntervalDetailsDocument) }
        input.maxResults?.let { field(MAXRESULTS_DESCRIPTOR, it) }
        if (input.metrics != null) {
            listField(METRICS_DESCRIPTOR) {
                for (el0 in input.metrics) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeMetricV2Document))
                }
            }
        }
        input.nextToken?.let { field(NEXTTOKEN_DESCRIPTOR, it) }
        input.resourceArn?.let { field(RESOURCEARN_DESCRIPTOR, it) }
        input.startTime?.let { field(STARTTIME_DESCRIPTOR, it, TimestampFormat.EPOCH_SECONDS) }
    }
    return serializer.toByteArray()
}
