// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.serde

import aws.sdk.kotlin.services.connect.model.Filters
import aws.sdk.kotlin.services.connect.model.GetMetricDataRequest
import aws.sdk.kotlin.services.connect.model.Grouping
import aws.sdk.kotlin.services.connect.model.HistoricalMetric
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class GetMetricDataOperationSerializer: HttpSerializer.NonStreaming<GetMetricDataRequest> {
    override fun serialize(context: ExecutionContext, input: GetMetricDataRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.instanceId) { "instanceId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("metrics"))
                add(PercentEncoding.Path.encode("historical"))
                add(PercentEncoding.SmithyLabel.encode(input.instanceId))
            }
        }

        val payload = serializeGetMetricDataOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeGetMetricDataOperationBody(context: ExecutionContext, input: GetMetricDataRequest): ByteArray {
    val serializer = JsonSerializer()
    val ENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("EndTime"))
    val FILTERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Filters"))
    val GROUPINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Groupings"))
    val HISTORICALMETRICS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("HistoricalMetrics"))
    val MAXRESULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MaxResults"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val STARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("StartTime"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ENDTIME_DESCRIPTOR)
        field(FILTERS_DESCRIPTOR)
        field(GROUPINGS_DESCRIPTOR)
        field(HISTORICALMETRICS_DESCRIPTOR)
        field(MAXRESULTS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(STARTTIME_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.endTime?.let { field(ENDTIME_DESCRIPTOR, it, TimestampFormat.EPOCH_SECONDS) }
        input.filters?.let { field(FILTERS_DESCRIPTOR, it, ::serializeFiltersDocument) }
        if (input.groupings != null) {
            listField(GROUPINGS_DESCRIPTOR) {
                for (el0 in input.groupings) {
                    serializeString(el0.value)
                }
            }
        }
        if (input.historicalMetrics != null) {
            listField(HISTORICALMETRICS_DESCRIPTOR) {
                for (el0 in input.historicalMetrics) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeHistoricalMetricDocument))
                }
            }
        }
        input.maxResults?.let { field(MAXRESULTS_DESCRIPTOR, it) }
        input.nextToken?.let { field(NEXTTOKEN_DESCRIPTOR, it) }
        input.startTime?.let { field(STARTTIME_DESCRIPTOR, it, TimestampFormat.EPOCH_SECONDS) }
    }
    return serializer.toByteArray()
}
