// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.serde

import aws.sdk.kotlin.services.connect.model.CurrentMetric
import aws.sdk.kotlin.services.connect.model.CurrentMetricSortCriteria
import aws.sdk.kotlin.services.connect.model.Filters
import aws.sdk.kotlin.services.connect.model.GetCurrentMetricDataRequest
import aws.sdk.kotlin.services.connect.model.Grouping
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class GetCurrentMetricDataOperationSerializer: HttpSerializer.NonStreaming<GetCurrentMetricDataRequest> {
    override fun serialize(context: ExecutionContext, input: GetCurrentMetricDataRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.instanceId) { "instanceId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("metrics"))
                add(PercentEncoding.Path.encode("current"))
                add(PercentEncoding.SmithyLabel.encode(input.instanceId))
            }
        }

        val payload = serializeGetCurrentMetricDataOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeGetCurrentMetricDataOperationBody(context: ExecutionContext, input: GetCurrentMetricDataRequest): ByteArray {
    val serializer = JsonSerializer()
    val CURRENTMETRICS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("CurrentMetrics"))
    val FILTERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Filters"))
    val GROUPINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Groupings"))
    val MAXRESULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MaxResults"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val SORTCRITERIA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("SortCriteria"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CURRENTMETRICS_DESCRIPTOR)
        field(FILTERS_DESCRIPTOR)
        field(GROUPINGS_DESCRIPTOR)
        field(MAXRESULTS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(SORTCRITERIA_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.currentMetrics != null) {
            listField(CURRENTMETRICS_DESCRIPTOR) {
                for (el0 in input.currentMetrics) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeCurrentMetricDocument))
                }
            }
        }
        input.filters?.let { field(FILTERS_DESCRIPTOR, it, ::serializeFiltersDocument) }
        if (input.groupings != null) {
            listField(GROUPINGS_DESCRIPTOR) {
                for (el0 in input.groupings) {
                    serializeString(el0.value)
                }
            }
        }
        input.maxResults?.let { field(MAXRESULTS_DESCRIPTOR, it) }
        input.nextToken?.let { field(NEXTTOKEN_DESCRIPTOR, it) }
        if (input.sortCriteria != null) {
            listField(SORTCRITERIA_DESCRIPTOR) {
                for (el0 in input.sortCriteria) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeCurrentMetricSortCriteriaDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
