// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.serde

import aws.sdk.kotlin.services.connect.model.ContactConfiguration
import aws.sdk.kotlin.services.connect.model.CreatePushNotificationRegistrationRequest
import aws.sdk.kotlin.services.connect.model.DeviceType
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class CreatePushNotificationRegistrationOperationSerializer: HttpSerializer.NonStreaming<CreatePushNotificationRegistrationRequest> {
    override fun serialize(context: ExecutionContext, input: CreatePushNotificationRegistrationRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.instanceId) { "instanceId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("push-notification"))
                add(PercentEncoding.SmithyLabel.encode(input.instanceId))
                add(PercentEncoding.Path.encode("registrations"))
            }
        }

        val payload = serializeCreatePushNotificationRegistrationOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreatePushNotificationRegistrationOperationBody(context: ExecutionContext, input: CreatePushNotificationRegistrationRequest): ByteArray {
    val serializer = JsonSerializer()
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ClientToken"))
    val CONTACTCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ContactConfiguration"))
    val DEVICETOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DeviceToken"))
    val DEVICETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("DeviceType"))
    val PINPOINTAPPARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PinpointAppArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLIENTTOKEN_DESCRIPTOR)
        field(CONTACTCONFIGURATION_DESCRIPTOR)
        field(DEVICETOKEN_DESCRIPTOR)
        field(DEVICETYPE_DESCRIPTOR)
        field(PINPOINTAPPARN_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.contactConfiguration?.let { field(CONTACTCONFIGURATION_DESCRIPTOR, it, ::serializeContactConfigurationDocument) }
        input.deviceToken?.let { field(DEVICETOKEN_DESCRIPTOR, it) }
        input.deviceType?.let { field(DEVICETYPE_DESCRIPTOR, it.value) }
        input.pinpointAppArn?.let { field(PINPOINTAPPARN_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
