// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.serde

import aws.sdk.kotlin.services.connect.model.CreateContactFlowVersionRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class CreateContactFlowVersionOperationSerializer: HttpSerializer.NonStreaming<CreateContactFlowVersionRequest> {
    override fun serialize(context: ExecutionContext, input: CreateContactFlowVersionRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.instanceId) { "instanceId is bound to the URI and must not be null" }
            requireNotNull(input.contactFlowId) { "contactFlowId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("contact-flows"))
                add(PercentEncoding.SmithyLabel.encode(input.instanceId))
                add(PercentEncoding.SmithyLabel.encode(input.contactFlowId))
                add(PercentEncoding.Path.encode("version"))
            }
        }

        val payload = serializeCreateContactFlowVersionOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateContactFlowVersionOperationBody(context: ExecutionContext, input: CreateContactFlowVersionRequest): ByteArray {
    val serializer = JsonSerializer()
    val CONTACTFLOWVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("ContactFlowVersion"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val FLOWCONTENTSHA256_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FlowContentSha256"))
    val LASTMODIFIEDREGION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LastModifiedRegion"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModifiedTime"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONTACTFLOWVERSION_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(FLOWCONTENTSHA256_DESCRIPTOR)
        field(LASTMODIFIEDREGION_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.contactFlowVersion?.let { field(CONTACTFLOWVERSION_DESCRIPTOR, it) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.flowContentSha256?.let { field(FLOWCONTENTSHA256_DESCRIPTOR, it) }
        input.lastModifiedRegion?.let { field(LASTMODIFIEDREGION_DESCRIPTOR, it) }
        input.lastModifiedTime?.let { field(LASTMODIFIEDTIME_DESCRIPTOR, it, TimestampFormat.EPOCH_SECONDS) }
    }
    return serializer.toByteArray()
}
