// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains information about the identity of a user.
 *
 * For Amazon Connect instances that are created with the `EXISTING_DIRECTORY` identity management type, `FirstName`, `LastName`, and `Email` cannot be updated from within Amazon Connect because they are managed by the directory.
 *
 * The `FirstName` and `LastName` length constraints below apply only to instances using SAML for identity management. If you are using Amazon Connect for identity management, the length constraints are 1-255 for `FirstName`, and 1-256 for `LastName`.
 */
public class UserIdentityInfo private constructor(builder: Builder) {
    /**
     * The email address. If you are using SAML for identity management and include this parameter, an error is returned.
     */
    public val email: kotlin.String? = builder.email
    /**
     * The first name. This is required if you are using Amazon Connect or SAML for identity management. Inputs must be in Unicode Normalization Form C (NFC). Text containing characters in a non-NFC form (for example, decomposed characters or combining marks) are not accepted.
     */
    public val firstName: kotlin.String? = builder.firstName
    /**
     * The last name. This is required if you are using Amazon Connect or SAML for identity management. Inputs must be in Unicode Normalization Form C (NFC). Text containing characters in a non-NFC form (for example, decomposed characters or combining marks) are not accepted.
     */
    public val lastName: kotlin.String? = builder.lastName
    /**
     * The user's mobile number.
     */
    public val mobile: kotlin.String? = builder.mobile
    /**
     * The user's secondary email address. If you provide a secondary email, the user receives email notifications - other than password reset notifications - to this email address instead of to their primary email address.
     *
     * Pattern: `(?=^.{0,265}$)[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,63}`
     */
    public val secondaryEmail: kotlin.String? = builder.secondaryEmail

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.UserIdentityInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UserIdentityInfo(")
        append("email=*** Sensitive Data Redacted ***,")
        append("firstName=*** Sensitive Data Redacted ***,")
        append("lastName=*** Sensitive Data Redacted ***,")
        append("mobile=$mobile,")
        append("secondaryEmail=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = email?.hashCode() ?: 0
        result = 31 * result + (firstName?.hashCode() ?: 0)
        result = 31 * result + (lastName?.hashCode() ?: 0)
        result = 31 * result + (mobile?.hashCode() ?: 0)
        result = 31 * result + (secondaryEmail?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UserIdentityInfo

        if (email != other.email) return false
        if (firstName != other.firstName) return false
        if (lastName != other.lastName) return false
        if (mobile != other.mobile) return false
        if (secondaryEmail != other.secondaryEmail) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.UserIdentityInfo = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The email address. If you are using SAML for identity management and include this parameter, an error is returned.
         */
        public var email: kotlin.String? = null
        /**
         * The first name. This is required if you are using Amazon Connect or SAML for identity management. Inputs must be in Unicode Normalization Form C (NFC). Text containing characters in a non-NFC form (for example, decomposed characters or combining marks) are not accepted.
         */
        public var firstName: kotlin.String? = null
        /**
         * The last name. This is required if you are using Amazon Connect or SAML for identity management. Inputs must be in Unicode Normalization Form C (NFC). Text containing characters in a non-NFC form (for example, decomposed characters or combining marks) are not accepted.
         */
        public var lastName: kotlin.String? = null
        /**
         * The user's mobile number.
         */
        public var mobile: kotlin.String? = null
        /**
         * The user's secondary email address. If you provide a secondary email, the user receives email notifications - other than password reset notifications - to this email address instead of to their primary email address.
         *
         * Pattern: `(?=^.{0,265}$)[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,63}`
         */
        public var secondaryEmail: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.UserIdentityInfo) : this() {
            this.email = x.email
            this.firstName = x.firstName
            this.lastName = x.lastName
            this.mobile = x.mobile
            this.secondaryEmail = x.secondaryEmail
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.UserIdentityInfo = UserIdentityInfo(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
