// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateContactRequest private constructor(builder: Builder) {
    /**
     * The identifier of the contact. This is the identifier of the contact associated with the first interaction with your contact center.
     */
    public val contactId: kotlin.String? = builder.contactId
    /**
     * The endpoint of the customer for which the contact was initiated. For external audio contacts, this is usually the end customer's phone number. This value can only be updated for external audio contacts. For more information, see [Amazon Connect Contact Lens integration](https://docs.aws.amazon.com/connect/latest/adminguide/contact-lens-integration.html) in the *Amazon Connect Administrator Guide*.
     */
    public val customerEndpoint: aws.sdk.kotlin.services.connect.model.Endpoint? = builder.customerEndpoint
    /**
     * The description of the contact.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The identifier of the Amazon Connect instance. You can [find the instance ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html) in the Amazon Resource Name (ARN) of the instance.
     */
    public val instanceId: kotlin.String? = builder.instanceId
    /**
     * The name of the contact.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Information about the queue associated with a contact. This parameter can only be updated for external audio contacts. It is used when you integrate third-party systems with Contact Lens for analytics. For more information, see [Amazon Connect Contact Lens integration](https://docs.aws.amazon.com/connect/latest/adminguide/contact-lens-integration.html) in the * Amazon Connect Administrator Guide*.
     */
    public val queueInfo: aws.sdk.kotlin.services.connect.model.QueueInfoInput? = builder.queueInfo
    /**
     * Well-formed data on contact, shown to agents on Contact Control Panel (CCP).
     */
    public val references: Map<String, Reference>? = builder.references
    /**
     * A set of system defined key-value pairs stored on individual contact segments (unique contact ID) using an attribute map. The attributes are standard Amazon Connect attributes. They can be accessed in flows.
     *
     * Attribute keys can include only alphanumeric, -, and _.
     *
     * This field can be used to show channel subtype, such as `connect:Guide`.
     *
     * Currently Contact Expiry is the only segment attribute which can be updated by using the UpdateContact API.
     */
    public val segmentAttributes: Map<String, SegmentAttributeValue>? = builder.segmentAttributes
    /**
     * External system endpoint for the contact was initiated. For external audio contacts, this is the phone number of the external system such as the contact center. This value can only be updated for external audio contacts. For more information, see [Amazon Connect Contact Lens integration](https://docs.aws.amazon.com/connect/latest/adminguide/contact-lens-integration.html) in the *Amazon Connect Administrator Guide*.
     */
    public val systemEndpoint: aws.sdk.kotlin.services.connect.model.Endpoint? = builder.systemEndpoint
    /**
     * Information about the agent associated with a contact. This parameter can only be updated for external audio contacts. It is used when you integrate third-party systems with Contact Lens for analytics. For more information, see [Amazon Connect Contact Lens integration](https://docs.aws.amazon.com/connect/latest/adminguide/contact-lens-integration.html) in the * Amazon Connect Administrator Guide*.
     */
    public val userInfo: aws.sdk.kotlin.services.connect.model.UserInfo? = builder.userInfo

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.UpdateContactRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateContactRequest(")
        append("contactId=$contactId,")
        append("customerEndpoint=$customerEndpoint,")
        append("description=*** Sensitive Data Redacted ***,")
        append("instanceId=$instanceId,")
        append("name=*** Sensitive Data Redacted ***,")
        append("queueInfo=$queueInfo,")
        append("references=$references,")
        append("segmentAttributes=$segmentAttributes,")
        append("systemEndpoint=$systemEndpoint,")
        append("userInfo=$userInfo")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = contactId?.hashCode() ?: 0
        result = 31 * result + (customerEndpoint?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (queueInfo?.hashCode() ?: 0)
        result = 31 * result + (references?.hashCode() ?: 0)
        result = 31 * result + (segmentAttributes?.hashCode() ?: 0)
        result = 31 * result + (systemEndpoint?.hashCode() ?: 0)
        result = 31 * result + (userInfo?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateContactRequest

        if (contactId != other.contactId) return false
        if (customerEndpoint != other.customerEndpoint) return false
        if (description != other.description) return false
        if (instanceId != other.instanceId) return false
        if (name != other.name) return false
        if (queueInfo != other.queueInfo) return false
        if (references != other.references) return false
        if (segmentAttributes != other.segmentAttributes) return false
        if (systemEndpoint != other.systemEndpoint) return false
        if (userInfo != other.userInfo) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.UpdateContactRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier of the contact. This is the identifier of the contact associated with the first interaction with your contact center.
         */
        public var contactId: kotlin.String? = null
        /**
         * The endpoint of the customer for which the contact was initiated. For external audio contacts, this is usually the end customer's phone number. This value can only be updated for external audio contacts. For more information, see [Amazon Connect Contact Lens integration](https://docs.aws.amazon.com/connect/latest/adminguide/contact-lens-integration.html) in the *Amazon Connect Administrator Guide*.
         */
        public var customerEndpoint: aws.sdk.kotlin.services.connect.model.Endpoint? = null
        /**
         * The description of the contact.
         */
        public var description: kotlin.String? = null
        /**
         * The identifier of the Amazon Connect instance. You can [find the instance ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html) in the Amazon Resource Name (ARN) of the instance.
         */
        public var instanceId: kotlin.String? = null
        /**
         * The name of the contact.
         */
        public var name: kotlin.String? = null
        /**
         * Information about the queue associated with a contact. This parameter can only be updated for external audio contacts. It is used when you integrate third-party systems with Contact Lens for analytics. For more information, see [Amazon Connect Contact Lens integration](https://docs.aws.amazon.com/connect/latest/adminguide/contact-lens-integration.html) in the * Amazon Connect Administrator Guide*.
         */
        public var queueInfo: aws.sdk.kotlin.services.connect.model.QueueInfoInput? = null
        /**
         * Well-formed data on contact, shown to agents on Contact Control Panel (CCP).
         */
        public var references: Map<String, Reference>? = null
        /**
         * A set of system defined key-value pairs stored on individual contact segments (unique contact ID) using an attribute map. The attributes are standard Amazon Connect attributes. They can be accessed in flows.
         *
         * Attribute keys can include only alphanumeric, -, and _.
         *
         * This field can be used to show channel subtype, such as `connect:Guide`.
         *
         * Currently Contact Expiry is the only segment attribute which can be updated by using the UpdateContact API.
         */
        public var segmentAttributes: Map<String, SegmentAttributeValue>? = null
        /**
         * External system endpoint for the contact was initiated. For external audio contacts, this is the phone number of the external system such as the contact center. This value can only be updated for external audio contacts. For more information, see [Amazon Connect Contact Lens integration](https://docs.aws.amazon.com/connect/latest/adminguide/contact-lens-integration.html) in the *Amazon Connect Administrator Guide*.
         */
        public var systemEndpoint: aws.sdk.kotlin.services.connect.model.Endpoint? = null
        /**
         * Information about the agent associated with a contact. This parameter can only be updated for external audio contacts. It is used when you integrate third-party systems with Contact Lens for analytics. For more information, see [Amazon Connect Contact Lens integration](https://docs.aws.amazon.com/connect/latest/adminguide/contact-lens-integration.html) in the * Amazon Connect Administrator Guide*.
         */
        public var userInfo: aws.sdk.kotlin.services.connect.model.UserInfo? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.UpdateContactRequest) : this() {
            this.contactId = x.contactId
            this.customerEndpoint = x.customerEndpoint
            this.description = x.description
            this.instanceId = x.instanceId
            this.name = x.name
            this.queueInfo = x.queueInfo
            this.references = x.references
            this.segmentAttributes = x.segmentAttributes
            this.systemEndpoint = x.systemEndpoint
            this.userInfo = x.userInfo
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.UpdateContactRequest = UpdateContactRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.Endpoint] inside the given [block]
         */
        public fun customerEndpoint(block: aws.sdk.kotlin.services.connect.model.Endpoint.Builder.() -> kotlin.Unit) {
            this.customerEndpoint = aws.sdk.kotlin.services.connect.model.Endpoint.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.QueueInfoInput] inside the given [block]
         */
        public fun queueInfo(block: aws.sdk.kotlin.services.connect.model.QueueInfoInput.Builder.() -> kotlin.Unit) {
            this.queueInfo = aws.sdk.kotlin.services.connect.model.QueueInfoInput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.Endpoint] inside the given [block]
         */
        public fun systemEndpoint(block: aws.sdk.kotlin.services.connect.model.Endpoint.Builder.() -> kotlin.Unit) {
            this.systemEndpoint = aws.sdk.kotlin.services.connect.model.Endpoint.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.UserInfo] inside the given [block]
         */
        public fun userInfo(block: aws.sdk.kotlin.services.connect.model.UserInfo.Builder.() -> kotlin.Unit) {
            this.userInfo = aws.sdk.kotlin.services.connect.model.UserInfo.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
