// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.SdkDsl

public class StartOutboundChatContactRequest private constructor(builder: Builder) {
    /**
     * A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes, and can be accessed in flows just like any other contact attributes.
     */
    public val attributes: Map<String, String>? = builder.attributes
    /**
     * The total duration of the newly started chat session. If not specified, the chat session duration defaults to 25 hour. The minimum configurable time is 60 minutes. The maximum configurable time is 10,080 minutes (7 days).
     */
    public val chatDurationInMinutes: kotlin.Int? = builder.chatDurationInMinutes
    /**
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the AWS SDK populates this field. For more information about idempotency, see [Making retries safe with idempotent APIs](https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/). The token is valid for 7 days after creation. If a contact is already started, the contact ID is returned.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The identifier of the flow for the call. To see the ContactFlowId in the Amazon Connect console user interface, on the navigation menu go to **Routing, Contact Flows**. Choose the flow. On the flow page, under the name of the flow, choose **Show additional flow information**. The ContactFlowId is the last part of the ARN, shown here in bold:
     * + arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow&#47;**123ec456-a007-89c0-1234-xxxxxxxxxxxx**
     */
    public val contactFlowId: kotlin.String? = builder.contactFlowId
    /**
     * Information about the endpoint.
     */
    public val destinationEndpoint: aws.sdk.kotlin.services.connect.model.Endpoint? = builder.destinationEndpoint
    /**
     * A chat message.
     */
    public val initialSystemMessage: aws.sdk.kotlin.services.connect.model.ChatMessage? = builder.initialSystemMessage
    /**
     * The identifier of the Amazon Connect instance. You can find the instance ID in the Amazon Resource Name (ARN) of the instance.
     */
    public val instanceId: kotlin.String? = builder.instanceId
    /**
     * The customer's details.
     */
    public val participantDetails: aws.sdk.kotlin.services.connect.model.ParticipantDetails? = builder.participantDetails
    /**
     * The unique identifier for an Amazon Connect contact. This identifier is related to the contact starting.
     */
    public val relatedContactId: kotlin.String? = builder.relatedContactId
    /**
     * A set of system defined key-value pairs stored on individual contact segments using an attribute map. The attributes are standard Amazon Connect attributes. They can be accessed in flows.
     * + Attribute keys can include only alphanumeric, `-`, and `_`.
     * + This field can be used to show channel subtype, such as `connect:Guide` and `connect:SMS`.
     */
    public val segmentAttributes: Map<String, SegmentAttributeValue>? = builder.segmentAttributes
    /**
     * Information about the endpoint.
     */
    public val sourceEndpoint: aws.sdk.kotlin.services.connect.model.Endpoint? = builder.sourceEndpoint
    /**
     * The supported chat message content types. Supported types are:
     * + `text/plain`
     * + `text/markdown`
     * + `application/json, application/vnd.amazonaws.connect.message.interactive`
     * + `application/vnd.amazonaws.connect.message.interactive.response`
     *
     * Content types must always contain `text/plain`. You can then put any other supported type in the list. For example, all the following lists are valid because they contain `text/plain`:
     * + `[text/plain, text/markdown, application/json]`
     * + `[text/markdown, text/plain]`
     * + `[text/plain, application/json, application/vnd.amazonaws.connect.message.interactive.response]`
     */
    public val supportedMessagingContentTypes: List<String>? = builder.supportedMessagingContentTypes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.StartOutboundChatContactRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartOutboundChatContactRequest(")
        append("attributes=$attributes,")
        append("chatDurationInMinutes=$chatDurationInMinutes,")
        append("clientToken=$clientToken,")
        append("contactFlowId=$contactFlowId,")
        append("destinationEndpoint=$destinationEndpoint,")
        append("initialSystemMessage=$initialSystemMessage,")
        append("instanceId=$instanceId,")
        append("participantDetails=$participantDetails,")
        append("relatedContactId=$relatedContactId,")
        append("segmentAttributes=$segmentAttributes,")
        append("sourceEndpoint=$sourceEndpoint,")
        append("supportedMessagingContentTypes=$supportedMessagingContentTypes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributes?.hashCode() ?: 0
        result = 31 * result + (chatDurationInMinutes ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (contactFlowId?.hashCode() ?: 0)
        result = 31 * result + (destinationEndpoint?.hashCode() ?: 0)
        result = 31 * result + (initialSystemMessage?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (participantDetails?.hashCode() ?: 0)
        result = 31 * result + (relatedContactId?.hashCode() ?: 0)
        result = 31 * result + (segmentAttributes?.hashCode() ?: 0)
        result = 31 * result + (sourceEndpoint?.hashCode() ?: 0)
        result = 31 * result + (supportedMessagingContentTypes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartOutboundChatContactRequest

        if (attributes != other.attributes) return false
        if (chatDurationInMinutes != other.chatDurationInMinutes) return false
        if (clientToken != other.clientToken) return false
        if (contactFlowId != other.contactFlowId) return false
        if (destinationEndpoint != other.destinationEndpoint) return false
        if (initialSystemMessage != other.initialSystemMessage) return false
        if (instanceId != other.instanceId) return false
        if (participantDetails != other.participantDetails) return false
        if (relatedContactId != other.relatedContactId) return false
        if (segmentAttributes != other.segmentAttributes) return false
        if (sourceEndpoint != other.sourceEndpoint) return false
        if (supportedMessagingContentTypes != other.supportedMessagingContentTypes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.StartOutboundChatContactRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes, and can be accessed in flows just like any other contact attributes.
         */
        public var attributes: Map<String, String>? = null
        /**
         * The total duration of the newly started chat session. If not specified, the chat session duration defaults to 25 hour. The minimum configurable time is 60 minutes. The maximum configurable time is 10,080 minutes (7 days).
         */
        public var chatDurationInMinutes: kotlin.Int? = null
        /**
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the AWS SDK populates this field. For more information about idempotency, see [Making retries safe with idempotent APIs](https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/). The token is valid for 7 days after creation. If a contact is already started, the contact ID is returned.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The identifier of the flow for the call. To see the ContactFlowId in the Amazon Connect console user interface, on the navigation menu go to **Routing, Contact Flows**. Choose the flow. On the flow page, under the name of the flow, choose **Show additional flow information**. The ContactFlowId is the last part of the ARN, shown here in bold:
         * + arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow&#47;**123ec456-a007-89c0-1234-xxxxxxxxxxxx**
         */
        public var contactFlowId: kotlin.String? = null
        /**
         * Information about the endpoint.
         */
        public var destinationEndpoint: aws.sdk.kotlin.services.connect.model.Endpoint? = null
        /**
         * A chat message.
         */
        public var initialSystemMessage: aws.sdk.kotlin.services.connect.model.ChatMessage? = null
        /**
         * The identifier of the Amazon Connect instance. You can find the instance ID in the Amazon Resource Name (ARN) of the instance.
         */
        public var instanceId: kotlin.String? = null
        /**
         * The customer's details.
         */
        public var participantDetails: aws.sdk.kotlin.services.connect.model.ParticipantDetails? = null
        /**
         * The unique identifier for an Amazon Connect contact. This identifier is related to the contact starting.
         */
        public var relatedContactId: kotlin.String? = null
        /**
         * A set of system defined key-value pairs stored on individual contact segments using an attribute map. The attributes are standard Amazon Connect attributes. They can be accessed in flows.
         * + Attribute keys can include only alphanumeric, `-`, and `_`.
         * + This field can be used to show channel subtype, such as `connect:Guide` and `connect:SMS`.
         */
        public var segmentAttributes: Map<String, SegmentAttributeValue>? = null
        /**
         * Information about the endpoint.
         */
        public var sourceEndpoint: aws.sdk.kotlin.services.connect.model.Endpoint? = null
        /**
         * The supported chat message content types. Supported types are:
         * + `text/plain`
         * + `text/markdown`
         * + `application/json, application/vnd.amazonaws.connect.message.interactive`
         * + `application/vnd.amazonaws.connect.message.interactive.response`
         *
         * Content types must always contain `text/plain`. You can then put any other supported type in the list. For example, all the following lists are valid because they contain `text/plain`:
         * + `[text/plain, text/markdown, application/json]`
         * + `[text/markdown, text/plain]`
         * + `[text/plain, application/json, application/vnd.amazonaws.connect.message.interactive.response]`
         */
        public var supportedMessagingContentTypes: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.StartOutboundChatContactRequest) : this() {
            this.attributes = x.attributes
            this.chatDurationInMinutes = x.chatDurationInMinutes
            this.clientToken = x.clientToken
            this.contactFlowId = x.contactFlowId
            this.destinationEndpoint = x.destinationEndpoint
            this.initialSystemMessage = x.initialSystemMessage
            this.instanceId = x.instanceId
            this.participantDetails = x.participantDetails
            this.relatedContactId = x.relatedContactId
            this.segmentAttributes = x.segmentAttributes
            this.sourceEndpoint = x.sourceEndpoint
            this.supportedMessagingContentTypes = x.supportedMessagingContentTypes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.StartOutboundChatContactRequest = StartOutboundChatContactRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.Endpoint] inside the given [block]
         */
        public fun destinationEndpoint(block: aws.sdk.kotlin.services.connect.model.Endpoint.Builder.() -> kotlin.Unit) {
            this.destinationEndpoint = aws.sdk.kotlin.services.connect.model.Endpoint.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.ChatMessage] inside the given [block]
         */
        public fun initialSystemMessage(block: aws.sdk.kotlin.services.connect.model.ChatMessage.Builder.() -> kotlin.Unit) {
            this.initialSystemMessage = aws.sdk.kotlin.services.connect.model.ChatMessage.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.ParticipantDetails] inside the given [block]
         */
        public fun participantDetails(block: aws.sdk.kotlin.services.connect.model.ParticipantDetails.Builder.() -> kotlin.Unit) {
            this.participantDetails = aws.sdk.kotlin.services.connect.model.ParticipantDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.Endpoint] inside the given [block]
         */
        public fun sourceEndpoint(block: aws.sdk.kotlin.services.connect.model.Endpoint.Builder.() -> kotlin.Unit) {
            this.sourceEndpoint = aws.sdk.kotlin.services.connect.model.Endpoint.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
