// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.SdkDsl

public class StartEmailContactRequest private constructor(builder: Builder) {
    /**
     * The addtional recipients address of the email.
     */
    public val additionalRecipients: aws.sdk.kotlin.services.connect.model.InboundAdditionalRecipients? = builder.additionalRecipients
    /**
     * List of S3 presigned URLs of email attachments and their file name.
     */
    public val attachments: List<EmailAttachment>? = builder.attachments
    /**
     * A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes, and can be accessed in flows just like any other contact attributes.
     *
     * There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include only alphanumeric, dash, and underscore characters.
     */
    public val attributes: Map<String, String>? = builder.attributes
    /**
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see [Making retries safe with idempotent APIs](https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The identifier of the flow for initiating the emails. To see the ContactFlowId in the Amazon Connect admin website, on the navigation menu go to **Routing**, **Flows**. Choose the flow. On the flow page, under the name of the flow, choose **Show additional flow information**. The ContactFlowId is the last part of the ARN, shown here in bold:
     *
     * arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow&#47;**846ec553-a005-41c0-8341-xxxxxxxxxxxx**
     */
    public val contactFlowId: kotlin.String? = builder.contactFlowId
    /**
     * A description of the email contact.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The email address associated with the instance.
     */
    public val destinationEmailAddress: kotlin.String? = builder.destinationEmailAddress
    /**
     * The email message body to be sent to the newly created email.
     */
    public val emailMessage: aws.sdk.kotlin.services.connect.model.InboundEmailContent? = builder.emailMessage
    /**
     * The email address of the customer.
     */
    public val fromEmailAddress: aws.sdk.kotlin.services.connect.model.EmailAddressInfo? = builder.fromEmailAddress
    /**
     * The identifier of the Amazon Connect instance. You can [find the instance ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html) in the Amazon Resource Name (ARN) of the instance.
     */
    public val instanceId: kotlin.String? = builder.instanceId
    /**
     * The name of a email that is shown to an agent in the Contact Control Panel (CCP).
     */
    public val name: kotlin.String? = builder.name
    /**
     * A formatted URL that is shown to an agent in the Contact Control Panel (CCP). Emails can have the following reference types at the time of creation: `URL` | `NUMBER` | `STRING` | `DATE`. `EMAIL` | `EMAIL_MESSAGE` |`ATTACHMENT` are not a supported reference type during email creation.
     */
    public val references: Map<String, Reference>? = builder.references
    /**
     * The contactId that is related to this contact. Linking emails together by using `RelatedContactID` copies over contact attributes from the related email contact to the new email contact. All updates to user-defined attributes in the new email contact are limited to the individual contact ID. There are no limits to the number of contacts that can be linked by using `RelatedContactId`.
     */
    public val relatedContactId: kotlin.String? = builder.relatedContactId
    /**
     * A set of system defined key-value pairs stored on individual contact segments using an attribute map. The attributes are standard Amazon Connect attributes. They can be accessed in flows.
     *
     * Attribute keys can include only alphanumeric, -, and _.
     *
     * This field can be used to show channel subtype, such as `connect:Guide`.
     *
     * To set contact expiry, a `ValueMap` must be specified containing the integer number of minutes the contact will be active for before expiring, with `SegmentAttributes` like { ` "connect:ContactExpiry": {"ValueMap" : { "ExpiryDuration": { "ValueInteger":135}}}}`.
     */
    public val segmentAttributes: Map<String, SegmentAttributeValue>? = builder.segmentAttributes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.StartEmailContactRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartEmailContactRequest(")
        append("additionalRecipients=$additionalRecipients,")
        append("attachments=*** Sensitive Data Redacted ***,")
        append("attributes=$attributes,")
        append("clientToken=$clientToken,")
        append("contactFlowId=$contactFlowId,")
        append("description=*** Sensitive Data Redacted ***,")
        append("destinationEmailAddress=*** Sensitive Data Redacted ***,")
        append("emailMessage=$emailMessage,")
        append("fromEmailAddress=$fromEmailAddress,")
        append("instanceId=$instanceId,")
        append("name=*** Sensitive Data Redacted ***,")
        append("references=$references,")
        append("relatedContactId=$relatedContactId,")
        append("segmentAttributes=$segmentAttributes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalRecipients?.hashCode() ?: 0
        result = 31 * result + (attachments?.hashCode() ?: 0)
        result = 31 * result + (attributes?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (contactFlowId?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (destinationEmailAddress?.hashCode() ?: 0)
        result = 31 * result + (emailMessage?.hashCode() ?: 0)
        result = 31 * result + (fromEmailAddress?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (references?.hashCode() ?: 0)
        result = 31 * result + (relatedContactId?.hashCode() ?: 0)
        result = 31 * result + (segmentAttributes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartEmailContactRequest

        if (additionalRecipients != other.additionalRecipients) return false
        if (attachments != other.attachments) return false
        if (attributes != other.attributes) return false
        if (clientToken != other.clientToken) return false
        if (contactFlowId != other.contactFlowId) return false
        if (description != other.description) return false
        if (destinationEmailAddress != other.destinationEmailAddress) return false
        if (emailMessage != other.emailMessage) return false
        if (fromEmailAddress != other.fromEmailAddress) return false
        if (instanceId != other.instanceId) return false
        if (name != other.name) return false
        if (references != other.references) return false
        if (relatedContactId != other.relatedContactId) return false
        if (segmentAttributes != other.segmentAttributes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.StartEmailContactRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The addtional recipients address of the email.
         */
        public var additionalRecipients: aws.sdk.kotlin.services.connect.model.InboundAdditionalRecipients? = null
        /**
         * List of S3 presigned URLs of email attachments and their file name.
         */
        public var attachments: List<EmailAttachment>? = null
        /**
         * A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes, and can be accessed in flows just like any other contact attributes.
         *
         * There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include only alphanumeric, dash, and underscore characters.
         */
        public var attributes: Map<String, String>? = null
        /**
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see [Making retries safe with idempotent APIs](https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
         */
        public var clientToken: kotlin.String? = null
        /**
         * The identifier of the flow for initiating the emails. To see the ContactFlowId in the Amazon Connect admin website, on the navigation menu go to **Routing**, **Flows**. Choose the flow. On the flow page, under the name of the flow, choose **Show additional flow information**. The ContactFlowId is the last part of the ARN, shown here in bold:
         *
         * arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow&#47;**846ec553-a005-41c0-8341-xxxxxxxxxxxx**
         */
        public var contactFlowId: kotlin.String? = null
        /**
         * A description of the email contact.
         */
        public var description: kotlin.String? = null
        /**
         * The email address associated with the instance.
         */
        public var destinationEmailAddress: kotlin.String? = null
        /**
         * The email message body to be sent to the newly created email.
         */
        public var emailMessage: aws.sdk.kotlin.services.connect.model.InboundEmailContent? = null
        /**
         * The email address of the customer.
         */
        public var fromEmailAddress: aws.sdk.kotlin.services.connect.model.EmailAddressInfo? = null
        /**
         * The identifier of the Amazon Connect instance. You can [find the instance ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html) in the Amazon Resource Name (ARN) of the instance.
         */
        public var instanceId: kotlin.String? = null
        /**
         * The name of a email that is shown to an agent in the Contact Control Panel (CCP).
         */
        public var name: kotlin.String? = null
        /**
         * A formatted URL that is shown to an agent in the Contact Control Panel (CCP). Emails can have the following reference types at the time of creation: `URL` | `NUMBER` | `STRING` | `DATE`. `EMAIL` | `EMAIL_MESSAGE` |`ATTACHMENT` are not a supported reference type during email creation.
         */
        public var references: Map<String, Reference>? = null
        /**
         * The contactId that is related to this contact. Linking emails together by using `RelatedContactID` copies over contact attributes from the related email contact to the new email contact. All updates to user-defined attributes in the new email contact are limited to the individual contact ID. There are no limits to the number of contacts that can be linked by using `RelatedContactId`.
         */
        public var relatedContactId: kotlin.String? = null
        /**
         * A set of system defined key-value pairs stored on individual contact segments using an attribute map. The attributes are standard Amazon Connect attributes. They can be accessed in flows.
         *
         * Attribute keys can include only alphanumeric, -, and _.
         *
         * This field can be used to show channel subtype, such as `connect:Guide`.
         *
         * To set contact expiry, a `ValueMap` must be specified containing the integer number of minutes the contact will be active for before expiring, with `SegmentAttributes` like { ` "connect:ContactExpiry": {"ValueMap" : { "ExpiryDuration": { "ValueInteger":135}}}}`.
         */
        public var segmentAttributes: Map<String, SegmentAttributeValue>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.StartEmailContactRequest) : this() {
            this.additionalRecipients = x.additionalRecipients
            this.attachments = x.attachments
            this.attributes = x.attributes
            this.clientToken = x.clientToken
            this.contactFlowId = x.contactFlowId
            this.description = x.description
            this.destinationEmailAddress = x.destinationEmailAddress
            this.emailMessage = x.emailMessage
            this.fromEmailAddress = x.fromEmailAddress
            this.instanceId = x.instanceId
            this.name = x.name
            this.references = x.references
            this.relatedContactId = x.relatedContactId
            this.segmentAttributes = x.segmentAttributes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.StartEmailContactRequest = StartEmailContactRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.InboundAdditionalRecipients] inside the given [block]
         */
        public fun additionalRecipients(block: aws.sdk.kotlin.services.connect.model.InboundAdditionalRecipients.Builder.() -> kotlin.Unit) {
            this.additionalRecipients = aws.sdk.kotlin.services.connect.model.InboundAdditionalRecipients.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.InboundEmailContent] inside the given [block]
         */
        public fun emailMessage(block: aws.sdk.kotlin.services.connect.model.InboundEmailContent.Builder.() -> kotlin.Unit) {
            this.emailMessage = aws.sdk.kotlin.services.connect.model.InboundEmailContent.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.EmailAddressInfo] inside the given [block]
         */
        public fun fromEmailAddress(block: aws.sdk.kotlin.services.connect.model.EmailAddressInfo.Builder.() -> kotlin.Unit) {
            this.fromEmailAddress = aws.sdk.kotlin.services.connect.model.EmailAddressInfo.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
