// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.SdkDsl

public class StartAttachedFileUploadRequest private constructor(builder: Builder) {
    /**
     * The resource to which the attached file is (being) uploaded to. The supported resources are [Cases](https://docs.aws.amazon.com/connect/latest/adminguide/cases.html) and [Email](https://docs.aws.amazon.com/connect/latest/adminguide/setup-email-channel.html).
     *
     * This value must be a valid ARN.
     */
    public val associatedResourceArn: kotlin.String? = builder.associatedResourceArn
    /**
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see [Making retries safe with idempotent APIs](https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * Represents the identity that created the file.
     */
    public val createdBy: aws.sdk.kotlin.services.connect.model.CreatedByInfo? = builder.createdBy
    /**
     * A case-sensitive name of the attached file being uploaded.
     */
    public val fileName: kotlin.String? = builder.fileName
    /**
     * The size of the attached file in bytes.
     */
    public val fileSizeInBytes: kotlin.Long? = builder.fileSizeInBytes
    /**
     * The use case for the file.
     *
     *  Only `ATTACHMENTS` are supported.
     */
    public val fileUseCaseType: aws.sdk.kotlin.services.connect.model.FileUseCaseType? = builder.fileUseCaseType
    /**
     * The unique identifier of the Amazon Connect instance.
     */
    public val instanceId: kotlin.String? = builder.instanceId
    /**
     * The tags used to organize, track, or control access for this resource. For example, `{ "Tags": {"key1":"value1", "key2":"value2"} }`.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * Optional override for the expiry of the pre-signed S3 URL in seconds. The default value is 300.
     */
    public val urlExpiryInSeconds: kotlin.Int? = builder.urlExpiryInSeconds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.StartAttachedFileUploadRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartAttachedFileUploadRequest(")
        append("associatedResourceArn=$associatedResourceArn,")
        append("clientToken=$clientToken,")
        append("createdBy=$createdBy,")
        append("fileName=$fileName,")
        append("fileSizeInBytes=$fileSizeInBytes,")
        append("fileUseCaseType=$fileUseCaseType,")
        append("instanceId=$instanceId,")
        append("tags=$tags,")
        append("urlExpiryInSeconds=$urlExpiryInSeconds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = associatedResourceArn?.hashCode() ?: 0
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (createdBy?.hashCode() ?: 0)
        result = 31 * result + (fileName?.hashCode() ?: 0)
        result = 31 * result + (fileSizeInBytes?.hashCode() ?: 0)
        result = 31 * result + (fileUseCaseType?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (urlExpiryInSeconds ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartAttachedFileUploadRequest

        if (associatedResourceArn != other.associatedResourceArn) return false
        if (clientToken != other.clientToken) return false
        if (createdBy != other.createdBy) return false
        if (fileName != other.fileName) return false
        if (fileSizeInBytes != other.fileSizeInBytes) return false
        if (fileUseCaseType != other.fileUseCaseType) return false
        if (instanceId != other.instanceId) return false
        if (tags != other.tags) return false
        if (urlExpiryInSeconds != other.urlExpiryInSeconds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.StartAttachedFileUploadRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The resource to which the attached file is (being) uploaded to. The supported resources are [Cases](https://docs.aws.amazon.com/connect/latest/adminguide/cases.html) and [Email](https://docs.aws.amazon.com/connect/latest/adminguide/setup-email-channel.html).
         *
         * This value must be a valid ARN.
         */
        public var associatedResourceArn: kotlin.String? = null
        /**
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see [Making retries safe with idempotent APIs](https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
         */
        public var clientToken: kotlin.String? = null
        /**
         * Represents the identity that created the file.
         */
        public var createdBy: aws.sdk.kotlin.services.connect.model.CreatedByInfo? = null
        /**
         * A case-sensitive name of the attached file being uploaded.
         */
        public var fileName: kotlin.String? = null
        /**
         * The size of the attached file in bytes.
         */
        public var fileSizeInBytes: kotlin.Long? = null
        /**
         * The use case for the file.
         *
         *  Only `ATTACHMENTS` are supported.
         */
        public var fileUseCaseType: aws.sdk.kotlin.services.connect.model.FileUseCaseType? = null
        /**
         * The unique identifier of the Amazon Connect instance.
         */
        public var instanceId: kotlin.String? = null
        /**
         * The tags used to organize, track, or control access for this resource. For example, `{ "Tags": {"key1":"value1", "key2":"value2"} }`.
         */
        public var tags: Map<String, String>? = null
        /**
         * Optional override for the expiry of the pre-signed S3 URL in seconds. The default value is 300.
         */
        public var urlExpiryInSeconds: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.StartAttachedFileUploadRequest) : this() {
            this.associatedResourceArn = x.associatedResourceArn
            this.clientToken = x.clientToken
            this.createdBy = x.createdBy
            this.fileName = x.fileName
            this.fileSizeInBytes = x.fileSizeInBytes
            this.fileUseCaseType = x.fileUseCaseType
            this.instanceId = x.instanceId
            this.tags = x.tags
            this.urlExpiryInSeconds = x.urlExpiryInSeconds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.StartAttachedFileUploadRequest = StartAttachedFileUploadRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
