// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about a security profile.
 */
public class SecurityProfile private constructor(builder: Builder) {
    /**
     * The identifier of the hierarchy group that a security profile uses to restrict access to resources in Amazon Connect.
     */
    public val allowedAccessControlHierarchyGroupId: kotlin.String? = builder.allowedAccessControlHierarchyGroupId
    /**
     * The list of tags that a security profile uses to restrict access to resources in Amazon Connect.
     */
    public val allowedAccessControlTags: Map<String, String>? = builder.allowedAccessControlTags
    /**
     * The Amazon Resource Name (ARN) for the security profile.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The description of the security profile.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The list of resources that a security profile applies hierarchy restrictions to in Amazon Connect. Following are acceptable ResourceNames: `User`.
     */
    public val hierarchyRestrictedResources: List<String>? = builder.hierarchyRestrictedResources
    /**
     * The identifier for the security profile.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The Amazon Web Services Region where this resource was last modified.
     */
    public val lastModifiedRegion: kotlin.String? = builder.lastModifiedRegion
    /**
     * The timestamp when this resource was last modified.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The organization resource identifier for the security profile.
     */
    public val organizationResourceId: kotlin.String? = builder.organizationResourceId
    /**
     * The name for the security profile.
     */
    public val securityProfileName: kotlin.String? = builder.securityProfileName
    /**
     * The list of resources that a security profile applies tag restrictions to in Amazon Connect.
     */
    public val tagRestrictedResources: List<String>? = builder.tagRestrictedResources
    /**
     * The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.SecurityProfile = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SecurityProfile(")
        append("allowedAccessControlHierarchyGroupId=$allowedAccessControlHierarchyGroupId,")
        append("allowedAccessControlTags=$allowedAccessControlTags,")
        append("arn=$arn,")
        append("description=$description,")
        append("hierarchyRestrictedResources=$hierarchyRestrictedResources,")
        append("id=$id,")
        append("lastModifiedRegion=$lastModifiedRegion,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("organizationResourceId=$organizationResourceId,")
        append("securityProfileName=$securityProfileName,")
        append("tagRestrictedResources=$tagRestrictedResources,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowedAccessControlHierarchyGroupId?.hashCode() ?: 0
        result = 31 * result + (allowedAccessControlTags?.hashCode() ?: 0)
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (hierarchyRestrictedResources?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedRegion?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (organizationResourceId?.hashCode() ?: 0)
        result = 31 * result + (securityProfileName?.hashCode() ?: 0)
        result = 31 * result + (tagRestrictedResources?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SecurityProfile

        if (allowedAccessControlHierarchyGroupId != other.allowedAccessControlHierarchyGroupId) return false
        if (allowedAccessControlTags != other.allowedAccessControlTags) return false
        if (arn != other.arn) return false
        if (description != other.description) return false
        if (hierarchyRestrictedResources != other.hierarchyRestrictedResources) return false
        if (id != other.id) return false
        if (lastModifiedRegion != other.lastModifiedRegion) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (organizationResourceId != other.organizationResourceId) return false
        if (securityProfileName != other.securityProfileName) return false
        if (tagRestrictedResources != other.tagRestrictedResources) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.SecurityProfile = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier of the hierarchy group that a security profile uses to restrict access to resources in Amazon Connect.
         */
        public var allowedAccessControlHierarchyGroupId: kotlin.String? = null
        /**
         * The list of tags that a security profile uses to restrict access to resources in Amazon Connect.
         */
        public var allowedAccessControlTags: Map<String, String>? = null
        /**
         * The Amazon Resource Name (ARN) for the security profile.
         */
        public var arn: kotlin.String? = null
        /**
         * The description of the security profile.
         */
        public var description: kotlin.String? = null
        /**
         * The list of resources that a security profile applies hierarchy restrictions to in Amazon Connect. Following are acceptable ResourceNames: `User`.
         */
        public var hierarchyRestrictedResources: List<String>? = null
        /**
         * The identifier for the security profile.
         */
        public var id: kotlin.String? = null
        /**
         * The Amazon Web Services Region where this resource was last modified.
         */
        public var lastModifiedRegion: kotlin.String? = null
        /**
         * The timestamp when this resource was last modified.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The organization resource identifier for the security profile.
         */
        public var organizationResourceId: kotlin.String? = null
        /**
         * The name for the security profile.
         */
        public var securityProfileName: kotlin.String? = null
        /**
         * The list of resources that a security profile applies tag restrictions to in Amazon Connect.
         */
        public var tagRestrictedResources: List<String>? = null
        /**
         * The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.SecurityProfile) : this() {
            this.allowedAccessControlHierarchyGroupId = x.allowedAccessControlHierarchyGroupId
            this.allowedAccessControlTags = x.allowedAccessControlTags
            this.arn = x.arn
            this.description = x.description
            this.hierarchyRestrictedResources = x.hierarchyRestrictedResources
            this.id = x.id
            this.lastModifiedRegion = x.lastModifiedRegion
            this.lastModifiedTime = x.lastModifiedTime
            this.organizationResourceId = x.organizationResourceId
            this.securityProfileName = x.securityProfileName
            this.tagRestrictedResources = x.tagRestrictedResources
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.SecurityProfile = SecurityProfile(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
