// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.SdkDsl

public class SearchContactsRequest private constructor(builder: Builder) {
    /**
     * The identifier of Amazon Connect instance. You can find the instance ID in the Amazon Resource Name (ARN) of the instance.
     */
    public val instanceId: kotlin.String? = builder.instanceId
    /**
     * The maximum number of results to return per page.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The search criteria to be used to return contacts.
     */
    public val searchCriteria: aws.sdk.kotlin.services.connect.model.SearchCriteria? = builder.searchCriteria
    /**
     * Specifies a field to sort by and a sort order.
     */
    public val sort: aws.sdk.kotlin.services.connect.model.Sort? = builder.sort
    /**
     * Time range that you want to search results.
     */
    public val timeRange: aws.sdk.kotlin.services.connect.model.SearchContactsTimeRange? = builder.timeRange

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.SearchContactsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SearchContactsRequest(")
        append("instanceId=$instanceId,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("searchCriteria=$searchCriteria,")
        append("sort=$sort,")
        append("timeRange=$timeRange")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = instanceId?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (searchCriteria?.hashCode() ?: 0)
        result = 31 * result + (sort?.hashCode() ?: 0)
        result = 31 * result + (timeRange?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SearchContactsRequest

        if (instanceId != other.instanceId) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (searchCriteria != other.searchCriteria) return false
        if (sort != other.sort) return false
        if (timeRange != other.timeRange) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.SearchContactsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier of Amazon Connect instance. You can find the instance ID in the Amazon Resource Name (ARN) of the instance.
         */
        public var instanceId: kotlin.String? = null
        /**
         * The maximum number of results to return per page.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The search criteria to be used to return contacts.
         */
        public var searchCriteria: aws.sdk.kotlin.services.connect.model.SearchCriteria? = null
        /**
         * Specifies a field to sort by and a sort order.
         */
        public var sort: aws.sdk.kotlin.services.connect.model.Sort? = null
        /**
         * Time range that you want to search results.
         */
        public var timeRange: aws.sdk.kotlin.services.connect.model.SearchContactsTimeRange? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.SearchContactsRequest) : this() {
            this.instanceId = x.instanceId
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.searchCriteria = x.searchCriteria
            this.sort = x.sort
            this.timeRange = x.timeRange
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.SearchContactsRequest = SearchContactsRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.SearchCriteria] inside the given [block]
         */
        public fun searchCriteria(block: aws.sdk.kotlin.services.connect.model.SearchCriteria.Builder.() -> kotlin.Unit) {
            this.searchCriteria = aws.sdk.kotlin.services.connect.model.SearchCriteria.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.Sort] inside the given [block]
         */
        public fun sort(block: aws.sdk.kotlin.services.connect.model.Sort.Builder.() -> kotlin.Unit) {
            this.sort = aws.sdk.kotlin.services.connect.model.Sort.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.SearchContactsTimeRange] inside the given [block]
         */
        public fun timeRange(block: aws.sdk.kotlin.services.connect.model.SearchContactsTimeRange.Builder.() -> kotlin.Unit) {
            this.timeRange = aws.sdk.kotlin.services.connect.model.SearchContactsTimeRange.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
