// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Latest routing criteria on the contact.
 */
public class RoutingCriteria private constructor(builder: Builder) {
    /**
     * The timestamp indicating when the routing criteria is set to active. A routing criteria is activated when contact is transferred to a queue. ActivationTimestamp will be set on routing criteria for contacts in agent queue even though Routing criteria is never activated for contacts in agent queue.
     */
    public val activationTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.activationTimestamp
    /**
     * Information about the index of the routing criteria.
     */
    public val index: kotlin.Int? = builder.index
    /**
     * List of routing steps. When Amazon Connect does not find an available agent meeting the requirements in a step for a given step duration, the routing criteria will move on to the next step sequentially until a join is completed with an agent. When all steps are exhausted, the contact will be offered to any agent in the queue.
     */
    public val steps: List<Step>? = builder.steps

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.RoutingCriteria = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RoutingCriteria(")
        append("activationTimestamp=$activationTimestamp,")
        append("index=$index,")
        append("steps=$steps")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = activationTimestamp?.hashCode() ?: 0
        result = 31 * result + (index ?: 0)
        result = 31 * result + (steps?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RoutingCriteria

        if (activationTimestamp != other.activationTimestamp) return false
        if (index != other.index) return false
        if (steps != other.steps) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.RoutingCriteria = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The timestamp indicating when the routing criteria is set to active. A routing criteria is activated when contact is transferred to a queue. ActivationTimestamp will be set on routing criteria for contacts in agent queue even though Routing criteria is never activated for contacts in agent queue.
         */
        public var activationTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Information about the index of the routing criteria.
         */
        public var index: kotlin.Int? = null
        /**
         * List of routing steps. When Amazon Connect does not find an available agent meeting the requirements in a step for a given step duration, the routing criteria will move on to the next step sequentially until a join is completed with an agent. When all steps are exhausted, the contact will be offered to any agent in the queue.
         */
        public var steps: List<Step>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.RoutingCriteria) : this() {
            this.activationTimestamp = x.activationTimestamp
            this.index = x.index
            this.steps = x.steps
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.RoutingCriteria = RoutingCriteria(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
